<?php


/* Ce script permet de recuperer les rosters contenus dans les fichiers de type xml et de les copier dans une base MySQL
 *  Script pour la migration des rosters des comptes Jabber (jabberd1.4 -> ejabberd)
 *  Le script d'Ejabberd pour la migration des comptes ne gere pas les rosters
 *  Ce script permet ainsi de combler ce manque en inserant les rosters contenus dans les fichiers xml

 * Licence: GNU GPL version 2
   Copyright (C) 2006  Bernard Chomel: bchomel@gmail.com  -  MWSP : www.mwsp.fr

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; version 2
	of the License.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.  
	
 * Encoding: iso-8859-15
 * Langage: PHP5 (contient des Objets)
 * Test sur une plate-forme GNU/Linux Debian + Apache 2.0 + PHP 5.1.6-1 + MySQL 5.0.20-1
 * If you have any questions, you can write me:  bchomel@gmail.com 
 */
?>


<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>
<html xmlns='http://www.w3.org/1999/xhtml' lang='fr' xml:lang'>
<head>
<meta http-equiv="content-type" content="text/html; charset=iso-8859-15" >
<title> Page de migration des Rosters des comptes Jabber (jabberd1.4 vers ejabberd) </title>
 <style type='text/css'>
   body { background-color: #FFF; }
   table { margin-left:auto; margin-right:auto; }
   h1 { font: 1.7em sans-serif; padding:0 0 1em 0px; text-align: center; color: #567; }
   h2 { font: 1.2em sans-serif; padding:20px 25px 0 25px; text-align: center; color: #059; }
   a { font: 1em sans-serif; text-decoration: none; color: #B22; font-weight: bold; text-align:left; padding: 2px; }
   li { text-align:left; padding: 2px; }
   .erreur { color: red; font-size: normal; }
   .mysql { font-size: 13px; }
   .info { font-weight: bold; color: orange; }
   .ok { font-weight: bold; color: green; }
   .vide { background-color: #CCC; }
   .retour { font-size: 13px; }
   table { text-align: center; }
 </style>
</head>
<body> <h1 id='top'> Page de migration des Rosters des comptes Jabber (jabberd1.4 vers ejabberd) </h1>
<ul>
 <li /> <a href='affichage_tables.php#tab_rostergroups'> Accs direct la table Rostergroups </a>
 <li /> <a href='affichage_tables.php#tab_rosterusers'> Accs direct la table Rosterusers </a>
 <li /> <a href='#resume'> Voir un Rsum de l&#39;importation des fichiers XML dans la bdd MySQL (nombre de fichier(s) importe(s) correctement, nombre d'erreur, temps d'xecution </a>    
</ul> 



<?php

// Fichier permettant de stocker les infos de chaque contact contenu dans le Roster
include ('class_roster.php');


/******************************** Parametres a modifier selon la configuration ***********************************/

// Repertoire contenant les fichier xml. Indiquer le chemin absolu du repertoire (ex: /var/spool/jabber)
// Vrifier que vous avez mis les droits requis (droit de lecture pour les fichers xml)
$repertoire = '';

// Date fixe pour viter d'importer de trop vieux fichiers XML (vite d'importer dans la bdd des users "morts")
// On filtre par anne de dernire modification du fichier (jabberd1.4 modifie le fichier  chaque connection)
$annee_minimale = '2004';

// Parametres de connexion a la base MySQL
$user = '';
$password = '';
$server = '';
$bdd = '';


/*********************** Script d'importation des fichiers XML dans la Bdd MySQL  ********************************/

// Connection a la bdd d'ejabberd
$link = @mysql_connect($server, $user, $password) or die("Connexion impossible : " . mysql_error());
@mysql_select_db($bdd) or die("Erreur de slection de la base de donnes");


/* Creation des Objets DOM et Roster
 * On cree un Objet DOM car le chargement des fichiers xml dans SimpleXML
 * (avec simplexml_load_file) pose un probleme de syntaxe a cause du champ xml <vCard>
 * Aprs on importe l'objet DOM dans un objet SimpleXML -> ca marche !
 */
$dom = new DOMDocument('1.0');
$roster = new roster(); // stocke et insere le roster dans la bdd (cf. class_roster.php)

// Variables servant  obtenir des statistiques sur la migration
$nb_erreur_sql = 0;		// nombre d'erreurs gnres lors de l'insertion dans les tables SQL 
$nb_erreur_xml = 0;		// Nombre d'erreurs lors du chargement du fichier XML dans l'objet DOM
$nb_ok = 0;					// Nombre de fichier traits correctement
$nb_info = 0;				// Nombre de fichiers n'ayant aucun contact dans son roster
$nb_vieux_fichiers = 0; // Nombre de fichiers considrs comme trop vieux (ne seront pas traits)
$total_rosterusers_recupere = 0;		// Nombre total de contacts rcuprs dans tous les fichiers XML  
$total_rosterusers_importe = 0;		// Nombre total de contacts imports dans la table RosterUsers de MySQL
$total_rostergroups_recupere = 0;	// Nombre total de contacts ayant un groupe rcuprs dans tous les fichiers XML
$total_rostergroups_importe = 0;		// Nombre total de contacts imports dans la table RosterGroups de MySQL




/* On ouvre et on parcourt le repertoire contenant les fichiers xml.
 * Si on a un nom de fichier correct (on evite les . et ..), on concatene le nom de fichier lu avec le nom du rpertoire. Sinon, un problme peut survenir.
 * Si l'anne de la dernire modification de ce fichier a t antrieure  celle indique dans les paramtres 
 * ($annee_minimale), on passe  un autre fichier. (Ainsi, on importe pas des vieux fichiers inutiliss)
 * On charge le fichier xml (s'il est valide) dans un objet DOM puis on l'importe dans 1 objet SimpleXML afin de le parser.
 * On parse toutes les nodes <query> pour recuperer les infos contenus (username et rosters).
 * On affiche en temps rel dans un tableau si le fichier a bien ete importe ou s'il y a eu une erreur dans MySQL.
 */


// Affichage des resultats du script sous forme de tableau
echo "\n <br /> <h2 id='tab_recapitulatif'> Tableau Rcapitulatif du traitement des fichiers XML </h2> ";
echo "<table border='1'> <tr> <th>Nom du fichier</th> <th>Import Fichier</th> <th>Nb de Roster(s) trouv(s)</th> <th>Nb de Roster(s) import(s) </th> <th> Dure d'importation </tr> \n";

// On chronomtre le temps d'xecution du script (Rcupration et Insertion des Rosters de tous les fichiers XML)
$tps_debut_script = microtime(true);

if ($handle = opendir($repertoire)) {
  while (false !== ($nom_fichier = readdir($handle))) {
      if ($nom_fichier != "." && $nom_fichier != "..") {
	$fichier_xml = $repertoire .'/'. $nom_fichier;
	echo "<tr> \n \t <td>". $nom_fichier ."</td> \n";      //Affichage du nom du fichier qui va etre traite

	// Test si la date de modif est "vieille" -> On affiche que le fichier n'est pas import
	if(date ("Y", filemtime($fichier_xml)) < $annee_minimale) {
	  echo "\t <td> <b class='info'> Fichier NON IMPORTE </b> car inutilis depuis le " .date ("d M Y", filemtime($fichier_xml)).  ". </td> <td colspan='3' class='vide'></td> </tr> \n";
	  $tab_vieux_fichiers[$nb_vieux_fichiers++] = $fichier_xml;   // Recup. du nom du fichier invalide pour l'afficher 
	}
	else {

	  // Test si le fichier xml est valide: Affiche un message d'erreur en cas de pb (sinon, on affichera OK la fin du traitement du fichier)
	  if(@$dom->load($fichier_xml) == NULL) {
	    $tab_fichier_erreur_xml[$nb_erreur_xml++] = $fichier_xml;   // Recup. du nom du fichier invalide pour l'afficher 
	    echo "\t <td> <b class='erreur'> Fichier NON Valide <b> </td> <td colspan='3' class='vide'></td> </tr> \n";  
	  }

	  // Sinon, le fichier est bien charg
	  else {
	    $xml = simplexml_import_dom($dom); // Importation de l'objet DOM dans 1 objet SimpleXML

	    // Les nodes <query> contiennent les infos dont on a besoin (Username et Roster)
	    // Pour chaque node, on recupere soit le username soit le roster en fonction de l'attribut de la node <query>
	    // S'il n'y a pas de node 'jabber:iq:roster', il n'y a pas de roster importer
	    $query = $xml->query;
	    // Initialisation des booleens pour les contrles (Par dfaut, le Roster n'est pas recupere et pas d'erreur)
	    $item_recupere = FALSE;			// Permet de savoir s'il y a des contacts  importer
	    $erreur_rostergroups = FALSE;
	    $erreur_rosterusers = FALSE;
	    echo "\t <td> <b class='ok'> Fichier XML Trait </b> <br /> ";
	    foreach ($query as $node) {

	      // Rcupration du username (il correspond au nom du fichier xml)
	      // Normalement, le username est aussi dans une node du fichier xml, la node n'a pas toujours le mme nom,
	      // il arrive aussi qu'elle soit quelque fois diffrente du nom du fichier. C'est un peu la galre !
	      // Le script d'importation en Erlang utilise aussi le nom de fichier, alors pour avoir une cohrence,
	      // on fait la mme chose ! On supprime donc les 4 derniers caractres de l'extension (.xml)
	      $username = substr($nom_fichier, 0, -4);

	      // On rcupre chaque roster du fichier xml puis on l'insre dans la bdd (tables RosterGroups puis RosterUsers)
	      // On vrifie aussi que l'on n'a pas eu d'erreur renvoyee par MySQL
	      if ($node[xdbns]=='jabber:iq:roster') {	   

		// Initialisation pour savoir combien de roster ont t trouv dans le fichier xml puis import dans la bdd
		// C'est la mme chose qu'au dbut($total_rosterusers_recupere), sauf que ces statistiques sont pour chaque fichier
		$nb_rosterusers_recupere = 0;    
		$nb_rosterusers_importe = 0;
		$nb_rostergroups_recupere = 0;    
		$nb_rostergroups_importe = 0;

		// Dbut du chronomtrage pour chaque fichier XML des insertions de tous les rosters
		$debut_traitement_roster = microtime(true);

		// Recuperation de chaque Roster
		foreach ($node as $item) {
		  $roster->recuperation_roster($item);
		  $nb_rosterusers_recupere++;
		  $item_recupere = TRUE;

		  // Insertion du Roster recupere
		  // Table Rostergroups (Insertion seulement quand le jid est dans un groupe personnalis)
		  if ($roster->grp != '') {
		    $nb_rostergroups_recupere++;	      
		    $erreur_rostergroups = $roster->insertion_rostergroups($username);
		    if ($erreur_rostergroups == FALSE) {
		      $nb_rostergroups_importe++;	      
		    }
		  }

		  // Table Rosterusers
		  $erreur_rosterusers = $roster->insertion_rosterusers($username);
		  if ($erreur_rosterusers == FALSE) {
		    $nb_rosterusers_importe++;	      
		  }
		}
		// Fin du chronomtrage pour chaque fichier XML des insertions de tous les rosters
		$fin_traitement_roster = microtime(true);
	   
		// S'il y a eu une erreur dans l'une des tables, rcupration du nom du fichier invalide pour l'afficher
		// Sinon, on incrmente le nombre de fichier correctement traite
		if ($erreur_rostergroups == TRUE || $erreur_rosterusers == TRUE) {
		  $tab_fichier_erreur_sql[$nb_erreur_sql++] = $fichier_xml;
		}
		else {
		  $nb_ok++;
		}
	      }
	    }
	    
	    // Test pour savoir si l'on a recupr au moins un item du Roster pour cet utilisateur
	    // On affiche alors le nombre de Rosters rcupr(s) et import(s)
	    // On en profite pour incrmenter les totaux des rosters recuprs et imports
	    // Sinon on affiche alors qu'aucun roster n'a t trouv
	    if  ($item_recupere == TRUE ) {
	      echo "\t <td> RosterUsers: ". $nb_rosterusers_recupere. "<br /> RosterGroups: " .$nb_rostergroups_recupere. " </td> <td> RosterUsers: " .$nb_rosterusers_importe. "<br /> RosterGroups: " .$nb_rostergroups_importe. "</td> <td> " .round($fin_traitement_roster - $debut_traitement_roster, 2). " secondes </td> \n </tr> \n";
	      $total_rosterusers_recupere +=  $nb_rosterusers_recupere;
	      $total_rosterusers_importe +=  $nb_rosterusers_importe;
	      $total_rostergroups_recupere +=  $nb_rostergroups_recupere;
	      $total_rostergroups_importe +=  $nb_rostergroups_importe;
	    }
	    else {
	      echo "\t <td colspan='3'> <b class='info'> Aucun Roster  importer </b> </td> </tr> \n";
	      $nb_info++;	
	    }
	  }
	}
      }
  }		 
  closedir($handle);
}

$tps_fin_script = microtime(true);

/***************************************  Affichage du rsum du script *******************************************/
// Tps d'xecution, Nb de fichiers importes, Nb de fichier sans roster et du Nb d'erreurs

echo "</table> \n <h2> Rsum de l'importation des fichiers XML dans la Bdd " .$bdd. " </h2> \n <ul id='resume'> \n <li /> Temps total d'xecution du script (parcours des fichiers XML et insertion dans la base de donnes : <b class='info'> " . round($tps_fin_script - $tps_debut_script, 2) ." secondes </b>" ;

echo "\n <li />  <b class='ok'>". $nb_ok ." fichier(s) </b> ont t correctement imports dans la bdd ".$bdd. ". \n <ul> \n <li /> Nombre de Roster(s) rcupr(s) dans les fichiers XML : <b class='info'>" .$total_rosterusers_recupere. "</b> \n <li /> Nombre de Roster(s) import(s) dans la table ROSTERUSERS : <b class='info'>" .$total_rosterusers_importe. "</b> \n <li /> Nombre de Roster(s) ayant un Groupe rcupr(s) dans les fichiers XML : <b class='info'>" .$total_rostergroups_recupere. "</b> \n <li /> Nombre de Roster(s) import(s) dans la table ROSTERGROUPS : <b class='info'>" .$total_rostergroups_importe. "</b> \n <li id='nb_info' />Nombre de fichiers XML n'ayant aucun roster : <b class='info'>".$nb_info."</b></ul>";

echo "\n <li /> <b class='info'>". ($nb_vieux_fichiers) ." fichier(s) </b> n'ont pas t import(s) dans la bdd ".$bdd." car ils taient trop vieux (la date d'utilisation tait antrieure  " .$annee_minimale. ")<br /> <a href=#liste_vieux_fichiers> Reportez-vous  la liste des vieux fichiers </a>";

echo "\n <li /> <b class='erreur'>". ($nb_erreur_xml+$nb_erreur_sql) ." fichier(s) </b> n'ont pu tre correctement import(s) dans la bdd ".$bdd.". Il se peut qu'une partie du fichier XML soit quand mme importe dans une des tables SQL. <big> Attention, si vous r-excuter ce script, il risque d'y avoir des doublons dans la table ROSTERGROUPS, Aucun contrle PHP, ni SQL n'est fait sur cette table </big> <br /><a href='#tab_recapitulatif'> Reportez vous au tableau rcapitulatif du traitement des fichiers XML pour plus de dtails sur le problme rencontr. </a> </ul>";

echo "\n <br /> \n <a href='#top'>Retour en haut de la page </a> ";

    // Test s'il y a des erreurs, sinon, pas besoin d'afficher !
    if(($nb_erreur_xml+$nb_erreur_sql) > 0) {
      echo "\n <h2> Liste des fichiers ayant eu un problme lors de l'importation </h2> \n";

      // Erreur XML (s'il y en a)
      if($nb_erreur_xml > 0) {
	echo "<ul> Erreur pendant le chargement du fichier XML dans l'objet DOM::Document (le fichier n'est pas un fichier xml ou ne doit pas etre un fichier XML valide): <br /> <b> ". $nb_erreur_xml ." Fichier(s) </b>";
	foreach ($tab_fichier_erreur_xml as $erreur) {
	  echo "<li /> Le fichier <b class='erreur'>". $erreur ." </b>";
	}
	echo "</ul> \n <br /> \n <a href='#top'>Retour en haut de la page </a> ";
      }

      // Erreur SQL (s'il y en a)
      if($nb_erreur_sql > 0) {
	echo "\n <ul> Erreur pendant l'insertion dans l'une des tables SQL (ROSTERGROUPS ou ROSTERUSERS): <b>". $nb_erreur_sql ." Fichier(s) </b>";
	foreach ($tab_fichier_erreur_sql as $erreur) {
	  echo "<li /> <b class='erreur'>". $erreur ." </b>";
	}
	echo "</ul> \n <br /> \n <a href='#top'>Retour en haut de la page </a> ";
      }
    }

      // Fichiers Trop Vieux (s'il y en a)
      if($nb_vieux_fichiers > 0) {
      echo "\n <h2 id='liste_vieux_fichiers'> Liste des fichiers considr(s) comme trop vieux car la date de leur dernire utilisation est antrieure  " .$annee_minimale. " (l'anne limite peut tre modifie) </h2> \n";
		echo "\n <ul> Fichiers trop vieux: <b>". $nb_vieux_fichiers ." Fichier(s) </b>";
	foreach ($tab_vieux_fichiers as $vieux) {
	  echo "<li /> <b class='erreur'>". $vieux ." </b>";
	}
	echo "</ul> \n <br /> \n <a href='#top'>Retour en haut de la page </a> ";
      }

    mysql_close($link);

echo " </body> </html> ";

?>