/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nu.fw.jeti.backend.ConnectionPacketReceiver;
import nu.fw.jeti.backend.JabberHandler;
import nu.fw.jeti.backend.XMPPInputStream;
import nu.fw.jeti.plugins.PluginsInfo;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Input
extends Thread {
    private InputSource in;
    private ConnectionPacketReceiver backend;
    private JabberHandler jH;

    public Input(InputStream inputStream, ConnectionPacketReceiver connectionPacketReceiver, JabberHandler jabberHandler) {
        try {
            this.in = PluginsInfo.isPluginLoaded("xmpp") ? new InputSource(new XMPPInputStream(new InputStreamReader(inputStream, "UTF8"))) : new InputSource(new InputStreamReader(inputStream, "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.backend = connectionPacketReceiver;
        this.jH = jabberHandler;
        this.start();
    }

    public void run() {
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            sAXParser.parse(this.in, (DefaultHandler)this.jH);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXParseException sAXParseException) {
            Exception exception = sAXParseException.getException();
            if (exception != null) {
                exception.printStackTrace();
                return;
            }
            System.out.println(sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            if ("end xmlparser".equals(sAXException.getMessage())) {
                return;
            }
            Exception exception = sAXException.getException();
            if (exception != null) {
                exception.printStackTrace();
                return;
            }
            System.out.println(sAXException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return;
        }
        this.backend.inputDeath();
    }
}

