/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import nu.fw.jeti.events.DiscoveryListener;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.DiscoItem;
import nu.fw.jeti.jabber.elements.DiscoveryInfo;
import nu.fw.jeti.jabber.elements.DiscoveryItem;
import nu.fw.jeti.plugins.groupchat.Plugin;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.QueryServers;
import nu.fw.jeti.util.Utils;

public class GroupchatSignin
extends JFrame {
    private JLabel jLabel1 = new JLabel();
    private JList cmbRoom = new JList();
    private JTextField txtRoom = new JTextField();
    private JTextField txtNick = new JTextField();
    private JLabel jLabel2 = new JLabel();
    private JComboBox cmbChatRoomServer = new JComboBox();
    private JLabel jLabel3 = new JLabel();
    private JPanel jPanel4 = new JPanel();
    private JButton jButton1 = new JButton();
    private JButton btnOK = new JButton();
    private Backend backend;
    private RoomListener roomListener = new RoomListener();
    private ServerListener serverListener = new ServerListener();

    public GroupchatSignin(Backend backend) {
        this.backend = backend;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JID jID = new JID(backend.getMyJID().getDomain());
        backend.getItems(jID, (DiscoveryListener)this.serverListener);
    }

    private void jbInit() throws Exception {
        Object object;
        this.setTitle(I18N.gettext((String)"groupchat.Choose_groupchat_room"));
        this.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
        I18N.setTextAndMnemonic((String)"groupchat.Room", (JLabel)this.jLabel1);
        this.jLabel1.setLabelFor(this.cmbRoom);
        this.txtNick.setPreferredSize(new Dimension(200, 21));
        I18N.setTextAndMnemonic((String)"groupchat.Nickname", (JLabel)this.jLabel2);
        this.jLabel2.setLabelFor(this.txtNick);
        I18N.setTextAndMnemonic((String)"groupchat.Chat_Server", (JLabel)this.jLabel3);
        this.jLabel3.setLabelFor(this.cmbChatRoomServer);
        this.getContentPane().setLayout(new BorderLayout());
        AbstractAction abstractAction = new AbstractAction(I18N.gettext((String)"Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupchatSignin.this.dispose();
            }
        };
        Utils.addCancelButton((RootPaneContainer)this, (JButton)this.jButton1, (Action)abstractAction);
        this.btnOK.setText(I18N.gettext((String)"OK"));
        this.getRootPane().setDefaultButton(this.btnOK);
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupchatSignin.this.btnOK_actionPerformed(actionEvent);
            }
        });
        JComboBox<String> jComboBox = new JComboBox<String>();
        JLabel jLabel = new JLabel();
        I18N.setTextAndMnemonic((String)"groupchat.Server", (JLabel)jLabel);
        jLabel.setLabelFor(jComboBox);
        jComboBox.addItem("");
        jComboBox.addItem(this.backend.getMyJID().getDomain());
        Object object2 = QueryServers.getServers().iterator();
        while (object2.hasNext()) {
            object = (DiscoItem)object2.next();
            jComboBox.addItem(object.getJID().getDomain());
        }
        jComboBox.setSelectedItem(this.backend.getMyJID().getDomain());
        jComboBox.setPreferredSize(new Dimension(200, 21));
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                String string;
                if (itemEvent.getStateChange() == 1 && JID.isValidServer((String)(string = itemEvent.getItem().toString()))) {
                    GroupchatSignin.this.cmbChatRoomServer.removeAllItems();
                    GroupchatSignin.this.backend.getItems(new JID(string), (DiscoveryListener)GroupchatSignin.this.serverListener);
                }
            }
        });
        jComboBox.setEditable(true);
        this.cmbRoom.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object e;
                if (!listSelectionEvent.getValueIsAdjusting() && (e = GroupchatSignin.this.cmbRoom.getSelectedValue()) != null) {
                    GroupchatSignin.this.txtRoom.setText(e.toString());
                }
            }
        });
        this.cmbChatRoomServer.setPreferredSize(new Dimension(200, 21));
        this.cmbChatRoomServer.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Object object;
                if (itemEvent.getStateChange() == 1 && (object = GroupchatSignin.this.cmbChatRoomServer.getSelectedItem()) != null) {
                    if (object instanceof ChatServer) {
                        ChatServer chatServer = (ChatServer)object;
                        GroupchatSignin.this.setChatRoomServer(chatServer.getServer());
                    } else if (!object.equals("")) {
                        GroupchatSignin.this.setChatRoomServer(object.toString());
                    }
                }
            }
        });
        this.cmbChatRoomServer.setEditable(true);
        object2 = new JPanel(new GridBagLayout());
        object = new GridBagConstraints();
        object.anchor = 21;
        object.fill = 2;
        object.insets = new Insets(3, 5, 0, 3);
        ((Container)object2).add((Component)jLabel, object);
        object.weightx = 1.0;
        object.gridwidth = 0;
        ((Container)object2).add(jComboBox, object);
        object.gridwidth = 1;
        object.weightx = 0.0;
        ((Container)object2).add((Component)this.jLabel3, object);
        object.weightx = 1.0;
        object.gridwidth = 0;
        ((Container)object2).add((Component)this.cmbChatRoomServer, object);
        object.gridwidth = 1;
        object.weightx = 0.0;
        ((Container)object2).add((Component)this.jLabel2, object);
        object.weightx = 1.0;
        object.gridwidth = 0;
        ((Container)object2).add((Component)this.txtNick, object);
        object.gridwidth = 1;
        object.weightx = 0.0;
        ((Container)object2).add((Component)this.jLabel1, object);
        object.gridwidth = 0;
        ((Container)object2).add((Component)this.txtRoom, object);
        object.gridwidth = 1;
        object.weightx = 0.0;
        ((Container)object2).add(new JLabel());
        object.gridwidth = 0;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.fill = 1;
        ((Container)object2).add((Component)new JScrollPane(this.cmbRoom), object);
        this.getContentPane().add((Component)object2, "Center");
        this.getContentPane().add((Component)this.jPanel4, "South");
        this.jPanel4.add((Component)this.btnOK, null);
        this.jPanel4.add((Component)this.jButton1, null);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void setChatRoomServer(String string) {
        this.backend.getItems(new JID(string), (DiscoveryListener)this.roomListener, false);
    }

    void btnOK_actionPerformed(ActionEvent actionEvent) {
        String string;
        ChatServer chatServer;
        String string2;
        Room room;
        String string3 = this.txtNick.getText();
        if (string3.equals("")) {
            string3 = this.backend.getMyJID().getUser();
        }
        if ((room = (Room)this.cmbRoom.getSelectedValue()) != null) {
            string2 = room.getJID().getUser();
        } else {
            string2 = this.txtRoom.getText();
            if (!JID.isValidUser((String)string2)) {
                JOptionPane.showMessageDialog(this, I18N.getTextWithAmp((String)"Username_contains_illegal_chars_(see_english_translation)"), I18N.gettext((String)"groupchat.Illegal_group_name"), 0);
                return;
            }
        }
        Object object = this.cmbChatRoomServer.getSelectedItem();
        if (object == null) {
            return;
        }
        if (object instanceof ChatServer) {
            chatServer = (ChatServer)object;
            string = chatServer.getServer();
        } else {
            if (object.equals("")) {
                return;
            }
            string = object.toString();
        }
        chatServer = new JID(string2, string, string3);
        Plugin.startGroupchat((JID)chatServer, this.backend);
        this.dispose();
    }

    static class ChatServer {
        private String name;
        private String server;

        public ChatServer(JID jID, String string) {
            this.server = jID.getDomain();
            this.name = string == null || string.equals("") ? this.server : string;
        }

        public String getServer() {
            return this.server;
        }

        public String toString() {
            return this.name;
        }
    }

    private class ServerListener
    implements DiscoveryListener {
        private ServerListener() {
        }

        public void discoveryInfoResult(JID jID, DiscoveryInfo discoveryInfo) {
            if ("conference".equals(discoveryInfo.getCategory())) {
                GroupchatSignin.this.cmbChatRoomServer.addItem(new ChatServer(jID, discoveryInfo.getName()));
            }
        }

        public void discoveryItemResult(JID jID, DiscoveryItem discoveryItem) {
            if (discoveryItem.hasItems()) {
                Iterator iterator = discoveryItem.getItems();
                while (iterator.hasNext()) {
                    DiscoveryItem discoveryItem2 = (DiscoveryItem)iterator.next();
                    GroupchatSignin.this.backend.getInfo(discoveryItem2.getJID(), (DiscoveryListener)this);
                }
            }
        }
    }

    private static class Room
    implements Comparable {
        String roomName;
        JID roomJID;

        private Room(String string, JID jID) {
            this.roomJID = jID;
            this.roomName = string;
        }

        public JID getJID() {
            return this.roomJID;
        }

        public String toString() {
            return this.roomName;
        }

        public int compareTo(Object object) {
            return this.roomName.compareTo(object.toString());
        }
    }

    private class RoomListener
    implements DiscoveryListener {
        private RoomListener() {
        }

        public void discoveryInfoResult(JID jID, DiscoveryInfo discoveryInfo) {
        }

        public void discoveryItemResult(JID jID, DiscoveryItem discoveryItem) {
            DefaultListModel defaultListModel = new DefaultListModel();
            if (discoveryItem.hasItems()) {
                ArrayList<Room> arrayList = new ArrayList<Room>();
                Iterator iterator = discoveryItem.getItems();
                while (iterator.hasNext()) {
                    DiscoveryItem discoveryItem2 = (DiscoveryItem)iterator.next();
                    arrayList.add(new Room(discoveryItem2.getName(), discoveryItem2.getJID()));
                }
                Collections.sort(arrayList);
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    defaultListModel.addElement(iterator.next());
                }
            }
            GroupchatSignin.this.cmbRoom.setModel(defaultListModel);
        }
    }
}

