/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolTip;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Utilities;
import nu.fw.jeti.backend.roster.NormalJIDStatus;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.PresenceListener;
import nu.fw.jeti.events.StatusChangeListener;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.UnknownJIDStatus;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.IQTime;
import nu.fw.jeti.jabber.elements.IQVersion;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.jabber.elements.MessageBuilder;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.jabber.elements.XData;
import nu.fw.jeti.jabber.elements.XExtension;
import nu.fw.jeti.plugins.Avatars;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.plugins.RosterMenuListener;
import nu.fw.jeti.plugins.groupchat.Actor;
import nu.fw.jeti.plugins.groupchat.DestroyDialog;
import nu.fw.jeti.plugins.groupchat.GroupChatWindows;
import nu.fw.jeti.plugins.groupchat.GroupchatInvite;
import nu.fw.jeti.plugins.groupchat.ManageMembers;
import nu.fw.jeti.plugins.groupchat.Plugin;
import nu.fw.jeti.plugins.groupchat.elements.IQMUCOwnerConfigure;
import nu.fw.jeti.plugins.groupchat.elements.IQMUCSetList;
import nu.fw.jeti.plugins.groupchat.elements.XMUCPassword;
import nu.fw.jeti.plugins.groupchat.elements.XMUCUser;
import nu.fw.jeti.ui.AddContact;
import nu.fw.jeti.ui.ChatSplitPane;
import nu.fw.jeti.ui.SendMessage;
import nu.fw.jeti.ui.StatusButton;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Preferences;

public class GroupchatWindow
extends JPanel
implements PresenceListener,
StatusChangeListener {
    private static final int CHAT_DIVIDER_DEFAULT = 280;
    private ChatSplitPane chatSplitPane;
    private JSplitPane splitPane;
    private JID roomJID;
    private JID fullRoomJID;
    private String me;
    private Backend backend;
    private String toName;
    private MyListModel model;
    private List userNames = new ArrayList();
    private JMenu ownerMenu = new JMenu();
    private JMenu userMenu = new JMenu();
    private JMenu membersMenu = new JMenu();
    private JList lstActors;
    private JPopupMenu actionMenu;
    private JButton btnSend;
    private StatusButton btnStatus;
    private String message;
    private int status;
    private XMUCUser myXMUC = null;
    private boolean isOwner = false;
    private boolean mayManage = false;
    private JTextField txtSubject = new JTextField(I18N.gettext((String)"groupchat.Subject"));
    private boolean isMUCRoom = true;
    private GroupChatWindows groupchatWindows;
    private JFrame window;
    private JMenu[] menu;
    private Avatars avatars;

    public GroupchatWindow(Backend backend, JID jID, GroupChatWindows groupChatWindows, JFrame jFrame) {
        this.groupchatWindows = groupChatWindows;
        this.fullRoomJID = jID;
        this.roomJID = new JID(jID.getUser(), jID.getDomain());
        if (PluginsInfo.isPluginLoaded((String)"groupchatalerter")) {
            if (!nu.fw.jeti.plugins.groupchatalerter.Plugin.isMonitoring((JID)jID)) {
                backend.addPresenceListener(this.roomJID, (PresenceListener)this);
            }
        } else {
            backend.addPresenceListener(this.roomJID, (PresenceListener)this);
        }
        backend.addListener(StatusChangeListener.class, (JETIListener)this);
        this.toName = this.roomJID.toString();
        this.backend = backend;
        this.createMenu();
        if (jFrame == null) {
            this.makeWindow();
            jFrame = this.window;
        }
        this.me = jID.getResource();
        this.chatSplitPane = new ChatSplitPane(backend, this.roomJID, this.toName, this.me, this.userMenu, jFrame);
        this.init();
        if (this.window != null) {
            this.window.setVisible(true);
        }
    }

    public void appendMessage(final Message message) {
        String string = message.getFrom().getResource();
        if (message.getSubject() != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    GroupchatWindow.this.txtSubject.setText(MessageFormat.format(I18N.gettext((String)"groupchat.Subject_{0}"), message.getSubject()));
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else if (string == null) {
            this.chatSplitPane.appendSystemMessage(message.getBody());
        } else {
            this.chatSplitPane.appendMessage(message, string);
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.txtSubject.setEditable(false);
        this.txtSubject.setBorder(null);
        this.txtSubject.setHorizontalAlignment(0);
        this.btnSend = new JButton();
        I18N.setTextAndMnemonic((String)"groupchat.Send", (AbstractButton)this.btnSend);
        this.btnSend.setEnabled(false);
        this.chatSplitPane.getTextInput().setEnabled(false);
        this.btnSend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupchatWindow.this.chatSplitPane.send();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(null);
        JPanel jPanel2 = new JPanel();
        jPanel2.add((Component)this.btnSend, null);
        jPanel.add((Component)this.txtSubject, "North");
        jPanel.add((Component)jPanel2, "South");
        jPanel.add((Component)this.chatSplitPane, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setMinimumSize(new Dimension(0, 22));
        jPanel3.setBorder(null);
        this.model = new MyListModel();
        this.lstActors = new JList(this.model){

            public JToolTip createToolTip() {
                Avatars avatars = GroupchatWindow.this.getAvatar();
                if (avatars != null) {
                    return avatars.createToolTip();
                }
                return super.createToolTip();
            }
        };
        this.lstActors.setSelectionMode(0);
        this.lstActors.setCellRenderer(new MyListRenderer());
        this.lstActors.setFocusable(false);
        ToolTipManager.sharedInstance().registerComponent(this.lstActors);
        JScrollPane jScrollPane = new JScrollPane(this.lstActors);
        jPanel3.add((Component)jScrollPane, "Center");
        Box box = Box.createVerticalBox();
        this.actionMenu = new JPopupMenu();
        MyPopupListener myPopupListener = new MyPopupListener();
        this.lstActors.addMouseListener(myPopupListener);
        this.btnStatus = new StatusButton(this.backend, this.fullRoomJID);
        if (!Preferences.getBoolean((String)"groupchat", (String)"hideGroupchatStatusButton", (boolean)false)) {
            box.add((Component)this.btnStatus);
        }
        jPanel3.add((Component)box, "South");
        this.splitPane = new JSplitPane(1, jPanel, jPanel3);
        this.splitPane.setBorder(null);
        this.add((Component)this.splitPane, "Center");
        this.chatSplitPane.getTextInput().addKeyListener(new KeyAdapter(){
            private String searchText = "jeti";
            private int lastLocation = 0;

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getModifiers() == 2) {
                    if (keyEvent.getKeyCode() == 78) {
                        Actor actor = (Actor)((Object)GroupchatWindow.this.lstActors.getSelectedValue());
                        if (actor != null) {
                            GroupchatWindow.this.addTextToSend("@" + actor.getJID().getResource() + ": ");
                        }
                    } else if (keyEvent.getKeyCode() == 77) {
                        try {
                            char c;
                            int n;
                            JTextPane jTextPane = GroupchatWindow.this.chatSplitPane.getTextInput();
                            int n2 = jTextPane.getCaretPosition();
                            Document document = jTextPane.getDocument();
                            Element element = Utilities.getParagraphElement(jTextPane, n2);
                            int n3 = element.getStartOffset();
                            String string = document.getText(n3, n2);
                            for (n = string.length() - 1; n >= 0 && !Character.isSpace(c = string.charAt(n)); --n) {
                            }
                            String string2 = document.getText(n = n3 + n + 1, n2 - n);
                            if (string2.length() == 0) {
                                Actor actor = (Actor)((Object)GroupchatWindow.this.lstActors.getSelectedValue());
                                if (actor != null) {
                                    GroupchatWindow.this.addTextToSend(actor.getJID().getResource());
                                }
                            } else {
                                if (!(string2 = string2.toLowerCase()).startsWith(this.searchText)) {
                                    this.searchText = string2;
                                    this.lastLocation = 0;
                                }
                                this.searchNick(n, n2);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                    }
                }
            }

            private void searchNick(int n, int n2) {
                if (this.lastLocation >= GroupchatWindow.this.userNames.size()) {
                    this.lastLocation = 0;
                }
                for (int i = this.lastLocation; i < GroupchatWindow.this.userNames.size(); ++i) {
                    String string = (String)GroupchatWindow.this.userNames.get(i);
                    if (!string.toLowerCase().startsWith(this.searchText)) continue;
                    Document document = GroupchatWindow.this.chatSplitPane.getTextInput().getDocument();
                    try {
                        document.remove(n, n2 - n);
                        document.insertString(n, string, null);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    this.lastLocation = i + 1;
                    return;
                }
                this.lastLocation = 0;
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                GroupchatWindow.this.chatSplitPane.requestFocusInWindow();
            }
        });
        this.chatSplitPane.setDividerLocation(Preferences.getInteger((String)"groupchat", (String)"chatDivider", (int)280));
        this.splitPane.setResizeWeight(1.0);
        if (this.window != null) {
            this.splitPane.setDividerLocation(Preferences.getInteger((String)"groupchat", (String)"divider", (int)460));
        } else {
            this.splitPane.setDividerLocation(Preferences.getInteger((String)"groupchat", (String)"TabDivider", (int)460));
        }
    }

    private void createMenu() {
        String string;
        this.menu = new JMenu[3];
        I18N.setTextAndMnemonic((String)"groupchat.User", (AbstractButton)this.userMenu);
        JMenuItem jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"groupchat.Change_nickname", (AbstractButton)jMenuItem, (boolean)true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(GroupchatWindow.this, I18N.gettext((String)"groupchat.Change_nickname_to"), I18N.gettext((String)"groupchat.Change_nickname"), 3);
                if (string == null) {
                    return;
                }
                if (!GroupchatWindow.this.isMUCRoom) {
                    GroupchatWindow.this.me = string;
                    GroupchatWindow.this.fullRoomJID = new JID(GroupchatWindow.this.roomJID.getUser(), GroupchatWindow.this.roomJID.getDomain(), string);
                    GroupchatWindow.this.btnStatus.setJID(GroupchatWindow.this.fullRoomJID);
                }
                GroupchatWindow.this.backend.send((Packet)new Presence(new JID(GroupchatWindow.this.roomJID.getUser(), GroupchatWindow.this.roomJID.getDomain(), string), "available"));
            }
        });
        jMenuItem.setEnabled(false);
        this.userMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"groupchat.Change_Subject", (AbstractButton)jMenuItem, (boolean)true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(GroupchatWindow.this, I18N.gettext((String)"groupchat.Change_room_subject_to"), I18N.gettext((String)"groupchat.Change_subject_to"), 3);
                if (string == null) {
                    return;
                }
                MessageBuilder messageBuilder = new MessageBuilder();
                messageBuilder.subject = string;
                messageBuilder.to = GroupchatWindow.this.roomJID;
                messageBuilder.type = "groupchat";
                GroupchatWindow.this.backend.send(messageBuilder.build());
            }
        });
        jMenuItem.setEnabled(false);
        this.userMenu.add(jMenuItem);
        this.userMenu.addSeparator();
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"groupchat.Invite_user", (AbstractButton)jMenuItem, (boolean)true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupchatInvite.inviteToRoom(GroupchatWindow.this.backend, GroupchatWindow.this.roomJID);
            }
        });
        jMenuItem.setEnabled(false);
        this.userMenu.add(jMenuItem);
        this.userMenu.addSeparator();
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"groupchat.Bookmark_room", (AbstractButton)jMenuItem, (boolean)true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Plugin.addBookmark(GroupchatWindow.this.roomJID, GroupchatWindow.this.fullRoomJID.getResource());
            }
        });
        this.userMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"groupchat.Exit_Room", (AbstractButton)jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupchatWindow.this.savePreferences();
                GroupchatWindow.this.doLeave(true);
            }
        });
        this.userMenu.add(jMenuItem);
        this.menu[0] = this.userMenu;
        Map map = this.backend.getMain().getRosterMenuItems();
        if (map != null && map.containsKey(string = I18N.gettext((String)"messagelog.Show_MessageLog"))) {
            JMenuItem jMenuItem2 = new JMenuItem(string);
            final RosterMenuListener rosterMenuListener = (RosterMenuListener)map.get(string);
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    rosterMenuListener.actionPerformed((JIDStatus)new NormalJIDStatus(GroupchatWindow.this.roomJID, null), null);
                }
            });
            this.userMenu.add(jMenuItem2);
        }
        I18N.setTextAndMnemonic((String)"groupchat.Members", (AbstractButton)this.membersMenu);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"groupchat.Manage_Members", (AbstractButton)jMenuItem, (boolean)true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new ManageMembers(GroupchatWindow.this.backend, GroupchatWindow.this.roomJID, GroupchatWindow.this.model).setVisible(true);
            }
        });
        this.membersMenu.add(jMenuItem);
        jMenuItem.setEnabled(false);
        this.menu[1] = this.membersMenu;
        I18N.setTextAndMnemonic((String)"groupchat.Owner", (AbstractButton)this.ownerMenu);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"groupchat.Configure_Room", (AbstractButton)jMenuItem, (boolean)true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new IQMUCOwnerConfigure(GroupchatWindow.this.backend, GroupchatWindow.this.roomJID);
            }
        });
        jMenuItem.setEnabled(false);
        this.ownerMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"groupchat.Destroy_Room", (AbstractButton)jMenuItem, (boolean)true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new DestroyDialog(GroupchatWindow.this.backend, GroupchatWindow.this.roomJID).setVisible(true);
            }
        });
        jMenuItem.setEnabled(false);
        this.ownerMenu.add(jMenuItem);
        this.menu[2] = this.ownerMenu;
    }

    private void doLeave(boolean bl) {
        this.backend.removeListener(StatusChangeListener.class, (JETIListener)this);
        this.btnStatus.remove();
        this.chatSplitPane.close();
        this.groupchatWindows.removeGroupchat(this.roomJID);
        if (PluginsInfo.isPluginLoaded((String)"groupchatalerter")) {
            if (!nu.fw.jeti.plugins.groupchatalerter.Plugin.isMonitoring((JID)this.roomJID)) {
                this.backend.removeListener(PresenceListener.class, (JETIListener)this);
                if (bl) {
                    this.backend.send((Packet)new Presence(this.fullRoomJID, "unavailable"));
                }
            }
        } else {
            this.backend.removeListener(PresenceListener.class, (JETIListener)this);
            if (bl) {
                this.backend.send((Packet)new Presence(this.fullRoomJID, "unavailable"));
            }
        }
        if (this.window != null) {
            this.window.dispose();
        }
    }

    private void configureActionMenu() {
        Object object;
        Map map;
        this.actionMenu.removeAll();
        final Actor actor = (Actor)((Object)this.lstActors.getSelectedValue());
        String string = actor.getFullJID() != null ? actor.getFullJID().toStringNoResource() : actor.getJID().getResource();
        this.actionMenu.setLabel(string);
        JMenuItem jMenuItem = new JMenuItem(string);
        if (this.me.equals(actor.getJID().getResource())) {
            jMenuItem = new JMenuItem(I18N.gettext((String)"groupchat.Myself"));
            this.actionMenu.add(jMenuItem);
            return;
        }
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"groupchat.Private_message", (AbstractButton)jMenuItem, (boolean)true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JID jID = actor.getJID();
                new SendMessage(GroupchatWindow.this.backend, jID, jID.getUser() + "/" + jID.getResource()).setVisible(true);
            }
        });
        this.actionMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"groupchat.Private_chat", (AbstractButton)jMenuItem, (boolean)true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupchatWindow.this.startChat(actor);
            }
        });
        this.actionMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"main.main.rostermenu.Local_Time", (AbstractButton)jMenuItem, (boolean)true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupchatWindow.this.backend.send((Packet)new InfoQuery(actor.getJID(), "get", (IQExtension)new IQTime()));
            }
        });
        this.actionMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"main.main.rostermenu.Local_Version", (AbstractButton)jMenuItem, (boolean)true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupchatWindow.this.backend.send((Packet)new InfoQuery(actor.getJID(), "get", (IQExtension)new IQVersion()));
            }
        });
        this.actionMenu.add(jMenuItem);
        if (actor.getFullJID() != null) {
            if (null == Backend.getJIDStatus((JID)actor.getFullJID())) {
                jMenuItem = new JMenuItem();
                I18N.setTextAndMnemonic((String)"main.main.jetimenu.Add_Contact", (AbstractButton)jMenuItem, (boolean)true);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        new AddContact(actor.getFullJID(), GroupchatWindow.this.window, GroupchatWindow.this.backend).setVisible(true);
                    }
                });
                this.actionMenu.add(jMenuItem);
            }
        }
        if ((map = this.backend.getMain().getRosterMenuItems()) != null) {
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                RosterMenuListener rosterMenuListener;
                Map.Entry entry = object.next();
                if (((String)entry.getKey()).equals(I18N.gettext((String)"filetransfer.Transfer_File") + "...")) {
                    if (actor.getFullJID() == null) continue;
                    jMenuItem = new JMenuItem((String)entry.getKey());
                    rosterMenuListener = (RosterMenuListener)entry.getValue();
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            rosterMenuListener.actionPerformed((JIDStatus)new UnknownJIDStatus(actor.getFullJID()), null);
                        }
                    });
                    this.actionMenu.add(jMenuItem);
                    continue;
                }
                jMenuItem = new JMenuItem((String)entry.getKey());
                rosterMenuListener = (RosterMenuListener)entry.getValue();
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        rosterMenuListener.actionPerformed((JIDStatus)actor, null);
                    }
                });
                this.actionMenu.add(jMenuItem);
            }
        }
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"groupchat.Add_Nickname_to_Output", (AbstractButton)jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupchatWindow.this.addTextToSend("@" + actor.getJID().getResource() + ": ");
            }
        });
        this.actionMenu.add(jMenuItem);
        object = actor.getJID().getResource();
        if (this.mayManage && actor.getRole() == 5) {
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic((String)"groupchat.Grant_Voice", (AbstractButton)jMenuItem, (boolean)true);
            jMenuItem.addActionListener(new ActionMenuListener((String)object, false, 6));
            this.actionMenu.add(jMenuItem);
        } else if (this.mayManage && actor.getRole() == 6 && actor.getAffiliation() == 0) {
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic((String)"groupchat.Revoke_Voice", (AbstractButton)jMenuItem, (boolean)true);
            jMenuItem.addActionListener(new ActionMenuListener((String)object, false, 5));
            this.actionMenu.add(jMenuItem);
        }
        if (this.mayManage && actor.getAffiliation() == 0 && actor.getRole() != 7) {
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic((String)"groupchat.Kick_User", (AbstractButton)jMenuItem, (boolean)true);
            jMenuItem.addActionListener(new ActionMenuListener((String)object, false, 0));
            this.actionMenu.add(jMenuItem);
        }
        if (this.mayManage && actor.getAffiliation() != 4 && actor.getAffiliation() != 3 && actor.getFullJID() != null) {
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic((String)"groupchat.Ban_User", (AbstractButton)jMenuItem, (boolean)true);
            jMenuItem.addActionListener(new ActionMenuListener(actor.getFullJID(), true, 1));
            this.actionMenu.add(jMenuItem);
        }
        if (this.mayManage && actor.getAffiliation() == 2) {
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic((String)"groupchat.Revoke_Membership", (AbstractButton)jMenuItem, (boolean)true);
            jMenuItem.addActionListener(new ActionMenuListener((String)object, true, 0));
            this.actionMenu.add(jMenuItem);
        }
        if (this.mayManage && (actor.getRole() == 6 || actor.getRole() == 5)) {
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic((String)"groupchat.Grant_Moderator", (AbstractButton)jMenuItem, (boolean)true);
            jMenuItem.addActionListener(new ActionMenuListener((String)object, false, 7));
            this.actionMenu.add(jMenuItem);
        } else if (this.mayManage && actor.getRole() == 7 && (actor.getAffiliation() == 0 || actor.getAffiliation() == 2)) {
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic((String)"groupchat.Revoke_Moderator", (AbstractButton)jMenuItem, (boolean)true);
            jMenuItem.addActionListener(new ActionMenuListener((String)object, false, 6));
            this.actionMenu.add(jMenuItem);
        }
        if (this.mayManage && actor.getFullJID() != null && (actor.getAffiliation() == 0 || actor.getAffiliation() == 2)) {
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic((String)"groupchat.Grant_Admin", (AbstractButton)jMenuItem, (boolean)true);
            jMenuItem.addActionListener(new ActionMenuListener(actor.getFullJID(), true, 3));
            this.actionMenu.add(jMenuItem);
        } else if (this.mayManage && actor.getAffiliation() == 3) {
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic((String)"groupchat.Revoke_Admin", (AbstractButton)jMenuItem, (boolean)true);
            jMenuItem.addActionListener(new ActionMenuListener((String)object, true, 2));
            this.actionMenu.add(jMenuItem);
        }
        if (this.isOwner && actor.getFullJID() != null && (actor.getAffiliation() == 0 || actor.getAffiliation() == 2 || actor.getAffiliation() == 3)) {
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic((String)"groupchat.Grant_Owner", (AbstractButton)jMenuItem, (boolean)true);
            jMenuItem.addActionListener(new ActionMenuListener(actor.getFullJID(), true, 4));
            this.actionMenu.add(jMenuItem);
        } else if (this.isOwner && actor.getAffiliation() == 4 && actor.getFullJID() != null) {
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic((String)"groupchat.Revoke_Owner", (AbstractButton)jMenuItem, (boolean)true);
            jMenuItem.addActionListener(new ActionMenuListener(actor.getFullJID(), true, 3));
            this.actionMenu.add(jMenuItem);
        }
        if (0 == this.actionMenu.getComponentCount()) {
            jMenuItem = new JMenuItem(I18N.gettext((String)"groupchat.No_Actions"));
            this.actionMenu.add(jMenuItem);
        }
    }

    private void doPasswordEntry() {
        String string = JOptionPane.showInputDialog(this, I18N.gettext((String)"groupchat.Password_required_to_join_this_room"), I18N.gettext((String)"groupchat.Password"), 3);
        if (string == null || string.length() == 0) {
            this.groupchatWindows.removeGroupchat(this.roomJID);
            this.chatSplitPane.close();
            if (this.window != null) {
                this.window.dispose();
            }
            return;
        }
        this.backend.send((Packet)new Presence(this.fullRoomJID, 2, null, (XExtension)new XMUCPassword(string)));
    }

    public void connectionChanged(boolean bl) {
        if (!bl) {
            this.model.clear();
        }
    }

    public void ownPresenceChanged(int n, String string) {
    }

    private void setTitle(JID jID) {
        if (this.window != null) {
            this.window.setTitle(jID.toStringNoResource());
        } else {
            this.groupchatWindows.setTitleAt(this, jID);
        }
    }

    private void setIcon(ImageIcon imageIcon) {
        if (this.window != null) {
            this.window.setIconImage(imageIcon.getImage());
        } else {
            this.groupchatWindows.setIconAt(this, imageIcon);
        }
    }

    public JID getJID() {
        return this.fullRoomJID;
    }

    public int getStatus() {
        return this.status;
    }

    public void setLocationOnScreen(GroupchatWindow groupchatWindow) {
        if (groupchatWindow.window != null) {
            this.window.setLocation(groupchatWindow.window.getX() + 50, groupchatWindow.window.getY() + 50);
        }
    }

    public void setLocationOnScreen(int n, int n2) {
        this.window.setLocation(n, n2);
    }

    public void setParentFrame(JFrame jFrame) {
        this.chatSplitPane.setParentFrame(jFrame);
    }

    public JMenu[] getMenu() {
        return this.menu;
    }

    private void makeWindow() {
        this.window = new JFrame();
        this.setIcon(StatusIcons.getStatusIcon((int)this.status));
        this.window.setTitle(this.roomJID.toStringNoResource());
        this.window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GroupchatWindow.this.savePreferences();
                GroupchatWindow.this.groupchatWindows.removeGroupchat(GroupchatWindow.this.fullRoomJID);
                GroupchatWindow.this.exit();
            }
        });
        this.window.addWindowFocusListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                GroupchatWindow.this.requestFocusInWindow();
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        for (int i = 0; i < this.menu.length; ++i) {
            jMenuBar.add(this.menu[i]);
        }
        final JMenuItem jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"main.chat.menu.Convert_to_tab", (AbstractButton)jMenuItem, (boolean)true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupchatWindow.this.savePreferences();
                GroupchatWindow.this.menu[0].remove(jMenuItem);
                GroupchatWindow.this.groupchatWindows.convertToTab(GroupchatWindow.this);
                GroupchatWindow.this.window.dispose();
            }
        });
        this.menu[0].add(jMenuItem);
        if (!Preferences.getBoolean((String)"groupchat", (String)"hideGroupchatMenu", (boolean)false)) {
            this.window.setJMenuBar(jMenuBar);
        }
        this.window.setContentPane(this);
        this.window.setSize(Preferences.getInteger((String)"groupchat", (String)"chatWidth", (int)590), Preferences.getInteger((String)"groupchat", (String)"chatHeigth", (int)460));
    }

    public void changeToWindow() {
        this.makeWindow();
        this.chatSplitPane.setDividerLocation(Preferences.getInteger((String)"groupchat", (String)"chatDivider", (int)200));
        this.splitPane.setDividerLocation(Preferences.getInteger((String)"groupchat", (String)"divider", (int)460));
        this.chatSplitPane.setParentFrame(this.window);
        this.window.setVisible(true);
    }

    public void exit() {
        this.savePreferences();
        this.doLeave(true);
    }

    public void setChatDividerLocation(int n) {
        this.chatSplitPane.setDividerLocation(n);
    }

    public void setDividerLocation(int n) {
        this.splitPane.setDividerLocation(n);
    }

    public void addChatSplitBarListener(ComponentListener componentListener) {
        BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)this.chatSplitPane.getUI()).getDivider();
        basicSplitPaneDivider.addComponentListener(componentListener);
    }

    public void removeChatSplitBarListener(ComponentListener componentListener) {
        BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)this.chatSplitPane.getUI()).getDivider();
        basicSplitPaneDivider.removeComponentListener(componentListener);
    }

    public void addSplitBarListener(ComponentListener componentListener) {
        BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)this.splitPane.getUI()).getDivider();
        basicSplitPaneDivider.addComponentListener(componentListener);
    }

    public void removeSplitBarListener(ComponentListener componentListener) {
        BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)this.splitPane.getUI()).getDivider();
        basicSplitPaneDivider.removeComponentListener(componentListener);
    }

    public void presenceChanged(final Presence presence) {
        Object object;
        Iterator iterator;
        if (presence.getType().equals("error")) {
            if (401 == presence.getErrorCode()) {
                this.doPasswordEntry();
                return;
            }
            if (403 == presence.getErrorCode()) {
                Popups.messagePopup((String)I18N.gettext((String)"groupchat.You_are_banned_from_this_room"), (String)I18N.gettext((String)"groupchat.groupchat"));
                this.doLeave(false);
            } else if (404 == presence.getErrorCode()) {
                Popups.messagePopup((String)I18N.gettext((String)"groupchat.Room_does_not_exist_yet"), (String)I18N.gettext((String)"groupchat.groupchat"));
                this.doLeave(false);
            } else if (405 == presence.getErrorCode()) {
                Popups.messagePopup((String)I18N.gettext((String)"groupchat.You_are_not_allowed_to_create_a_new_room"), (String)I18N.gettext((String)"groupchat.groupchat"));
                this.doLeave(false);
            } else if (406 == presence.getErrorCode()) {
                this.chatSplitPane.appendSystemMessage(presence.getErrorDescription());
            } else if (407 == presence.getErrorCode()) {
                Popups.messagePopup((String)I18N.gettext((String)"groupchat.Members_only_room"), (String)I18N.gettext((String)"groupchat.groupchat"));
                this.doLeave(false);
            } else if (409 == presence.getErrorCode()) {
                String string = null;
                string = Preferences.getBoolean((String)"groupchat", (String)"forcenick", (boolean)false) ? this.me + (int)(Math.random() * 1000.0) : JOptionPane.showInputDialog(this, (Object)I18N.gettext((String)"groupchat.Nickname_in_use,_please_choose_another"));
                this.me = string;
                this.fullRoomJID = new JID(this.roomJID.getUser(), this.roomJID.getDomain(), string);
                this.btnStatus.setJID(this.fullRoomJID);
                this.backend.send((Packet)new Presence(this.fullRoomJID, "available"));
            } else {
                this.chatSplitPane.appendSystemMessage(presence.getErrorDescription());
            }
            return;
        }
        final JID jID = presence.getFrom();
        Object object2 = null;
        if (presence.hasExtensions()) {
            iterator = presence.getExtensions();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof XMUCUser)) continue;
                object2 = (XMUCUser)((Object)object);
                break;
            }
        }
        iterator = object2;
        if (this.me.equals(jID.getResource())) {
            if (iterator != null && ((XMUCUser)((Object)iterator)).getStatusCode() == 303) {
                this.me = ((XMUCUser)((Object)iterator)).getNick();
                this.fullRoomJID = new JID(this.roomJID.getUser(), this.roomJID.getDomain(), this.me);
                this.btnStatus.setJID(this.fullRoomJID);
            } else {
                this.ownPresenceChanged(presence, (XMUCUser)((Object)iterator));
                if (iterator != null && ((XMUCUser)((Object)iterator)).getStatusCode() == 201) {
                    new IQMUCOwnerConfigure(this.backend, this.roomJID, new XData("submit"));
                }
            }
        }
        if (presence.getType().equals("unavailable")) {
            object = new Runnable(){

                public void run() {
                    GroupchatWindow.this.model.removeElement(new Actor(jID));
                    GroupchatWindow.this.userNames.remove(jID.getResource());
                    if (Preferences.getBoolean((String)"groupchat", (String)"showPresence", (boolean)true)) {
                        String string = MessageFormat.format(I18N.gettext((String)"groupchat.{0}_has_left"), jID.getResource());
                        GroupchatWindow.this.chatSplitPane.appendSystemMessage(string);
                    }
                }
            };
            SwingUtilities.invokeLater(object);
        } else {
            object = new Runnable((XMUCUser)((Object)iterator)){
                private final /* synthetic */ XMUCUser val$xMucUser;
                {
                    this.val$xMucUser = xMUCUser;
                }

                public void run() {
                    String string;
                    Actor actor = new Actor(jID);
                    int n = GroupchatWindow.this.model.indexOf(actor);
                    if (n == -1) {
                        actor.update(presence, this.val$xMucUser);
                        GroupchatWindow.this.model.addElement(actor);
                        GroupchatWindow.this.userNames.add(jID.getResource());
                        string = I18N.gettext((String)"groupchat.{0}_has_entered_the_room");
                        string = MessageFormat.format(string, jID.getResource());
                    } else {
                        actor = (Actor)((Object)GroupchatWindow.this.model.getElementAt(n));
                        string = GroupchatWindow.this.getChangeMessage(actor, presence);
                        actor.update(presence, this.val$xMucUser);
                        GroupchatWindow.this.model.updateElement(n);
                    }
                    if (string != null && Preferences.getBoolean((String)"groupchat", (String)"showPresence", (boolean)true)) {
                        GroupchatWindow.this.chatSplitPane.appendSystemMessage(string);
                    }
                }
            };
            SwingUtilities.invokeLater(object);
        }
    }

    private String getChangeMessage(Actor actor, Presence presence) {
        if (actor.getShow() != presence.getShow()) {
            String string = MessageFormat.format(I18N.gettext((String)"groupchat.{0}_changed_state_to_{1}"), presence.getFrom().getResource(), Presence.toLongShow((int)presence.getShow()));
            if (presence.getStatus() != null) {
                string = string + '\n' + MessageFormat.format(I18N.gettext((String)"groupchat.with_status_message_{0}"), presence.getStatus());
            }
            return string;
        }
        if (actor.getStatus() != null && !actor.getStatus().equals(presence.getStatus())) {
            String string = MessageFormat.format(I18N.gettext((String)"groupchat.{0}_changed_status_message_to_{1}"), presence.getFrom().getResource(), presence.getStatus());
            return string;
        }
        return null;
    }

    public void ownPresenceChanged(Presence presence, XMUCUser xMUCUser) {
        this.status = presence.getShow();
        this.message = presence.getStatus();
        this.btnStatus.ownPresenceChanged(this.status, this.message);
        this.myXMUC = xMUCUser;
        Runnable runnable = new Runnable(){

            public void run() {
                GroupchatWindow.this.chatSplitPane.getTextInput().requestFocusInWindow();
                ImageIcon imageIcon = StatusIcons.getStatusIcon((int)GroupchatWindow.this.status);
                if (GroupchatWindow.this.status == 7) {
                    GroupchatWindow.this.model.clear();
                }
                GroupchatWindow.this.setIcon(imageIcon);
                GroupchatWindow.this.setTitle(GroupchatWindow.this.roomJID);
                if (GroupchatWindow.this.myXMUC != null) {
                    int n;
                    if (GroupchatWindow.this.status == 7 && GroupchatWindow.this.myXMUC.getStatusCode() == 307) {
                        GroupchatWindow.this.notifyKicked();
                    }
                    GroupchatWindow.this.isOwner = false;
                    if (4 == GroupchatWindow.this.myXMUC.getAffiliation()) {
                        GroupchatWindow.this.isOwner = true;
                    }
                    for (n = 0; n < GroupchatWindow.this.ownerMenu.getItemCount(); n += 1) {
                        GroupchatWindow.this.ownerMenu.getItem(n).setEnabled(GroupchatWindow.this.isOwner);
                    }
                    GroupchatWindow.this.mayManage = false;
                    if (GroupchatWindow.this.isOwner || 3 == GroupchatWindow.this.myXMUC.getAffiliation() || 7 == GroupchatWindow.this.myXMUC.getRole()) {
                        GroupchatWindow.this.mayManage = true;
                    }
                    for (n = 0; n < GroupchatWindow.this.membersMenu.getItemCount(); n += 1) {
                        GroupchatWindow.this.membersMenu.getItem(n).setEnabled(GroupchatWindow.this.mayManage);
                    }
                    for (n = 0; n < GroupchatWindow.this.userMenu.getItemCount(); n += 1) {
                        if (GroupchatWindow.this.userMenu.getItem(n) == null) continue;
                        GroupchatWindow.this.userMenu.getItem(n).setEnabled(true);
                    }
                    n = 1;
                    if (5 == GroupchatWindow.this.myXMUC.getRole() || 0 == GroupchatWindow.this.myXMUC.getRole()) {
                        n = 0;
                    }
                    GroupchatWindow.this.setSendEnabled(n != 0);
                } else {
                    int n;
                    GroupchatWindow.this.isMUCRoom = false;
                    for (n = 0; n < GroupchatWindow.this.userMenu.getItemCount(); ++n) {
                        if (GroupchatWindow.this.userMenu.getItem(n) == null) continue;
                        GroupchatWindow.this.userMenu.getItem(n).setEnabled(true);
                    }
                    n = 1;
                    GroupchatWindow.this.setSendEnabled(n != 0);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void notifyKicked() {
        String string = I18N.gettext((String)"groupchat.None");
        String string2 = I18N.gettext((String)"groupchat.Thrown_out_from_room");
        if (this.myXMUC != null) {
            if (301 == this.myXMUC.getStatusCode()) {
                string2 = I18N.gettext((String)"groupchat.Banned_from_room");
            }
            if (this.myXMUC.getReason() != null) {
                string = this.myXMUC.getReason();
            }
        }
        String string3 = MessageFormat.format(I18N.gettext((String)"groupchat.Reason_{0}"), string);
        Popups.messagePopup((String)string3, (String)(this.roomJID + ": " + string2));
        this.chatSplitPane.appendSystemMessage(string2 + ". " + string3);
    }

    public void setSendEnabled(boolean bl) {
        if (bl == this.btnSend.isEnabled()) {
            return;
        }
        this.btnSend.setEnabled(bl);
        this.chatSplitPane.getTextInput().setEnabled(bl);
        if (bl) {
            this.chatSplitPane.setDividerLocation(Preferences.getInteger((String)"groupchat", (String)"chatDivider", (int)280));
        } else {
            Preferences.putInteger((String)"groupchat", (String)"chatDivider", (int)this.chatSplitPane.getDividerLocation());
            this.chatSplitPane.setDividerLocation(1.0);
        }
    }

    public void addTextToSend(String string) {
        Document document = this.chatSplitPane.getTextInput().getDocument();
        try {
            document.insertString(document.getLength(), string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    private void startChat(Actor actor) {
        UnknownJIDStatus unknownJIDStatus = new UnknownJIDStatus(actor.getCompleteJID(), actor.getNick());
        this.backend.getMain().startChatResource((JIDStatus)unknownJIDStatus);
    }

    private void savePreferences() {
        if (this.window != null) {
            Preferences.putInteger((String)"groupchat", (String)"chatPosX", (int)this.window.getX());
            Preferences.putInteger((String)"groupchat", (String)"chatPosY", (int)this.window.getY());
            Preferences.putInteger((String)"groupchat", (String)"chatHeigth", (int)this.window.getHeight());
            Preferences.putInteger((String)"groupchat", (String)"chatWidth", (int)this.window.getWidth());
        }
        if (this.btnSend.isEnabled()) {
            Preferences.putInteger((String)"groupchat", (String)"chatDivider", (int)this.chatSplitPane.getDividerLocation());
        }
        Preferences.putInteger((String)"groupchat", (String)"divider", (int)this.splitPane.getDividerLocation());
    }

    private Avatars getAvatar() {
        if (this.avatars != null) {
            return this.avatars;
        }
        if (PluginsInfo.isPluginLoaded((String)"ichatavatars")) {
            this.avatars = (Avatars)PluginsInfo.getPluginInstance((String)"ichatavatars");
            return this.avatars;
        }
        return null;
    }

    class MyListRenderer
    implements ListCellRenderer {
        private JLabel renderer = new JLabel();

        public MyListRenderer() {
            this.renderer.setOpaque(Preferences.getBoolean((String)"jeti", (String)"bmw", (boolean)true));
            this.renderer.setBackground(UIManager.getColor("Tree.selectionBackground"));
            this.renderer.setForeground(UIManager.getColor("Tree.textForeground"));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.renderer.setOpaque(true);
            } else {
                this.renderer.setOpaque(false);
            }
            this.renderer.setText(object.toString());
            return this.makeComponent((Actor)((Object)object));
        }

        private Component makeComponent(Actor actor) {
            Color color;
            int n = actor.getShow();
            switch (actor.getRole()) {
                case 5: {
                    color = Color.DARK_GRAY;
                    break;
                }
                case 7: {
                    color = Color.BLUE;
                    break;
                }
                default: {
                    color = Color.black;
                }
            }
            ImageIcon imageIcon = StatusIcons.getStatusIcon((int)n, (String)actor.getType());
            switch (actor.getAffiliation()) {
                case 4: {
                    imageIcon = this.getImage("owner.gif", imageIcon);
                    break;
                }
                case 3: {
                    imageIcon = this.getImage("admin.gif", imageIcon);
                    break;
                }
                case 2: {
                    imageIcon = this.getImage("admin.gif", imageIcon);
                }
            }
            this.renderer.setIcon(imageIcon);
            this.renderer.setForeground(color);
            this.renderer.setToolTipText(this.getToolTipText(actor));
            return this.renderer;
        }

        private ImageIcon getImage(String string, ImageIcon imageIcon) {
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            Image image = new ImageIcon(this.getClass().getResource(string)).getImage();
            Graphics graphics = ((Image)bufferedImage).getGraphics();
            graphics.drawImage(imageIcon.getImage(), 0, 0, null);
            graphics.drawImage(image, 6, 6, null);
            return new ImageIcon(bufferedImage);
        }

        private String getToolTipText(Actor actor) {
            Avatars avatars = GroupchatWindow.this.getAvatar();
            if (avatars != null) {
                avatars.setToolTipJIDStatus((JIDStatus)actor);
            }
            String string = "<HTML><P> Status: " + Presence.toLongShow((int)actor.getShow());
            if (actor.getStatus() != null) {
                string = string + "</p><p> Status Message: " + actor.getStatus();
            }
            if (actor.getFullJID() != null) {
                string = string + "</p><p> JID: " + actor.getFullJID();
            }
            return string + "</p></HTML>";
        }
    }

    private class ActionMenuListener
    implements ActionListener {
        private JID jid;
        private boolean aff;
        private int value;
        private String nick;

        public ActionMenuListener(JID jID, boolean bl, int n) {
            this.jid = jID;
            this.aff = bl;
            this.value = n;
        }

        public ActionMenuListener(String string, boolean bl, int n) {
            this.nick = string;
            this.aff = bl;
            this.value = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(GroupchatWindow.this.lstActors, I18N.gettext((String)"groupchat.Reason_(optional)"), I18N.gettext((String)"groupchat.Reason"), 3);
            if (string == null) {
                return;
            }
            if (this.jid != null) {
                new IQMUCSetList(GroupchatWindow.this.backend, GroupchatWindow.this.roomJID, this.aff, this.value, this.jid, string);
            } else {
                new IQMUCSetList(GroupchatWindow.this.backend, GroupchatWindow.this.roomJID, this.aff, this.value, this.nick, string);
            }
        }
    }

    class MyPopupListener
    extends MouseAdapter {
        MyPopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Actor actor;
            int n;
            this.maybeShowPopup(mouseEvent);
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                n = GroupchatWindow.this.lstActors.locationToIndex(mouseEvent.getPoint());
                GroupchatWindow.this.lstActors.setSelectedIndex(n);
                if (mouseEvent.getClickCount() == 2) {
                    actor = (Actor)((Object)GroupchatWindow.this.lstActors.getSelectedValue());
                    GroupchatWindow.this.startChat(actor);
                }
            }
            if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                n = GroupchatWindow.this.lstActors.locationToIndex(mouseEvent.getPoint());
                GroupchatWindow.this.lstActors.setSelectedIndex(n);
                actor = (Actor)((Object)GroupchatWindow.this.lstActors.getSelectedValue());
                GroupchatWindow.this.addTextToSend("@" + actor.getJID().getResource() + ": ");
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int n = GroupchatWindow.this.lstActors.locationToIndex(mouseEvent.getPoint());
                GroupchatWindow.this.lstActors.setSelectedIndex(n);
                GroupchatWindow.this.configureActionMenu();
                GroupchatWindow.this.actionMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    static class MyListModel
    extends AbstractListModel {
        private List list = new ArrayList();

        MyListModel() {
        }

        public int getSize() {
            return this.list.size();
        }

        public Object getElementAt(int n) {
            return this.list.get(n);
        }

        public int indexOf(Actor actor) {
            return this.list.indexOf((Object)actor);
        }

        public void removeElement(Actor actor) {
            int n = this.list.indexOf((Object)actor);
            if (n == -1) {
                return;
            }
            this.list.remove((Object)actor);
            this.fireIntervalRemoved(this, n, n);
        }

        public void clear() {
            if (this.list.isEmpty()) {
                return;
            }
            int n = this.list.size();
            this.list.clear();
            this.fireIntervalRemoved(this, 0, n);
        }

        public void addElement(Actor actor) {
            int n = this.list.size();
            this.list.add(actor);
            this.fireIntervalAdded(this, n, n);
        }

        public void updateElement(int n) {
            this.fireContentsChanged(this, n, n);
        }
    }
}

