/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchat.elements;

import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.XDataCallback;
import nu.fw.jeti.jabber.XDataPanel;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.XData;
import nu.fw.jeti.plugins.groupchat.elements.IQMUC;
import nu.fw.jeti.plugins.groupchat.elements.IQMUCInterface;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;

public class IQMUCOwnerConfigure
extends IQMUC
implements IQMUCInterface {
    public IQMUCOwnerConfigure(Backend backend, JID jID) {
        super("owner", backend, jID, null);
        this.send("get", this);
    }

    public IQMUCOwnerConfigure(Backend backend, JID jID, XData xData) {
        super("owner", backend, jID, xData);
        this.send("set", this);
    }

    public void execute(InfoQuery infoQuery, Backend backend, IQMUC iQMUC) {
        if (infoQuery.getType().equals("result")) {
            if (iQMUC.getXData() != null) {
                XDataFrame xDataFrame = new XDataFrame(backend, iQMUC.getXData(), infoQuery.getFrom(), infoQuery.getID());
                xDataFrame.setVisible(true);
            }
        } else if (infoQuery.getType().equals("error")) {
            Popups.errorPopup((String)infoQuery.getErrorDescription(), (String)"Register Error");
        }
    }

    public void timeout() {
    }

    static class XDataFrame
    extends JFrame
    implements XDataCallback {
        private Backend backend;
        private JID jid;

        public XDataFrame(Backend backend, XData xData, JID jID, String string) {
            this.backend = backend;
            this.jid = jID;
            this.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
            if (xData.getTitle() != null) {
                this.setTitle(xData.getTitle());
            } else {
                this.setTitle(I18N.gettext((String)"groupchat.Configure_Room"));
            }
            this.setContentPane((Container)new XDataPanel(xData, (XDataCallback)this));
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    XDataFrame.this.cancelForm();
                }
            });
            this.setSize(550, 700);
        }

        public void sendForm(XData xData) {
            new IQMUCOwnerConfigure(this.backend, this.jid, xData);
            this.dispose();
        }

        public void cancelForm() {
            new IQMUCOwnerConfigure(this.backend, this.jid, new XData("cancel"));
            this.dispose();
        }
    }
}

