/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.xhtml.fontchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.StyleSheet;
import nu.fw.jeti.plugins.xhtml.fontchooser.AttributeComponent;
import nu.fw.jeti.plugins.xhtml.fontchooser.ColorPanel;
import nu.fw.jeti.plugins.xhtml.fontchooser.EffectPanel;
import nu.fw.jeti.plugins.xhtml.fontchooser.TitledPickList;
import nu.fw.jeti.util.I18N;

public class FontPanel
extends JPanel
implements TitledPickList.TitledPickListListener,
ColorPanel.ColorPanelListener {
    JTextField sample = new JTextField();
    private Vector fontComponents = new Vector(0);
    private static StyleSheet styleSheet = new StyleSheet();

    public FontPanel() {
        this.setLayout(new BorderLayout(5, 5));
        this.sample.setText("");
        this.sample.setEditable(false);
        this.sample.setPreferredSize(new Dimension(200, 50));
        this.sample.setHorizontalAlignment(0);
        this.sample.setText(I18N.gettext((String)"xhtml.The_quick_brown_fox_jumped_over_the_lazy_dogs"));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.sample, "Center");
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), I18N.gettext((String)"xhtml.Preview")));
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        FamilyPickList familyPickList = new FamilyPickList(graphicsEnvironment.getAvailableFontFamilyNames(), I18N.gettext((String)"xhtml.Font_Family"));
        familyPickList.addTitledPickListListener(this);
        this.fontComponents.add(familyPickList);
        String[] stringArray = new String[]{"8", "10", "12", "14", "18", "24"};
        SizePickList sizePickList = new SizePickList(stringArray, I18N.gettext((String)"xhtml.Size"));
        sizePickList.addTitledPickListListener(this);
        this.fontComponents.add(sizePickList);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.add((Component)familyPickList, "Center");
        jPanel2.add((Component)sizePickList, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
        jPanel3.add((Component)jPanel2, "Center");
        String[] stringArray2 = new String[]{I18N.gettext((String)"xhtml.Plain"), I18N.gettext((String)"xhtml.Bold"), I18N.gettext((String)"xhtml.Italic"), I18N.gettext((String)"xhtml.BoldItalic")};
        StylePickList stylePickList = new StylePickList(stringArray2, I18N.gettext((String)"xhtml.Style"));
        stylePickList.addTitledPickListListener(this);
        jPanel3.add((Component)stylePickList, "East");
        this.fontComponents.add(stylePickList);
        EffectPanel effectPanel = new EffectPanel();
        this.fontComponents.add(effectPanel);
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1, 3, 3));
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(1), I18N.gettext((String)"xhtml.Color")));
        ColorPanel colorPanel = new ColorPanel(I18N.gettext((String)"xhtml.foreground"), Color.black);
        colorPanel.addColorPanelListener(this);
        this.fontComponents.add(colorPanel);
        ColorPanel colorPanel2 = new ColorPanel(I18N.gettext((String)"xhtml.background"), Color.white);
        colorPanel2.addColorPanelListener(this);
        this.fontComponents.add(colorPanel2);
        jPanel4.add(colorPanel);
        jPanel4.add(colorPanel2);
        this.sample.setForeground(Color.black);
        this.sample.setBackground(Color.white);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)effectPanel, "North");
        jPanel5.add((Component)jPanel4, "South");
        this.add((Component)jPanel3, "Center");
        this.add((Component)jPanel5, "East");
        this.add((Component)jPanel, "South");
        this.add((Component)new JPanel(), "North");
        this.add((Component)new JPanel(), "West");
    }

    public FontPanel(AttributeSet attributeSet) {
        this();
        this.setAttributes(attributeSet);
    }

    public void colorChanged(ColorPanel.ColorPanelEvent colorPanelEvent) {
        ColorPanel colorPanel = (ColorPanel)colorPanelEvent.getSource();
        if (colorPanel.getAttributeKey() == CSS.Attribute.COLOR) {
            this.sample.setForeground(colorPanel.getColor());
        } else if (colorPanel.getAttributeKey() == CSS.Attribute.BACKGROUND_COLOR) {
            this.sample.setBackground(colorPanel.getColor());
        }
    }

    public void setAttributes(AttributeSet attributeSet) {
        Enumeration enumeration = this.fontComponents.elements();
        while (enumeration.hasMoreElements()) {
            ((AttributeComponent)enumeration.nextElement()).setValue(attributeSet);
        }
    }

    public AttributeSet getAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        Enumeration enumeration = this.fontComponents.elements();
        while (enumeration.hasMoreElements()) {
            simpleAttributeSet.addAttributes(((AttributeComponent)enumeration.nextElement()).getValue());
        }
        return simpleAttributeSet;
    }

    public AttributeSet getAttributes(boolean bl) {
        if (bl) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            Enumeration enumeration = this.fontComponents.elements();
            while (enumeration.hasMoreElements()) {
                simpleAttributeSet.addAttributes(((AttributeComponent)enumeration.nextElement()).getValue(bl));
            }
            return simpleAttributeSet;
        }
        return this.getAttributes();
    }

    public void reset() {
        for (int i = 0; i < this.fontComponents.size(); ++i) {
            Object e = this.fontComponents.get(i);
            if (e instanceof FamilyPickList) {
                ((FamilyPickList)e).reset();
                continue;
            }
            if (e instanceof SizePickList) {
                ((SizePickList)e).reset();
                continue;
            }
            if (!(e instanceof StylePickList)) continue;
            ((StylePickList)e).reset();
        }
    }

    public void valueChanged(TitledPickList.TitledPickListEvent titledPickListEvent) {
        Object object = titledPickListEvent.getSource();
        Font font = this.sample.getFont();
        if (object instanceof FamilyPickList) {
            this.sample.setFont(new Font(((FamilyPickList)object).getFamily(), font.getStyle(), font.getSize()));
        } else if (object instanceof SizePickList) {
            this.sample.setFont(new Font(font.getFamily(), font.getStyle(), Integer.parseInt((String)((SizePickList)object).getSelection())));
        } else if (object instanceof StylePickList) {
            this.sample.setFont(new Font(font.getFamily(), ((StylePickList)object).getFontStyle(), font.getSize()));
        }
    }

    static class StylePickList
    extends TitledPickList
    implements AttributeComponent {
        private int setValCount = 0;

        StylePickList(String[] stringArray, String string) {
            super(stringArray, string);
        }

        public boolean setValue(AttributeSet attributeSet) {
            String string;
            this.ignoreTextChanges = true;
            boolean bl = false;
            int n = 0;
            if (attributeSet.isDefined(CSS.Attribute.FONT_WEIGHT) && (string = attributeSet.getAttribute(CSS.Attribute.FONT_WEIGHT).toString()).equalsIgnoreCase(StyleConstants.Bold.toString())) {
                ++n;
            }
            if (attributeSet.isDefined(CSS.Attribute.FONT_STYLE) && (string = attributeSet.getAttribute(CSS.Attribute.FONT_STYLE).toString()).equalsIgnoreCase(StyleConstants.Italic.toString())) {
                n += 2;
            }
            this.setSelection(n);
            if (++this.setValCount < 2) {
                // empty if block
            }
            this.ignoreTextChanges = false;
            return bl;
        }

        public AttributeSet getValue() {
            String string = "Util.CSS_ATTRIBUTE_NORMAL";
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            int n = this.getIndex();
            switch (n) {
                case 0: {
                    styleSheet.addCSSAttribute(simpleAttributeSet, CSS.Attribute.FONT_STYLE, string);
                    break;
                }
                case 1: {
                    styleSheet.addCSSAttribute(simpleAttributeSet, CSS.Attribute.FONT_WEIGHT, StyleConstants.Bold.toString());
                    break;
                }
                case 2: {
                    styleSheet.addCSSAttribute(simpleAttributeSet, CSS.Attribute.FONT_STYLE, StyleConstants.Italic.toString());
                    break;
                }
                case 3: {
                    styleSheet.addCSSAttribute(simpleAttributeSet, CSS.Attribute.FONT_WEIGHT, StyleConstants.Bold.toString());
                    styleSheet.addCSSAttribute(simpleAttributeSet, CSS.Attribute.FONT_STYLE, StyleConstants.Italic.toString());
                }
            }
            return simpleAttributeSet;
        }

        public AttributeSet getValue(boolean bl) {
            if (bl) {
                String string = "CSS_ATTRIBUTE_NORMAL";
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                int n = this.getIndex();
                switch (n) {
                    case 0: {
                        styleSheet.addCSSAttribute(simpleAttributeSet, CSS.Attribute.FONT_STYLE, string);
                        break;
                    }
                    case 1: {
                        styleSheet.addCSSAttribute(simpleAttributeSet, CSS.Attribute.FONT_WEIGHT, StyleConstants.Bold.toString());
                        break;
                    }
                    case 2: {
                        styleSheet.addCSSAttribute(simpleAttributeSet, CSS.Attribute.FONT_STYLE, StyleConstants.Italic.toString());
                        break;
                    }
                    case 3: {
                        styleSheet.addCSSAttribute(simpleAttributeSet, CSS.Attribute.FONT_WEIGHT, StyleConstants.Bold.toString());
                        styleSheet.addCSSAttribute(simpleAttributeSet, CSS.Attribute.FONT_STYLE, StyleConstants.Italic.toString());
                    }
                }
                return simpleAttributeSet;
            }
            return this.getValue();
        }

        public int getFontStyle() {
            int n = 0;
            switch (this.getIndex()) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 3;
                }
            }
            return n;
        }

        public void reset() {
            this.setValCount = 0;
        }
    }

    static class SizePickList
    extends TitledPickList
    implements AttributeComponent {
        private int setValCount = 0;
        private String originalValue;

        SizePickList(String[] stringArray, String string) {
            super(stringArray, string);
        }

        public boolean setValue(AttributeSet attributeSet) {
            String string;
            this.ignoreTextChanges = true;
            boolean bl = false;
            if (attributeSet != null) {
                int n = StyleConstants.getFontSize(attributeSet);
                if (n > 0) {
                    bl = true;
                    string = new Integer(n).toString();
                    this.setSelection(string);
                } else {
                    string = "12";
                    this.setSelection(string);
                }
            } else {
                string = "12";
                this.setSelection(string);
            }
            this.ignoreTextChanges = false;
            if (++this.setValCount < 2) {
                this.originalValue = string;
            }
            return bl;
        }

        public AttributeSet getValue() {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            String string = (String)this.getSelection();
            if (this.originalValue == null && string != null || this.originalValue != null && !this.originalValue.equalsIgnoreCase(string)) {
                StyleConstants.setFontSize(simpleAttributeSet, Integer.parseInt((String)this.getSelection()));
            }
            return simpleAttributeSet;
        }

        public AttributeSet getValue(boolean bl) {
            if (bl) {
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setFontSize(simpleAttributeSet, Integer.parseInt((String)this.getSelection()));
                return simpleAttributeSet;
            }
            return this.getValue();
        }

        public void reset() {
            this.setValCount = 0;
            this.originalValue = null;
        }
    }

    static class FamilyPickList
    extends TitledPickList
    implements AttributeComponent {
        private int setValCount = 0;
        private Object originalValue;

        FamilyPickList(String[] stringArray, String string) {
            super(stringArray, string);
        }

        public boolean setValue(AttributeSet attributeSet) {
            String string;
            boolean bl = false;
            this.ignoreTextChanges = true;
            String string2 = StyleConstants.getFontFamily(attributeSet);
            if (string2 != null) {
                string = string2;
                this.setSelection(string2);
                bl = true;
            } else {
                string = "SansSerif";
                this.setSelection(string);
            }
            this.ignoreTextChanges = false;
            if (++this.setValCount < 2) {
                this.originalValue = string;
            }
            return bl;
        }

        public AttributeSet getValue() {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            Object object = this.getSelection();
            if (this.originalValue == null && object != null || this.originalValue != null && object != null && !this.originalValue.toString().equalsIgnoreCase(object.toString())) {
                StyleConstants.setFontFamily(simpleAttributeSet, object.toString());
            }
            return simpleAttributeSet;
        }

        public AttributeSet getValue(boolean bl) {
            if (bl) {
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                Object object = this.getSelection();
                StyleConstants.setFontFamily(simpleAttributeSet, object.toString());
                return simpleAttributeSet;
            }
            return this.getValue();
        }

        public String getFamily() {
            return (String)this.getSelection();
        }

        public void reset() {
            this.setValCount = 0;
            this.originalValue = null;
        }
    }
}

