/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Window;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nu.fw.jeti.backend.LoginInfo;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.ui.Jeti;
import nu.fw.jeti.ui.LoginStatusWindow;
import nu.fw.jeti.ui.login.LoginWindow;
import nu.fw.jeti.ui.login.ProfileInfo;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Log;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Preferences;
import org.xml.sax.SAXException;

public class Start {
    public static final String VERSION = "0.7.5";
    public static final String OS2 = "";
    public static String BUILD_DATE;
    public static String BUILD_NUM;
    public static URL programURL;
    public static URL dataURL;
    public static String pluginPath;
    public static String path;
    public static boolean applet;
    public static boolean webstart;
    private SAXParser parser;
    private static Splash splash;
    private PluginsInfo pluginsInfo;
    private Backend backend;

    public Start(String string, Container container) {
        Serializable serializable;
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        if (!applet && System.getProperty("jnlpx.home") != null) {
            webstart = true;
        }
        if (string == null) {
            string = this.getPath();
        }
        pluginPath = System.getProperty("file.separator").equals("/") ? string.substring(5) : string.substring(6);
        pluginPath = pluginPath.replace('/', File.separatorChar);
        if (programURL == null) {
            try {
                programURL = new URL(string);
                if (webstart || path != null && path.equals("home")) {
                    path = System.getProperty("user.home") + File.separatorChar + ".jeti" + File.separatorChar;
                    serializable = new File(path);
                    if (!((File)serializable).exists() && !((File)serializable).mkdir()) {
                        JOptionPane.showMessageDialog(null, "Directory " + serializable + " could not be created, Jeti will close");
                        System.exit(1);
                    }
                    dataURL = new URL("file:/" + path);
                } else if (path != null) {
                    serializable = new File(path);
                    if (!((File)serializable).exists() && !((File)serializable).mkdir()) {
                        JOptionPane.showMessageDialog(null, "Directory " + serializable + " could not be created, Jeti will close");
                        System.exit(1);
                    }
                    dataURL = new URL("file:/" + path);
                } else {
                    dataURL = programURL;
                    path = pluginPath;
                }
                System.out.println(programURL);
                System.out.println(dataURL);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        } else {
            dataURL = programURL;
            path = pluginPath;
        }
        try {
            serializable = new Properties();
            ((Properties)serializable).load(this.getClass().getResource("version.properties").openStream());
            BUILD_DATE = ((Properties)serializable).getProperty("buildDate");
            BUILD_NUM = ((Properties)serializable).getProperty("buildNum");
        }
        catch (Exception exception) {
            System.out.println("Can't find the version.properties file");
        }
        this.backend = new Backend(this);
        new Preferences(this.backend, this.parser);
        I18N.init();
        JFrame.setDefaultLookAndFeelDecorated(Preferences.getBoolean("jeti", "javadecorations", false));
        new StatusIcons(this.parser);
        serializable = new Jeti(this.backend, container);
        new Log(this.backend);
        new Popups(this.backend.getMainWindow());
        this.pluginsInfo = new PluginsInfo(this.backend, this.parser, this);
        ((Jeti)serializable).init();
        if (container != null) {
            container.add((Component)serializable);
        } else {
            this.backend.getMainWindow().setVisible(true);
        }
        if (!applet) {
            String string2 = Preferences.getString("jeti", "autoLogin", null);
            if (string2 != null) {
                LoginInfo loginInfo = new ProfileInfo(this.parser).getProfile(string2);
                if (loginInfo != null) {
                    if (loginInfo.getPassword() == null) {
                        LoginWindow.createLoginWindow(this.backend);
                    } else {
                        new LoginStatusWindow(loginInfo, this.backend, 1);
                    }
                }
            } else {
                LoginWindow.createLoginWindow(this.backend);
            }
        }
    }

    public void setSplashText(String string) {
        if (applet) {
            nu.fw.jeti.applet.Jeti.from.setText(I18N.gettext("Loading") + " " + string + "...");
        } else {
            Start.splash.from.setText(I18N.gettext("Loading") + " " + string + "...");
        }
    }

    private String getPath() {
        URL uRL = this.getClass().getResource("Start.class");
        String string = null;
        try {
            string = URLDecoder.decode(uRL.toString(), "UTF8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (uRL.getProtocol().equals("jar")) {
            string = string.substring(4);
            string = string.substring(0, string.lastIndexOf("!"));
            string = string.substring(0, string.lastIndexOf("/") + 1);
        } else {
            string = string.substring(0, string.lastIndexOf("/jeti") + 1);
        }
        return string;
    }

    public static void remoteLoad(URL uRL, String string) {
        pluginPath = string;
        programURL = uRL;
        Start.start(pluginPath, null);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            path = stringArray[0];
        }
        Start.start(null, null);
    }

    public static void start(String string, Container container) {
        Frame frame = new Frame();
        splash = new Splash(frame);
        new Start(string, container);
        splash.dispose();
        frame.dispose();
        splash = null;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public void close() {
        if (this.backend != null) {
            this.backend.getMain().close();
        }
    }

    public void exit() {
        this.pluginsInfo.exit();
        if (applet) {
            nu.fw.jeti.applet.Jeti.exit();
        }
        this.backend = null;
    }

    static {
        applet = false;
        webstart = false;
    }

    static class Splash
    extends Window {
        Label from;

        public Splash(Frame frame) {
            super(frame);
            Label label = new Label("Jeti is Loading...");
            label.setFont(new Font("Serif", 1, 40));
            label.setBackground(new Color(150, 150, 255));
            this.add((Component)label, "Center");
            Panel panel = new Panel();
            panel.setBackground(new Color(255, 255, 150));
            this.from = new Label("(c) 2001-2006 E.S. de Boer");
            this.from.setBackground(new Color(255, 255, 150));
            panel.add(this.from);
            Label label2 = new Label("Version: 0.7.5");
            label2.setBackground(new Color(255, 255, 150));
            panel.add(label2);
            this.add((Component)panel, "South");
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
    }
}

