/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.jabber.elements;

import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.PresenceBuilder;
import nu.fw.jeti.jabber.elements.XExtension;
import nu.fw.jeti.util.I18N;

public class Presence
extends Packet {
    public static final int NONE = 0;
    public static final int FREE_FOR_CHAT = 1;
    public static final int AVAILABLE = 2;
    public static final int AWAY = 3;
    public static final int DND = 4;
    public static final int XA = 5;
    public static final int INVISIBLE = 6;
    public static final int UNAVAILABLE = 7;
    private int show;
    private String status;
    private int priority;
    private String type;

    public Presence(JID jID, String string) {
        super(jID);
        this.type = string;
    }

    public Presence(JID jID, int n, String string, XExtension xExtension) {
        super(jID, (Extension)((Object)xExtension));
        this.setShow(n);
        this.status = string;
    }

    public Presence(JID jID, int n, String string) {
        super(jID);
        this.show = n;
        this.status = string;
        this.setShow(n);
    }

    public Presence(int n, String string, int n2, XExtension xExtension) {
        super((Extension)((Object)xExtension));
        this.setShow(n);
        this.status = string;
        this.priority = n2;
    }

    private void setShow(int n) {
        switch (n) {
            case 6: {
                this.type = "invisible";
                break;
            }
            case 7: {
                this.type = "unavailable";
                break;
            }
            default: {
                this.type = "available";
            }
        }
        this.show = n;
    }

    protected Presence(PresenceBuilder presenceBuilder) {
        super(presenceBuilder);
        this.show = presenceBuilder.show;
        this.status = presenceBuilder.status;
        this.priority = presenceBuilder.priority;
        this.type = presenceBuilder.type;
    }

    public int getShow() {
        return this.show;
    }

    public static String toLongShow(int n) {
        return I18N.gettext(Presence.getI18NKey(n));
    }

    public static String getI18NKey(int n) {
        switch (n) {
            case 1: {
                return "main.presence.Free_for_Chat";
            }
            case 3: {
                return "main.presence.Away";
            }
            case 5: {
                return "main.presence.Extended_Away";
            }
            case 4: {
                return "main.presence.Do_not_Disturb";
            }
            case 0: {
                return "main.presence.Unknown";
            }
            case 7: {
                return "main.presence.Unavailable";
            }
            case 6: {
                return "main.presence.Invisible";
            }
        }
        return "main.presence.Available";
    }

    public String getStatus() {
        return this.status;
    }

    public int getPriorety() {
        return this.priority;
    }

    public String getType() {
        return this.type;
    }

    public void appendToXML(StringBuffer stringBuffer) {
        stringBuffer.append("<presence");
        this.appendBaseAttributes(stringBuffer);
        if (!this.type.equals("available")) {
            Presence.appendAttribute(stringBuffer, "type", this.type);
        }
        stringBuffer.append(">");
        if (this.show != 2 && this.show != 7) {
            switch (this.show) {
                case 1: {
                    Presence.appendElement(stringBuffer, "show", "chat");
                    break;
                }
                case 3: {
                    Presence.appendElement(stringBuffer, "show", "away");
                    break;
                }
                case 5: {
                    Presence.appendElement(stringBuffer, "show", "xa");
                    break;
                }
                case 4: {
                    Presence.appendElement(stringBuffer, "show", "dnd");
                }
            }
        }
        Presence.appendElement(stringBuffer, "status", this.status);
        if (this.priority != 0) {
            Presence.appendElement(stringBuffer, "priority", Integer.toString(this.priority));
        }
        if ("error".equals(this.type)) {
            this.appendError(stringBuffer);
        }
        this.appendExtensions(stringBuffer);
        stringBuffer.append("</presence>");
    }
}

