/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeModel;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.backend.roster.JIDStatusGroup;
import nu.fw.jeti.backend.roster.PrimaryJIDStatus;
import nu.fw.jeti.events.PreferenceListener;
import nu.fw.jeti.events.PresenceListener;
import nu.fw.jeti.events.RosterListener;
import nu.fw.jeti.events.StatusChangeListener;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.UnknownJIDStatus;
import nu.fw.jeti.jabber.elements.IQPrivate;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.JetiPrivateRosterExtension;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.plugins.RosterMenuListener;
import nu.fw.jeti.ui.AboutWindow;
import nu.fw.jeti.ui.AddContact;
import nu.fw.jeti.ui.ChangePassword;
import nu.fw.jeti.ui.ChatWindows;
import nu.fw.jeti.ui.CommentWindow;
import nu.fw.jeti.ui.JIDInput;
import nu.fw.jeti.ui.LogWindow;
import nu.fw.jeti.ui.OptionsWindow;
import nu.fw.jeti.ui.RegisterServices;
import nu.fw.jeti.ui.RosterTree;
import nu.fw.jeti.ui.SendMessage;
import nu.fw.jeti.ui.ServerTree;
import nu.fw.jeti.ui.StatusButton;
import nu.fw.jeti.ui.login.LoginWindow;
import nu.fw.jeti.ui.models.RosterTreeModel;
import nu.fw.jeti.util.FindAction;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;
import nu.fw.jeti.util.TitleTimer;
import nu.fw.jeti.util.TreeModelFilter;
import nu.fw.jeti.util.TreeModelSelector;
import nu.fw.jeti.util.Utils;

public class Jeti
extends JPanel
implements PresenceListener,
StatusChangeListener,
PreferenceListener {
    private RosterTree onlinePanel;
    private RosterTree offlinePanel;
    private JPopupMenu popupMenu;
    private JMenu popdownMenu;
    private JToggleButton btnJeti;
    private StatusButton btnStatus;
    private JPanel pnlMenuButtons;
    private JPanel empty = new JPanel();
    private JScrollPane jScrollPaneTop;
    private JPanel pnlRoster;
    private JSplitPane jSplitPane1;
    private JScrollPane scrollPaneBottom;
    private ServerTree serverPanel;
    private int status;
    private String message = "";
    private List menuItems;
    private JetiFrame jetiFrame;
    private JetiDialog jetiDialog;
    private boolean heightInvalid = true;
    private Map rosterMenuItems = new HashMap(10);
    private ChatWindows chatWindows;
    private Image backgroundImage;
    private Backend backend;
    private static final String TITLE = "Jeti";

    public Jeti(Backend backend, Container container) {
        if (container != null) {
            backend.setMain(this, null, null);
        } else {
            this.jetiFrame = new JetiFrame();
            backend.setMain(this, this.jetiFrame, this.jetiFrame);
            if (Preferences.getBoolean("jeti", "showNotInTaskbar", false)) {
                this.jetiFrame.setIconImage(StatusIcons.getOfflineIcon().getImage());
                this.jetiDialog = new JetiDialog(this.jetiFrame);
                backend.setMain(this, this.jetiDialog, null);
            }
        }
        this.backend = backend;
        backend.addListener(PresenceListener.class, this);
        backend.addListener(StatusChangeListener.class, this);
        backend.addListener(PreferenceListener.class, this);
        RosterTreeModel rosterTreeModel = new RosterTreeModel();
        backend.addListener(RosterListener.class, rosterTreeModel);
        TreeModel treeModel = rosterTreeModel;
        TreeModel treeModel2 = rosterTreeModel;
        if (UIManager.getLookAndFeel().isNativeLookAndFeel()) {
            System.out.println("using mac hack");
            treeModel2 = new TreeModelFilter(rosterTreeModel, new OnlineSelector());
            treeModel = new TreeModelFilter(rosterTreeModel, new OfflineSelector());
        }
        this.onlinePanel = new RosterTree(backend, this, true, treeModel2);
        this.offlinePanel = new RosterTree(backend, this, false, treeModel);
        this.serverPanel = new ServerTree(backend, this);
        this.chatWindows = new ChatWindows(backend);
        this.refreshBackgroundImage();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.btnStatus = new StatusButton(this.backend, this);
        this.pnlMenuButtons = new JPanel();
        this.jScrollPaneTop = new JScrollPane();
        this.pnlRoster = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.scrollPaneBottom = new JScrollPane();
        boolean bl = Preferences.getBoolean("jeti", "bmw", true);
        this.pnlRoster.setOpaque(bl);
        this.onlinePanel.setOpaque(bl);
        this.offlinePanel.setOpaque(bl);
        this.serverPanel.setOpaque(bl);
        this.jSplitPane1.setOpaque(bl);
        this.jScrollPaneTop.setOpaque(bl);
        this.jScrollPaneTop.getViewport().setOpaque(bl);
        this.scrollPaneBottom.setOpaque(bl);
        this.scrollPaneBottom.getViewport().setOpaque(bl);
        this.empty.setOpaque(bl);
        Font font = UIManager.getFont("TitledBorder.font").deriveFont(1);
        this.onlinePanel.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), I18N.gettext("main.main.Online"), 1, 2, font));
        this.offlinePanel.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), I18N.gettext("main.main.Offline"), 1, 2, font));
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.9);
        this.jSplitPane1.setDividerSize(5);
        this.scrollPaneBottom.setMinimumSize(new Dimension(22, 0));
        this.jScrollPaneTop.getViewport().add((Component)this.pnlRoster, null);
        this.pnlMenuButtons.setLayout(new BoxLayout(this.pnlMenuButtons, 0));
        if (Preferences.getBoolean("jeti", "menutop", false)) {
            this.createJetiMenu();
        } else {
            this.createBtnJeti();
            this.pnlMenuButtons.add((Component)this.btnJeti, null);
        }
        this.pnlMenuButtons.add((Component)this.btnStatus, null);
        if (Preferences.getBoolean("jeti", "hideServerPanel", false)) {
            this.add((Component)this.jScrollPaneTop, "Center");
        } else {
            this.add((Component)this.jSplitPane1, "Center");
            this.jSplitPane1.add((Component)this.scrollPaneBottom, "bottom");
            this.scrollPaneBottom.getViewport().add((Component)this.serverPanel, null);
            this.jSplitPane1.add((Component)this.jScrollPaneTop, "top");
        }
        this.add((Component)this.pnlMenuButtons, "South");
        this.pnlRoster.setLayout(new BorderLayout());
        this.pnlRoster.add((Component)this.onlinePanel, "North");
        if (Preferences.getBoolean("jeti", "showoffline", true)) {
            this.pnlRoster.add((Component)this.offlinePanel, "Center");
        } else {
            this.pnlRoster.add((Component)this.empty, "Center");
        }
        if (this.jetiDialog != null) {
            this.jetiDialog.init(this);
        } else if (this.jetiFrame != null) {
            this.jetiFrame.init(this);
        }
        int n = Preferences.getInteger("jeti", "dividerLocation", -10);
        if (n == -10) {
            this.jSplitPane1.setDividerLocation(0.75);
        } else {
            this.jSplitPane1.setDividerLocation(n);
        }
        this.initMenu();
        this.updateLF();
    }

    private void createJetiMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        this.popdownMenu = new JMenu(TITLE);
        this.popdownMenu.setMnemonic('J');
        jMenuBar.add(this.popdownMenu);
        this.jetiFrame.setJMenuBar(jMenuBar);
    }

    private void createBtnJeti() {
        this.btnJeti = new JToggleButton(TITLE);
        this.btnJeti.setMnemonic('J');
        this.btnJeti.setMaximumSize(new Dimension(500, 23));
        this.btnJeti.setMargin(new Insets(0, 0, 0, 0));
        this.btnJeti.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Jeti.this.heightInvalid) {
                    Jeti.this.popupMenu.show(Jeti.this, 0, 0);
                    Jeti.this.popupMenu.setVisible(false);
                    Jeti.this.heightInvalid = false;
                }
                Jeti.this.popupMenu.show(Jeti.this, Jeti.this.btnJeti.getX(), Jeti.this.btnJeti.getY() + Jeti.this.pnlMenuButtons.getY() - Jeti.this.popupMenu.getHeight());
            }
        });
        this.popupMenu = new JPopupMenu();
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                Jeti.this.btnJeti.setSelected(false);
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    public void close() {
        if (this.chatWindows.askIfClose()) {
            this.saveOpenGroups();
            Container container = this.backend.getMainWindow();
            if (container != null && container instanceof Window) {
                ((Window)container).dispose();
            }
            System.out.println("Exiting, closing connection please wait....");
            this.backend.exit();
            this.backend = null;
        }
    }

    private void startChat(final boolean bl) {
        final JDialog jDialog = new JDialog(this.backend.getMainFrame());
        if (bl) {
            jDialog.setTitle(I18N.gettext("main.main.jetimenu.Message"));
        } else {
            jDialog.setTitle(I18N.gettext("main.main.jetimenu.Chat"));
        }
        final JIDInput jIDInput = new JIDInput(this.backend);
        JButton jButton = new JButton(I18N.gettext("OK"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JID jID = jIDInput.createJID();
                if (jID == null) {
                    return;
                }
                if (bl) {
                    new SendMessage(Jeti.this.backend, jID, jID.getUser()).setVisible(true);
                } else {
                    Jeti.this.startChat(jID);
                }
                jDialog.dispose();
            }
        });
        JButton jButton2 = new JButton();
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.setDefaultCloseOperation(2);
        AbstractAction abstractAction = new AbstractAction(I18N.gettext("Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        };
        Utils.addCancelButton(jDialog, jButton2, abstractAction);
        Box box = Box.createVerticalBox();
        box.add(Box.createHorizontalGlue());
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        box.add(jIDInput);
        box.add(jPanel);
        jDialog.getContentPane().add((Component)box, "Center");
        jDialog.pack();
        jDialog.setLocationRelativeTo(this);
        jDialog.setVisible(true);
    }

    public void startChat(JID jID) {
        if (jID == null) {
            return;
        }
        this.chatWindows.chat(new UnknownJIDStatus(jID));
    }

    public void startChatResource(JIDStatus jIDStatus) {
        this.chatWindows.chatResource(jIDStatus);
    }

    public void chat(JIDStatus jIDStatus) {
        this.chatWindows.chat(jIDStatus);
    }

    public void addToMenu(JMenuItem jMenuItem) {
        if (this.menuItems == null) {
            this.menuItems = new LinkedList();
        }
        this.menuItems.add(jMenuItem);
        this.initMenu();
    }

    public Map getRosterMenuItems() {
        return this.rosterMenuItems;
    }

    public void removeFromMenu(JMenuItem jMenuItem) {
        this.menuItems.remove(jMenuItem);
        if (this.menuItems.isEmpty()) {
            this.menuItems = null;
        }
        this.initMenu();
    }

    public void addToRosterMenu(String string, RosterMenuListener rosterMenuListener) {
        this.onlinePanel.addToMenu(string, rosterMenuListener);
        this.offlinePanel.addToMenu(string, rosterMenuListener);
        this.rosterMenuItems.put(string, rosterMenuListener);
    }

    public void removeFromRosterMenu(String string) {
        this.onlinePanel.removeFromMenu(string);
        this.offlinePanel.removeFromMenu(string);
        this.rosterMenuItems.remove(string);
    }

    public void addToOnlineRosterMenu(String string, RosterMenuListener rosterMenuListener) {
        this.onlinePanel.addToMenu(string, rosterMenuListener);
        this.rosterMenuItems.put(string, rosterMenuListener);
    }

    public void removeFromOnlineRosterMenu(String string) {
        this.onlinePanel.removeFromMenu(string);
        this.rosterMenuItems.remove(string);
    }

    public void addToOfflineRosterMenu(String string, RosterMenuListener rosterMenuListener) {
        this.offlinePanel.addToMenu(string, rosterMenuListener);
    }

    public void removeFromOfflineRosterMenu(String string) {
        this.offlinePanel.removeFromMenu(string);
    }

    private void addMenuItem(JMenuItem jMenuItem) {
        if (this.popupMenu != null) {
            this.popupMenu.add(jMenuItem);
        } else {
            this.popdownMenu.add(jMenuItem);
        }
    }

    private void initMenu() {
        Object object;
        if (this.popdownMenu == null && this.popupMenu == null) {
            return;
        }
        if (this.popdownMenu != null) {
            this.popdownMenu.removeAll();
        } else {
            this.popupMenu.removeAll();
        }
        JMenuItem jMenuItem = null;
        JMenu jMenu = null;
        if (Preferences.getBoolean("jeti", "jetimenuShowMessage", true)) {
            jMenuItem = new JMenuItem(I18N.gettext("main.main.jetimenu.Message") + "...");
            I18N.setMnemonic("main.main.jetimenu.Message", jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Jeti.this.startChat(true);
                }
            });
            this.addMenuItem(jMenuItem);
        }
        if (Preferences.getBoolean("jeti", "jetimenuShowChat", true)) {
            jMenuItem = new JMenuItem(I18N.gettext("main.main.jetimenu.Chat") + "...");
            I18N.setMnemonic("main.main.jetimenu.Chat", jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Jeti.this.startChat(false);
                }
            });
            this.addMenuItem(jMenuItem);
        }
        if (Preferences.getBoolean("jeti", "jetimenuShowAddContact", true)) {
            jMenuItem = new JMenuItem(I18N.gettext("main.main.jetimenu.Add_Contact") + "...");
            I18N.setMnemonic("main.main.jetimenu.Add_Contact", jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new AddContact(Jeti.this.backend).setVisible(true);
                }
            });
            this.addMenuItem(jMenuItem);
        }
        if (this.menuItems != null) {
            object = this.menuItems.iterator();
            while (object.hasNext()) {
                JMenuItem jMenuItem2 = (JMenuItem)object.next();
                this.addMenuItem(jMenuItem2);
            }
        }
        jMenuItem = new JMenuItem();
        if (Preferences.getBoolean("jeti", "jetimenuShowLog", true)) {
            I18N.setTextAndMnemonic("main.main.jetimenu.Show_Log", jMenuItem, true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Jeti.this.serverPanel.clearError();
                    new LogWindow(Jeti.this.backend).setVisible(true);
                }
            });
            this.addMenuItem(jMenuItem);
        }
        if (Preferences.getBoolean("jeti", "jetimenuShowOptions", true)) {
            jMenuItem = new JMenuItem(I18N.gettext("main.main.jetimenu.Options") + "...");
            I18N.setMnemonic("main.main.jetimenu.Options", jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new OptionsWindow(Jeti.this.backend).setVisible(true);
                }
            });
            this.addMenuItem(jMenuItem);
        }
        if (Preferences.getBoolean("jeti", "jetimenuShowAccount", true)) {
            jMenu = new JMenu(I18N.gettext("main.main.jetimenu.Account"));
            I18N.setMnemonic("main.main.jetimenu.Account", jMenu);
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic("main.main.jetimenu.Login", jMenuItem, true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!Start.applet) {
                        LoginWindow.createLoginWindow(Jeti.this.backend);
                    } else {
                        new nu.fw.jeti.applet.LoginWindow(Jeti.this.backend).setVisible(true);
                    }
                }
            });
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic("main.main.jetimenu.Manage_Services", jMenuItem, true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new RegisterServices(Jeti.this.backend).setVisible(true);
                }
            });
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic("main.main.jetimenu.Change_Password", jMenuItem, true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new ChangePassword(Jeti.this.backend).setVisible(true);
                }
            });
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic("main.main.jetimenu.Delete_Account", jMenuItem, true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Jeti.this.backend.send(new Packet(){

                        public void appendToXML(StringBuffer stringBuffer) {
                            String string = JOptionPane.showInputDialog(Jeti.this, (Object)I18N.gettext("main.main.jetimenu.Please_enter_your_password_to_delete_your_account"));
                            if (Jeti.this.backend.isPasswordValid(string) && JOptionPane.showConfirmDialog(Jeti.this, I18N.gettext("main.main.jetimenu.Are_you_sure_You_want_to_delete_your_account?")) == 0) {
                                stringBuffer.append("<iq type='set' from='" + Jeti.this.backend.getMyJID() + "' to='" + Jeti.this.backend.getMyJID().getDomain() + "' id='unreg1'> <query xmlns='jabber:iq:register'>" + " <remove/></query></iq>");
                            }
                        }
                    });
                }
            });
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic("main.main.jetimenu.About_this_Account", jMenuItem, true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JOptionPane.showMessageDialog(Jeti.this, Jeti.this.backend.getAccountInfo(), I18N.gettext("main.main.jetimenu.About_this_Account"), 3);
                }
            });
            jMenu.add(jMenuItem);
            this.addMenuItem(jMenu);
        }
        if (Preferences.getBoolean("jeti", "jetimenuShowComment", true)) {
            jMenuItem = new JMenuItem(I18N.gettext("main.main.jetimenu.Comment/Bug"));
            I18N.setMnemonic("main.main.jetimenu.Comment/Bug", jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new CommentWindow(Jeti.this.backend).setVisible(true);
                }
            });
            this.addMenuItem(jMenuItem);
        }
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.main.jetimenu.About", jMenuItem, true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new AboutWindow().setVisible(true);
            }
        });
        this.addMenuItem(jMenuItem);
        if (Preferences.getBoolean("jeti", "jetimenuShowExit", true)) {
            object = new JMenuItem(I18N.gettext("main.main.jetimenu.Exit"));
            I18N.setMnemonic("main.main.jetimenu.Exit", (AbstractButton)object);
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Jeti.this.close();
                }
            });
            this.addMenuItem((JMenuItem)object);
        }
        this.heightInvalid = true;
    }

    protected void saveOpenGroups() {
        List list = this.onlinePanel.getOpenGroups();
        if (list != null) {
            this.backend.send(new InfoQuery("set", new IQPrivate(new JetiPrivateRosterExtension(list.toArray(new String[0])))));
        }
    }

    public void openGroups(final JetiPrivateRosterExtension jetiPrivateRosterExtension) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Jeti.this.onlinePanel.openGroups(jetiPrivateRosterExtension);
                Jeti.this.serverPanel.openGroups();
            }
        });
    }

    public void updateLF() {
        if (this.popupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.popupMenu);
        }
        if (this.popdownMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.popdownMenu);
        }
        this.btnStatus.updateLF();
        this.onlinePanel.updateLF();
        this.offlinePanel.updateLF();
        this.serverPanel.updateLF();
    }

    public void changeOFFlinePanel(boolean bl) {
        if (bl) {
            this.pnlRoster.remove(this.empty);
            this.pnlRoster.add((Component)this.offlinePanel, "Center");
        } else {
            this.pnlRoster.remove(this.offlinePanel);
            this.pnlRoster.add((Component)this.empty, "Center");
        }
        this.pnlRoster.validate();
        this.pnlRoster.repaint();
    }

    public void translate() {
        this.preferencesChanged();
        this.onlinePanel.createPopupMenu();
        this.offlinePanel.createPopupMenu();
        this.onlinePanel.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), I18N.gettext("main.main.Online")));
        this.offlinePanel.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), I18N.gettext("main.main.Offline")));
    }

    public void refreshBackgroundImage() {
        String string = Preferences.getString("jeti", "backgroundImage", null);
        if (string != null) {
            if (Start.applet) {
                try {
                    URL uRL = new URL(string);
                    this.backgroundImage = new ImageIcon(uRL).getImage();
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            } else {
                this.backgroundImage = new ImageIcon(string).getImage();
            }
        }
        this.repaint();
    }

    public void preferencesChanged() {
        this.initMenu();
        StatusButton.reloadMessages();
    }

    public void presenceChanged(Presence presence) {
        JIDStatus jIDStatus = Backend.getJIDStatus(presence.getFrom());
        String string = null;
        if (jIDStatus != null) {
            string = jIDStatus.getNick();
        }
        if (string == null) {
            string = presence.getFrom().getUser();
        }
        if (this.jetiFrame != null) {
            this.jetiFrame.initTimer(string, Presence.toLongShow(presence.getShow()));
        }
    }

    public void ownPresenceChanged(int n, String string) {
        this.status = n;
        this.message = string;
        this.btnStatus.ownPresenceChanged(this.status, this.message);
        Runnable runnable = new Runnable(){

            public void run() {
                if (Jeti.this.jetiFrame != null) {
                    ImageIcon imageIcon = StatusIcons.getStatusIcon(Jeti.this.status);
                    Jeti.this.jetiFrame.setIconImage(imageIcon.getImage());
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void connectionChanged(boolean bl) {
        if (bl) {
            if (this.jetiFrame != null) {
                this.jetiFrame.setTitle(TITLE);
            }
            this.onlinePanel.setVisible(true);
            this.serverPanel.setVisible(true);
        } else {
            this.btnStatus.connectionOffline();
            Runnable runnable = new Runnable(){

                public void run() {
                    Jeti.this.onlinePanel.setVisible(false);
                    Jeti.this.serverPanel.setVisible(false);
                    if (Jeti.this.jetiFrame != null) {
                        Jeti.this.jetiFrame.setTitle(I18N.gettext("main.main.Offline"));
                        Jeti.this.jetiFrame.setIconImage(StatusIcons.getOfflineIcon().getImage());
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void exit() {
        Window window;
        Window window2 = window = this.jetiDialog == null ? this.jetiFrame : this.jetiDialog;
        if (window != null) {
            Preferences.putInteger("jeti", "height", window.getHeight());
            Preferences.putInteger("jeti", "width", window.getWidth());
            Preferences.putInteger("jeti", "posX", window.getX());
            Preferences.putInteger("jeti", "posY", window.getY());
            Preferences.putInteger("jeti", "dividerLocation", this.jSplitPane1.getDividerLocation());
            Preferences.save();
        }
        this.chatWindows.exit();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.backgroundImage != null) {
            if (Preferences.getBoolean("jeti", "backgroundImageScaled", true)) {
                graphics.drawImage(this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), null);
            } else {
                graphics.drawImage(this.backgroundImage, 0, 0, null);
            }
        }
        this.paintChildren(graphics);
    }

    public RosterTree getOnlinePanel() {
        return this.onlinePanel;
    }

    static {
        JTextComponent.getKeymap("default").addActionForKeyStroke(KeyStroke.getKeyStroke(155, 1), new DefaultEditorKit.PasteAction());
        JTextComponent.getKeymap("default").addActionForKeyStroke(KeyStroke.getKeyStroke(155, 2), new DefaultEditorKit.CopyAction());
        JTextComponent.getKeymap("default").addActionForKeyStroke(KeyStroke.getKeyStroke(127, 1), new DefaultEditorKit.CutAction());
        FindAction findAction = new FindAction();
        JTextComponent.getKeymap("default").addActionForKeyStroke(KeyStroke.getKeyStroke(70, 2), findAction);
        JTextComponent.getKeymap("default").addActionForKeyStroke(KeyStroke.getKeyStroke(114, 0), findAction);
    }

    static class OfflineSelector
    implements TreeModelSelector {
        OfflineSelector() {
        }

        public boolean isVisible(Object object) {
            if (object instanceof JIDStatus) {
                return !((JIDStatus)object).isOnline();
            }
            if (object instanceof PrimaryJIDStatus) {
                return ((PrimaryJIDStatus)object).isAJIDstatusOffline();
            }
            if (object instanceof JIDStatusGroup) {
                return true;
            }
            return true;
        }
    }

    static class OnlineSelector
    implements TreeModelSelector {
        OnlineSelector() {
        }

        public boolean isVisible(Object object) {
            if (object instanceof JIDStatus) {
                return ((JIDStatus)object).isOnline();
            }
            if (object instanceof PrimaryJIDStatus) {
                return ((PrimaryJIDStatus)object).getJIDPrimaryStatus().isOnline();
            }
            if (object instanceof JIDStatusGroup) {
                return ((JIDStatusGroup)object).getOnlines() > 0;
            }
            return false;
        }
    }

    static class JetiFrame
    extends JFrame {
        private TitleTimer timer = new TitleTimer(this, "Jeti");

        JetiFrame() {
        }

        public void init(final Jeti jeti) {
            this.setContentPane(jeti);
            this.setIconImage(StatusIcons.getOfflineIcon().getImage());
            this.setTitle(Jeti.TITLE);
            if (PluginsInfo.isPluginLoaded("systemtray")) {
                this.setDefaultCloseOperation(1);
            } else {
                this.setDefaultCloseOperation(0);
                this.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        jeti.close();
                    }
                });
            }
            int n = Preferences.getInteger("jeti", "height", 0);
            int n2 = Preferences.getInteger("jeti", "width", 0);
            if (n == 0 || n2 == 0) {
                this.pack();
            } else {
                this.setSize(n2, n);
            }
            int n3 = Preferences.getInteger("jeti", "posX", 50);
            int n4 = Preferences.getInteger("jeti", "posY", 50);
            int n5 = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
            int n6 = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
            if (n3 > n5) {
                n3 = 50;
            }
            if (n4 > n6) {
                n4 = 50;
            }
            this.setLocation(n3, n4);
        }

        public void initTimer(String string, String string2) {
            this.timer.init(string, string2);
        }
    }

    static class JetiDialog
    extends JDialog {
        public JetiDialog(JFrame jFrame) {
            super(jFrame);
        }

        public void init(final Jeti jeti) {
            this.setContentPane(jeti);
            this.setTitle(Jeti.TITLE);
            if (PluginsInfo.isPluginLoaded("systemtray")) {
                this.setDefaultCloseOperation(1);
            } else {
                this.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        JetiDialog.this.setDefaultCloseOperation(0);
                        jeti.close();
                    }
                });
            }
            int n = Preferences.getInteger("jeti", "height", 0);
            int n2 = Preferences.getInteger("jeti", "width", 0);
            if (n == 0 || n2 == 0) {
                this.pack();
            } else {
                this.setSize(n2, n);
            }
            int n3 = Preferences.getInteger("jeti", "posX", 50);
            int n4 = Preferences.getInteger("jeti", "posY", 50);
            int n5 = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
            int n6 = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
            if (n3 > n5) {
                n3 = 50;
            }
            if (n4 > n6) {
                n4 = 50;
            }
            this.setLocation(n3, n4);
        }
    }
}

