/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import nu.fw.jeti.applet.JetiPrivatePreferencesExtension;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.images.IconPrefPanel;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.IQPrivate;
import nu.fw.jeti.jabber.elements.IQXExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.plugins.PreferencesPanel;
import nu.fw.jeti.ui.PluginsPanel;
import nu.fw.jeti.ui.StdPreferencesPanel;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;
import nu.fw.jeti.util.Utils;

public class OptionsWindow
extends JFrame {
    private JPanel cards = new JPanel(new CardLayout());
    private JTree tree;
    private JPanel jPanel2 = new JPanel();
    private JButton btnApply = new JButton();
    private JButton btnCancel = new JButton();
    private JButton btnOK = new JButton();
    private Map panels = new HashMap();
    private Map nodes = new HashMap();
    private Backend backend;
    private PreferencesPanel pluginPanel;

    public OptionsWindow(Backend backend) {
        this.backend = backend;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.setIconImage(StatusIcons.getImageIcon("jeti").getImage());
        this.setTitle(I18N.gettext("main.options.Options"));
        I18N.setTextAndMnemonic("Apply", this.btnApply);
        this.btnApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsWindow.this.btnApply_actionPerformed(actionEvent);
            }
        });
        AbstractAction abstractAction = new AbstractAction(I18N.gettext("Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsWindow.this.btnCancel_actionPerformed(actionEvent);
            }
        };
        Utils.addCancelButton(this, this.btnCancel, abstractAction);
        this.btnOK.setText(I18N.gettext("OK"));
        this.getRootPane().setDefaultButton(this.btnOK);
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsWindow.this.btnOK_actionPerformed(actionEvent);
            }
        });
        this.setDefaultCloseOperation(2);
        this.jPanel2.add(this.btnOK);
        this.jPanel2.add(this.btnCancel);
        this.jPanel2.add(this.btnApply);
        this.pluginPanel = new PluginsPanel(this);
        this.panels.put(I18N.gettext("main.options.Plugins"), this.pluginPanel);
        this.cards.add((Component)this.pluginPanel, I18N.gettext("main.options.Plugins"));
        PreferencesPanel preferencesPanel = null;
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(I18N.gettext("main.options.Plugins")));
        preferencesPanel = new StdPreferencesPanel(backend);
        this.panels.put(I18N.gettext("main.options.Standard"), preferencesPanel);
        this.cards.add((Component)preferencesPanel, I18N.gettext("main.options.Standard"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(I18N.gettext("main.options.Standard")));
        preferencesPanel = new IconPrefPanel("rostericons");
        this.panels.put(I18N.gettext("main.options.RosterIcons"), preferencesPanel);
        this.cards.add((Component)preferencesPanel, I18N.gettext("main.options.RosterIcons"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(I18N.gettext("main.options.RosterIcons")));
        Object object = PluginsInfo.loadedPreferencePanels.entrySet().iterator();
        while (object.hasNext()) {
            Object object2;
            Object object3;
            Map.Entry entry = object.next();
            try {
                object3 = (Class)entry.getValue();
                object2 = ((Class)object3).getConstructor(class$nu$fw$jeti$jabber$Backend == null ? OptionsWindow.class$("nu.fw.jeti.jabber.Backend") : class$nu$fw$jeti$jabber$Backend);
                preferencesPanel = (PreferencesPanel)((Constructor)object2).newInstance(backend);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break;
            }
            if (preferencesPanel.inhibited()) continue;
            object3 = (String)entry.getKey();
            this.panels.put(object3, preferencesPanel);
            this.cards.add((Component)preferencesPanel, object3);
            object2 = new DefaultMutableTreeNode(object3);
            this.nodes.put(object3, object2);
            defaultMutableTreeNode.add((MutableTreeNode)object2);
        }
        preferencesPanel = null;
        this.tree = new JTree(new DefaultTreeModel(defaultMutableTreeNode));
        this.tree.setPreferredSize(new Dimension(100, 10));
        this.tree.setRootVisible(false);
        this.tree.setBorder(BorderFactory.createEtchedBorder(1));
        object = new DefaultTreeCellRenderer();
        ((DefaultTreeCellRenderer)object).setLeafIcon(null);
        ((DefaultTreeCellRenderer)object).setOpenIcon(null);
        ((DefaultTreeCellRenderer)object).setClosedIcon(null);
        this.tree.setCellRenderer((TreeCellRenderer)object);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)OptionsWindow.this.tree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                String string = (String)defaultMutableTreeNode.getUserObject();
                if (OptionsWindow.this.panels.containsKey(string)) {
                    ((CardLayout)OptionsWindow.this.cards.getLayout()).show(OptionsWindow.this.cards, string);
                }
            }
        });
        this.getContentPane().add((Component)this.cards, "Center");
        this.getContentPane().add((Component)this.tree, "West");
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void removePanel(String string) {
        if (this.panels.containsKey(string)) {
            this.cards.remove((Component)this.panels.get(string));
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
            defaultTreeModel.removeNodeFromParent((DefaultMutableTreeNode)this.nodes.get(string));
            this.nodes.remove(string);
            this.panels.remove(string);
        }
    }

    public void addPanel(String string) {
        Object object;
        Serializable serializable;
        PreferencesPanel preferencesPanel = null;
        try {
            serializable = (Class)PluginsInfo.loadedPreferencePanels.get(string);
            object = ((Class)serializable).getConstructor(Backend.class);
            preferencesPanel = (PreferencesPanel)((Constructor)object).newInstance(this.backend);
        }
        catch (Exception exception) {
            return;
        }
        if (!preferencesPanel.inhibited()) {
            this.panels.put(string, preferencesPanel);
            this.cards.add((Component)preferencesPanel, string);
            serializable = (DefaultTreeModel)this.tree.getModel();
            object = new DefaultMutableTreeNode(string);
            this.nodes.put(string, object);
            ((DefaultTreeModel)serializable).insertNodeInto((MutableTreeNode)object, (MutableTreeNode)((DefaultTreeModel)serializable).getRoot(), ((TreeNode)((DefaultTreeModel)serializable).getRoot()).getChildCount());
        }
    }

    public void savePreferences() {
        Iterator iterator = this.panels.values().iterator();
        while (iterator.hasNext()) {
            PreferencesPanel preferencesPanel = (PreferencesPanel)iterator.next();
            if (preferencesPanel == this.pluginPanel) continue;
            preferencesPanel.savePreferences();
        }
        this.pluginPanel.savePreferences();
        if (Start.applet) {
            this.backend.send(new InfoQuery("set", new IQPrivate((IQXExtension)new JetiPrivatePreferencesExtension(new Preferences()))));
        } else {
            Preferences.save();
        }
    }

    void btnApply_actionPerformed(ActionEvent actionEvent) {
        this.savePreferences();
    }

    void btnCancel_actionPerformed(ActionEvent actionEvent) {
        this.panels = null;
        this.cards.removeAll();
        this.cards = null;
        this.dispose();
    }

    void btnOK_actionPerformed(ActionEvent actionEvent) {
        this.savePreferences();
        this.btnCancel_actionPerformed(null);
    }
}

