/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.util;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import nu.fw.jeti.util.I18N;

public class FindAction
extends AbstractAction {
    private String searchString = null;
    private int startPoint = 0;
    private int endPoint = 0;

    public FindAction() {
        super(I18N.gettext("main.popup.Find"));
        this.putValue("MnemonicKey", new Integer(70));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 2));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (actionEvent != null && (object = actionEvent.getSource()) instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)object;
            if (actionEvent.getModifiers() == 0) {
                if (this.searchString == null) {
                    this.askSearchString(jTextComponent);
                }
                if (this.searchString != null) {
                    this.search(jTextComponent, jTextComponent.getCaretPosition());
                }
            } else {
                this.askSearchString(jTextComponent);
                if (this.searchString != null) {
                    this.search(jTextComponent, 0);
                }
            }
        }
    }

    private void askSearchString(JTextComponent jTextComponent) {
        this.searchString = JOptionPane.showInputDialog(jTextComponent.getTopLevelAncestor(), I18N.gettext("main.popup.Enter_the_text_to_search_for"), jTextComponent.getSelectedText());
    }

    private void search(JTextComponent jTextComponent, int n) {
        String string = jTextComponent.getText();
        string = string.substring(n);
        int n2 = this.searchString.length();
        if (string.indexOf(this.searchString) > -1) {
            this.startPoint = string.indexOf(this.searchString) + n;
            this.endPoint = this.startPoint + n2;
            jTextComponent.requestFocus();
            jTextComponent.setCaretPosition(this.startPoint);
            jTextComponent.moveCaretPosition(this.endPoint);
        } else if (n != 0) {
            if (JOptionPane.showConfirmDialog(jTextComponent.getTopLevelAncestor(), MessageFormat.format(I18N.gettext("main.popup.{0}_not_found_until_the_end_of_this_file,_start_again_from_the_beginning?"), this.searchString)) == 0) {
                this.search(jTextComponent, 0);
            }
        } else {
            JOptionPane.showMessageDialog(jTextComponent.getTopLevelAncestor(), MessageFormat.format(I18N.gettext("main.popup.{0}_not_found"), this.searchString));
        }
    }
}

