/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.xmppuri;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.Translator;
import nu.fw.jeti.plugins.Word;
import nu.fw.jeti.plugins.xmppuri.Server;

public class Plugin
implements Plugins,
Translator {
    public static final String VERSION = "0.1";
    public static final String DESCRIPTION = "xmppuri.Enable_xmpp_links";
    public static final String MIN_JETI_VERSION = "0.7.2";
    public static final String NAME = "xmppuri";
    public static final String ABOUT = "by E.S. de Boer";
    private static Server server;
    private SimpleAttributeSet linkAttributeSet = new SimpleAttributeSet();

    public Plugin() {
        StyleConstants.setForeground(this.linkAttributeSet, Color.green);
        StyleConstants.setUnderline(this.linkAttributeSet, true);
    }

    public static void init(Backend backend) {
        server = new Server(backend);
    }

    public void init(final JTextComponent jTextComponent) {
        jTextComponent.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    int n = jTextComponent.viewToModel(mouseEvent.getPoint());
                    StyledDocument styledDocument = (StyledDocument)jTextComponent.getDocument();
                    AttributeSet attributeSet = styledDocument.getCharacterElement(n).getAttributes();
                    String string = (String)attributeSet.getAttribute("xmpp");
                    if (string != null) {
                        try {
                            server.process(string);
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(jTextComponent, "xmpp processing failed " + exception.getMessage());
                        }
                    }
                }
            }
        });
    }

    public void translate(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Word word = (Word)list.get(i);
            String string = word.word;
            if (!string.startsWith("xmpp:")) continue;
            this.linkAttributeSet.addAttribute("xmpp", string);
            word.addAttributes((AttributeSet)this.linkAttributeSet);
        }
    }

    public void unload() {
    }

    public static void unload(Backend backend) {
        server.unload();
    }
}

