/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.xmppuri;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import javax.swing.JOptionPane;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.UnknownJIDStatus;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.IQRegister;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.plugins.filetransfer.SendFileWindow;
import nu.fw.jeti.plugins.groupchat.Plugin;
import nu.fw.jeti.ui.AddContact;
import nu.fw.jeti.ui.SendMessage;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Log;

public class Server {
    private Backend backend;
    private volatile boolean running = true;
    private Thread server;

    public Server(Backend backend) {
        this.backend = backend;
        this.server = new Thread(){

            public void run() {
                try {
                    ServerSocket serverSocket = new ServerSocket(45943, 10, InetAddress.getLocalHost());
                    while (Server.this.running) {
                        Socket socket = serverSocket.accept();
                        String string = new BufferedReader(new InputStreamReader(socket.getInputStream())).readLine();
                        socket.close();
                        try {
                            Server.this.backend.getMainWindow().setVisible(true);
                            Server.this.process(string);
                        }
                        catch (Exception exception) {
                            Log.notParsedXML((String)("Link processing failed " + exception.getMessage()));
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        };
        this.server.start();
    }

    public void process(String string) throws Exception {
        int n;
        String string2;
        System.out.println(string);
        if (string.startsWith("xmpp:")) {
            string = string.substring(5, string.length());
        }
        JID jID = null;
        if (string.startsWith("//")) {
            string = string.substring(2, string.length());
            string2 = null;
            n = string.indexOf("?");
            int n2 = string.indexOf("/");
            if (n2 < n) {
                string2 = string.substring(0, n2);
                string = string.substring(n2 + 1, string.length());
            } else if (n != -1) {
                string2 = string.substring(0, n);
                string = string.substring(n, string.length());
            } else {
                string2 = string;
                string = "";
            }
            string2 = URLDecoder.decode(string2, "UTF-8");
            try {
                jID = JID.checkedJIDFromString((String)string2);
            }
            catch (InstantiationException instantiationException) {
                Log.notParsedXML((String)("Wrong JID from link " + instantiationException.getMessage()));
            }
        }
        string2 = null;
        n = string.indexOf("?");
        if (n != -1) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1, string.length());
        } else {
            string2 = string;
            string = "";
        }
        string2 = URLDecoder.decode(string2, "UTF-8");
        JID jID2 = null;
        try {
            jID2 = JID.checkedJIDFromString((String)string2);
        }
        catch (InstantiationException instantiationException) {
            Log.notParsedXML((String)("Wrong JID from link " + instantiationException.getMessage()));
        }
        String string3 = null;
        if (string.length() != 0) {
            int n3 = string.indexOf("#");
            if (n3 != -1) {
                string3 = string.substring(0, n3);
                string = string.substring(n3 + 1, string.length());
            } else {
                string3 = string;
            }
        }
        System.out.println(jID);
        System.out.println(jID2);
        System.out.println(string3);
        if (jID2 != null) {
            JIDStatus jIDStatus = Backend.getJIDStatus((JID)jID2);
            if (jIDStatus == null) {
                jIDStatus = new UnknownJIDStatus(jID2);
            }
            if (string3 == null) {
                this.backend.getMain().chat(jIDStatus);
            } else if (string3.startsWith("message")) {
                this.messageAction(string3, jIDStatus);
            } else if (string3.startsWith("roster")) {
                this.rosterAction(jID2, string3);
            } else if (string3.startsWith("join")) {
                this.groupchatAction(jID2);
            } else {
                if (string3.startsWith("invite;")) {
                    return;
                }
                if (string3.startsWith("file")) {
                    if (PluginsInfo.isPluginLoaded((String)"filetransfer")) {
                        new SendFileWindow(this.backend, jID2).setVisible(true);
                    } else {
                        JOptionPane.showMessageDialog(this.backend.getMainWindow(), I18N.gettext((String)"xmppuri.Please_enable_the_filetransfer_plugin_to_send_files"));
                    }
                } else if (string3.startsWith("register")) {
                    this.backend.send((Packet)new InfoQuery(jID2, "get", (IQExtension)new IQRegister()));
                }
            }
        }
    }

    private void groupchatAction(JID jID) {
        if (PluginsInfo.isPluginLoaded((String)"groupchat")) {
            String string;
            if (jID.getResource() != null) {
                Plugin.startGroupchat((JID)jID, (Backend)this.backend);
            }
            if (!(string = JOptionPane.showInputDialog(this.backend.getMainWindow(), (Object)I18N.gettext((String)"groupchat.Please_enter_your_nickname"))).equals("")) {
                JID jID2 = new JID(jID.getUser(), jID.getUser(), string);
                Plugin.startGroupchat((JID)jID2, (Backend)this.backend);
            }
        } else {
            JOptionPane.showMessageDialog(this.backend.getMainWindow(), I18N.gettext((String)"xmppuri.Please_enable_the_groupchat_plugin_to_groupchat"));
        }
    }

    private void rosterAction(JID jID, String string) throws UnsupportedEncodingException {
        String string2 = null;
        String string3 = null;
        if (string.startsWith("roster;")) {
            string = string.substring(7, string.length());
            String[] stringArray = string.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                String string5 = this.getValue(string4);
                if (string5 == null) continue;
                if (string4.startsWith("name")) {
                    string2 = string5;
                    continue;
                }
                if (!string4.startsWith("group")) continue;
                string3 = string5;
            }
        }
        new AddContact(jID, string2, string3, this.backend).setVisible(true);
    }

    private void messageAction(String string, JIDStatus jIDStatus) throws UnsupportedEncodingException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (string.startsWith("message;")) {
            string = string.substring(8, string.length());
            String[] stringArray = string.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                String string5 = stringArray[i];
                String string6 = this.getValue(string5);
                if (string6 == null) continue;
                if (string5.startsWith("subject")) {
                    string2 = string6;
                    continue;
                }
                if (string5.startsWith("body")) {
                    string3 = string6;
                    continue;
                }
                if (!string5.startsWith("type")) continue;
                string4 = string6;
            }
        }
        if ("chat".equals(string4)) {
            this.backend.getMain().chat(jIDStatus);
        } else {
            new SendMessage(this.backend, jIDStatus, string2, string3).setVisible(true);
        }
    }

    private String getValue(String string) throws UnsupportedEncodingException {
        int n = string.indexOf("=");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 1, string.length());
        return URLDecoder.decode(string2, "UTF-8");
    }

    public void unload() {
        this.running = false;
        this.server.interrupt();
    }
}

