/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.xmpp;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.swing.JOptionPane;
import nu.fw.jeti.backend.Connect;
import nu.fw.jeti.backend.ConnectionPacketReceiver;
import nu.fw.jeti.backend.LoginInfo;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.StreamError;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.jabber.handlers.PacketHandler;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.XMPP;
import nu.fw.jeti.plugins.xmpp.DnsSrv;
import nu.fw.jeti.plugins.xmpp.Features;
import nu.fw.jeti.plugins.xmpp.FeaturesHandler;
import nu.fw.jeti.plugins.xmpp.IQBind;
import nu.fw.jeti.plugins.xmpp.IQBindHandler;
import nu.fw.jeti.plugins.xmpp.IQSession;
import nu.fw.jeti.plugins.xmpp.IQSessionHandler;
import nu.fw.jeti.plugins.xmpp.sasl.ChallengeHandler;
import nu.fw.jeti.plugins.xmpp.sasl.ChallengePacket;
import nu.fw.jeti.plugins.xmpp.sasl.SaslClient;
import nu.fw.jeti.plugins.xmpp.sasl.SaslHandler;
import nu.fw.jeti.plugins.xmpp.sasl.SaslMechanismHandler;
import nu.fw.jeti.plugins.xmpp.sasl.SaslMechanisms;
import nu.fw.jeti.plugins.xmpp.sasl.SaslPacket;
import nu.fw.jeti.plugins.xmpp.tls.StartTLSExtensionHandler;
import nu.fw.jeti.plugins.xmpp.tls.StartTlsPacket;
import nu.fw.jeti.plugins.xmpp.tls.StartTlsPacketHandler;
import nu.fw.jeti.util.Base64;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Log;
import nu.fw.jeti.util.Preferences;

public class Plugin
implements Plugins,
ConnectionPacketReceiver,
XMPP,
CallbackHandler {
    public static final String VERSION = "0.1";
    public static final String DESCRIPTION = "xmpp.XMPP_implementation";
    public static final String MIN_JETI_VERSION = "0.7.5";
    public static final String NAME = "xmpp";
    public static final String ABOUT = "by E.S. de Boer";
    private Connect connect;
    private LoginInfo loginInfo;
    private String connectionId;
    private JID jid;
    private int state = TLS;
    private static int TLS = 0;
    private static int SASL = 1;
    private static int BIND = 2;
    private boolean secure = false;
    private SaslClient saslClient;

    public static void init(Backend backend) {
        backend.addExtensionHandler("urn:ietf:params:xml:ns:xmpp-tls", (ExtensionHandler)new StartTLSExtensionHandler());
        backend.addExtensionHandler("urn:ietf:params:xml:ns:xmpp-sasl", (ExtensionHandler)new SaslMechanismHandler());
        backend.addExtensionHandler("urn:ietf:params:xml:ns:xmpp-bind", (ExtensionHandler)new IQBindHandler());
        backend.addExtensionHandler("urn:ietf:params:xml:ns:xmpp-session", (ExtensionHandler)new IQSessionHandler());
    }

    public ConnectionPacketReceiver getConnectionPacketReceiver(LoginInfo loginInfo, Connect connect) {
        this.state = TLS;
        this.secure = false;
        this.jid = null;
        this.loginInfo = loginInfo;
        this.connect = connect;
        return this;
    }

    public String resolveXMPPDomain(String string) {
        return DnsSrv.resolveXMPPDomain(string);
    }

    public Map getXMPPHandlers() {
        HashMap<String, PacketHandler> hashMap = new HashMap<String, PacketHandler>();
        hashMap.put("stream:features", new FeaturesHandler());
        hashMap.put("proceed", new StartTlsPacketHandler(false));
        hashMap.put("failure", new StartTlsPacketHandler(true));
        hashMap.put("success", new SaslHandler(true));
        hashMap.put("auth", new SaslHandler());
        hashMap.put("challenge", new ChallengeHandler());
        return hashMap;
    }

    public void connected(String string, String string2) {
        this.connectionId = string;
        System.out.println("connected");
    }

    private void doTls() {
        System.out.println("doingtls");
        new Thread(){

            public void run() {
                Plugin.this.secure = true;
                System.out.println("secure set" + Plugin.this.secure);
                Plugin.this.secure = Plugin.this.connect.startTls((ConnectionPacketReceiver)Plugin.this);
            }
        }.start();
        throw new UnsupportedOperationException("end xmlparser");
    }

    private void startSasl(SaslMechanisms saslMechanisms) {
        if (Preferences.getBoolean((String)NAME, (String)"anonymousLogin", (boolean)false)) {
            if (saslMechanisms.getMechanisms().contains("ANONYMOUS")) {
                this.connect.sendWhileConnecting((Packet)new SaslPacket("ANONYMOUS"));
            } else {
                this.connect.sendLoginError("No Anonymous login possible");
            }
        }
        if (System.getProperty("java.version").indexOf("1.5") != -1) {
            String[] stringArray = saslMechanisms.getMechanisms().toArray(new String[saslMechanisms.getMechanisms().size()]);
            try {
                SaslClient saslClient = new SaslClient(Sasl.createSaslClient(stringArray, null, NAME, this.loginInfo.getServer(), null, this));
                byte[] byArray = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(new byte[0]) : null;
                String string = null;
                System.out.println("res made");
                if (byArray != null) {
                    string = Base64.encodeBytes((byte[])byArray);
                }
                this.saslClient = saslClient;
                System.out.println("ready to send");
                this.connect.sendWhileConnecting((Packet)new SaslPacket(saslClient.getMechanismName(), string));
                System.out.println("auth packet send");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.connect.sendLoginError(exception.getMessage());
            }
        } else if (saslMechanisms.getMechanisms().contains("PLAIN")) {
            int n;
            System.out.println("secure read" + this.secure);
            if (!this.secure && (n = JOptionPane.showConfirmDialog(null, I18N.gettext((String)"main.loginstatus.Sending_password_as_plain_text_over_an_unencrypted_connection,_continue?"), "Plain text", 0)) == 1) {
                this.connect.sendLoginError("Sending password in plain not allowed");
                return;
            }
            String string = this.loginInfo.getUsername() + "@" + this.loginInfo.getServer() + '\u0000' + this.loginInfo.getUsername() + '\u0000' + this.loginInfo.getPassword();
            this.connect.sendWhileConnecting((Packet)new SaslPacket("PLAIN", Base64.encodeBytes((byte[])string.getBytes())));
        }
    }

    public void respond(ChallengePacket challengePacket) {
        if (this.saslClient == null) {
            this.connect.sendLoginError("Sasl challenge failed, no saslclient");
            return;
        }
        try {
            final byte[] byArray = this.saslClient.evaluateChallenge(Base64.decode((String)challengePacket.getChallenge()));
            this.connect.sendWhileConnecting(new Packet(){

                public void appendToXML(StringBuffer stringBuffer) {
                    stringBuffer.append("<response xmlns='urn:ietf:params:xml:ns:xmpp-sasl'>");
                    if (byArray != null) {
                        stringBuffer.append(Base64.encodeBytes((byte[])byArray));
                    }
                    stringBuffer.append("</response>");
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.connect.sendLoginError(exception.getMessage());
        }
    }

    public void handle(Callback[] callbackArray) {
        for (int i = 0; i < callbackArray.length; ++i) {
            Callback callback = callbackArray[i];
            if (callback instanceof RealmCallback) {
                String string = ((RealmCallback)callback).getDefaultText();
                System.out.println(string);
                ((RealmCallback)callback).setText(string);
                System.out.println("realm");
                continue;
            }
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.loginInfo.getUsername());
                System.out.println("simple name");
                continue;
            }
            if (callback instanceof PasswordCallback) {
                System.out.println("passw");
                ((PasswordCallback)callback).setPassword(this.loginInfo.getPassword().toCharArray());
                continue;
            }
            this.connect.sendLoginError("Sasl negotion failed");
            System.err.println(callback.toString());
        }
    }

    private void doBind() {
        System.out.println("binding");
        if (Preferences.getBoolean((String)NAME, (String)"anonymousLogin", (boolean)false)) {
            this.connect.sendWhileConnecting((Packet)new InfoQuery("get", (IQExtension)new IQBind()));
        }
        this.connect.sendWhileConnecting((Packet)new InfoQuery("set", (IQExtension)new IQBind(this.loginInfo.getResource())));
    }

    public void outputDeath() {
        System.out.println("output death");
    }

    public void inputDeath() {
        System.out.println("input death");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void receivePackets(Packet packet) {
        if (packet instanceof StreamError) {
            this.connect.streamError((StreamError)packet);
            return;
        }
        if (this.connect.isAborted()) {
            return;
        }
        if (packet instanceof Features) {
            Features features = (Features)packet;
            System.out.println("features " + (Object)((Object)features) + " state" + this.state);
            if (this.state == TLS && features.hasTls()) {
                this.state = SASL;
                this.connect.sendWhileConnecting((Packet)new StartTlsPacket());
                return;
            }
            if (this.state == TLS || this.state == SASL) {
                this.state = BIND;
                if (features.hasSaslMechanisms()) {
                    this.startSasl(features.getSaslMechanisms());
                    return;
                }
                this.connect.connected(this.connectionId, null);
                return;
            }
            if (features.hasBind()) {
                this.doBind();
                return;
            }
            if (this.state == BIND) {
                JID jID = new JID(this.loginInfo.getUsername().toLowerCase(), this.loginInfo.getServer(), this.loginInfo.getResource());
                this.connect.authenticated(jID);
                return;
            }
            this.connect.connected(this.connectionId, null);
            return;
        }
        if (packet instanceof StartTlsPacket) {
            StartTlsPacket startTlsPacket = (StartTlsPacket)packet;
            if (!startTlsPacket.hasFailed()) {
                this.doTls();
                return;
            }
            if (this.state == SASL) {
                this.connect.sendLoginError("TLS negotion failed");
                return;
            }
            if (this.state != BIND) {
                Log.xmlReceivedError((String)"Something other then tls or sasl failed");
                return;
            }
            this.connect.sendLoginError("Wrong password");
            String string = startTlsPacket.getError();
            if ("incorrect-encoding".equals(string)) {
                this.connect.sendLoginError("Bug in Jeti, please report");
                Log.error((String)"Sasl incorrect-encoding");
                return;
            }
            if ("aborted".equals(string)) {
                this.connect.sendLoginError("aborted");
                return;
            }
            if ("not-authorized".equals(string)) {
                this.connect.sendUnauthorized();
                return;
            }
            if ("invalid-authzid".equals(string)) {
                this.connect.sendUnauthorized();
                return;
            }
            this.connect.sendLoginError(string);
            return;
        }
        if (packet instanceof SaslPacket) {
            this.connect.startSasl((ConnectionPacketReceiver)this);
            return;
        }
        if (packet instanceof ChallengePacket) {
            this.respond((ChallengePacket)packet);
            return;
        }
        if (!(packet instanceof InfoQuery)) return;
        InfoQuery infoQuery = (InfoQuery)packet;
        IQExtension iQExtension = infoQuery.getIQExtension();
        if (iQExtension instanceof IQBind) {
            if (infoQuery.getType().equals("result")) {
                this.jid = ((IQBind)iQExtension).getJID();
                System.out.println(this.jid);
                this.connect.sendWhileConnecting((Packet)new InfoQuery(null, "set", "sessionStart", (IQExtension)new IQSession()));
                return;
            }
            if (!infoQuery.getType().equals("error")) return;
            String string = infoQuery.getXMPPError().getFirstXMPPError().getError();
            if (string.equals("bad-request ")) {
                this.connect.sendWhileConnecting((Packet)new InfoQuery("get", (IQExtension)new IQBind()));
                return;
            }
            if (string.equals("not-allowed")) {
                this.connect.sendLoginError("Resource limit reached, logoff a resource");
                return;
            }
            if (!string.equals("conflict")) return;
            this.connect.sendWhileConnecting((Packet)new InfoQuery("get", (IQExtension)new IQBind()));
            return;
        }
        if (!infoQuery.getID().equals("sessionStart")) return;
        if (infoQuery.getType().equals("result")) {
            this.connect.authenticated(this.jid);
            return;
        }
        if (!infoQuery.getType().equals("error")) return;
        String string = infoQuery.getXMPPError().getFirstXMPPError().getError();
        if (string.equals("internal-server-error")) {
            this.connect.sendLoginError("Server error, try again");
            return;
        }
        if (string.equals("forbidden")) {
            this.connect.sendLoginError("Not allowed to create session");
            return;
        }
        if (!string.equals("cancel")) return;
        this.connect.sendWhileConnecting((Packet)new InfoQuery("get", (IQExtension)new IQBind()));
    }

    public static void unload(Backend backend) {
    }

    public void unload() {
    }
}

