/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.XData;
import nu.fw.jeti.jabber.elements.XDataBuilder;
import nu.fw.jeti.jabber.elements.XDataField;
import nu.fw.jeti.jabber.elements.XMPPError;
import nu.fw.jeti.jabber.elements.XMPPErrorTag;
import nu.fw.jeti.plugins.filetransfer.IQSi;
import nu.fw.jeti.plugins.filetransfer.Plugin;
import nu.fw.jeti.plugins.filetransfer.StreamReceive;
import nu.fw.jeti.plugins.filetransfer.XSiFileTransfer;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Preferences;
import nu.fw.jeti.util.Utils;

public class GetFileWindow
extends JFrame {
    private JProgressBar progressBar = new JProgressBar();
    private JButton btnDownload = new JButton();
    private JButton btnCancel = new JButton();
    private Backend backend;
    private String streamMethod;
    private InfoQuery iq;
    private OutputStream out;
    private Timer timer;
    private StreamReceive streamReceive;
    private String fromName;
    private String fileName;
    private long fileSize;
    private String description;
    private int ibbMaxSize = Preferences.getInteger((String)"filetransfer", (String)"ibbMaxSize", (int)4096);

    public GetFileWindow(Backend backend, InfoQuery infoQuery) {
        this.iq = infoQuery;
        this.backend = backend;
        if (this.init()) {
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
    }

    private boolean init() {
        Iterator iterator;
        XSiFileTransfer xSiFileTransfer;
        Object object;
        IQSi iQSi = (IQSi)this.iq.getIQExtension();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        XData xData = iQSi.getXDataForm();
        if (xData.hasFields()) {
            object = xData.getFields();
            while (object.hasNext()) {
                xSiFileTransfer = (XDataField)object.next();
                if (!"stream-method".equals(xSiFileTransfer.getVar()) || !xSiFileTransfer.hasOptions()) continue;
                iterator = xSiFileTransfer.getOptionsIterator();
                while (iterator.hasNext()) {
                    arrayList.add(((Object[])iterator.next())[1]);
                }
            }
        }
        object = null;
        xSiFileTransfer = iQSi.getSiprofile();
        if (xSiFileTransfer != null) {
            if (arrayList.contains("http://jabber.org/protocol/bytestreams") && Preferences.getBoolean((String)"filetransfer", (String)"bytestreams.enable", (boolean)true)) {
                object = "http://jabber.org/protocol/bytestreams";
            }
            if (xSiFileTransfer.getSize() < (long)this.ibbMaxSize && Preferences.getBoolean((String)"filetransfer", (String)"ibb.enable", (boolean)true) && arrayList.contains("http://jabber.org/protocol/ibb")) {
                object = "http://jabber.org/protocol/ibb";
            }
            if (object == null) {
                iterator = new XMPPError("cancel", 400);
                iterator.addError(new XMPPErrorTag("bad-request"));
                iterator.addError(new XMPPErrorTag("no-valid-streams", "http://jabber.org/protocol/si"));
                this.backend.send((Packet)new InfoQuery(this.iq.getFrom(), this.iq.getID(), (XMPPError)iterator));
                return false;
            }
            this.streamMethod = object;
            iterator = Backend.getJIDStatus((JID)this.iq.getFrom());
            this.fromName = iterator == null ? this.iq.getFrom().toString() : iterator.getNick();
            this.fileName = xSiFileTransfer.getName();
            this.fileSize = xSiFileTransfer.getSize();
            this.progressBar.setMaximum((int)(this.fileSize / 1024L));
            this.description = xSiFileTransfer.getDescription();
        }
        return true;
    }

    private void jbInit() {
        JComponent jComponent;
        this.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
        this.setTitle(I18N.gettext((String)"filetransfer.File_Transfer"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 5, 0, 3);
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.weightx = 1.0;
        JLabel jLabel = new JLabel(I18N.gettext((String)"filetransfer.From"));
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(this.fromName);
        this.getContentPane().add((Component)jLabel, gridBagConstraints2);
        jLabel = new JLabel(I18N.gettext((String)"filetransfer.File_Name"));
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(this.fileName);
        this.getContentPane().add((Component)jLabel, gridBagConstraints2);
        jLabel = new JLabel(I18N.gettext((String)"filetransfer.File_Size"));
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(Plugin.getSizeText(this.fileSize));
        this.getContentPane().add((Component)jLabel, gridBagConstraints2);
        if (this.description != null && this.description.length() > 0) {
            jLabel = new JLabel(I18N.gettext((String)"filetransfer.Description"));
            this.getContentPane().add((Component)jLabel, gridBagConstraints);
            jComponent = new JTextArea(this.description);
            ((JTextComponent)jComponent).setEditable(false);
            this.getContentPane().add((Component)new JScrollPane(jComponent), gridBagConstraints2);
        }
        gridBagConstraints2.anchor = 10;
        this.progressBar.setPreferredSize(new Dimension(300, 17));
        this.getContentPane().add((Component)this.progressBar, gridBagConstraints2);
        gridBagConstraints2.fill = 0;
        jComponent = new JPanel();
        this.btnDownload.setText(I18N.gettext((String)"filetransfer.Download"));
        this.getRootPane().setDefaultButton(this.btnDownload);
        this.btnDownload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GetFileWindow.this.btnDownload_actionPerformed(actionEvent);
            }
        });
        AbstractAction abstractAction = new AbstractAction(I18N.gettext((String)"Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                GetFileWindow.this.btnCancel_actionPerformed(actionEvent);
            }
        };
        Utils.addCancelButton((RootPaneContainer)this, (JButton)this.btnCancel, (Action)abstractAction);
        jComponent.add(this.btnDownload);
        jComponent.add(this.btnCancel);
        this.getContentPane().add((Component)jComponent, gridBagConstraints2);
    }

    void btnDownload_actionPerformed(ActionEvent actionEvent) {
        int n;
        JFileChooser jFileChooser = Plugin.getFileChooser();
        jFileChooser.setDialogTitle("Save " + this.fileName);
        String string = Preferences.getString((String)"filetransfer", (String)"downloadDir", null);
        if (string != null) {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        jFileChooser.setSelectedFile(new File(this.fileName));
        int n2 = jFileChooser.showSaveDialog(this.backend.getMainWindow());
        if (n2 != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        Preferences.putString((String)"filetransfer", (String)"downloadDir", (String)file.getParent());
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this, MessageFormat.format(I18N.gettext((String)"filetransfer.{0}_already_exist,_overwrite?"), file.toString()), I18N.gettext((String)"filetransfer.File_Transfer"), 0, 2)) == 1) {
            return;
        }
        try {
            this.out = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Popups.errorPopup((String)MessageFormat.format(I18N.gettext((String)"filetransfer.{0}_could_not_be_openend_in_write_mode"), file.getAbsolutePath()), (String)I18N.gettext((String)"filetransfer.File_Transfer"));
            return;
        }
        XDataBuilder xDataBuilder = new XDataBuilder();
        xDataBuilder.type = "submit";
        xDataBuilder.addField(new XDataField("stream-method", this.streamMethod));
        XData xData = null;
        try {
            xData = xDataBuilder.build();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        this.backend.send((Packet)new InfoQuery(this.iq.getFrom(), "result", this.iq.getID(), (IQExtension)new IQSi(xData, null)));
        IQSi iQSi = (IQSi)this.iq.getIQExtension();
        Plugin.addGetFile(this, this.iq.getFrom(), iQSi.getId());
        this.fileName = file.getName();
        this.btnDownload.setEnabled(false);
    }

    void btnCancel_actionPerformed(ActionEvent actionEvent) {
        if (this.btnCancel.getText().equals(I18N.gettext((String)"filetransfer.Close"))) {
            this.dispose();
        } else if (this.streamReceive != null) {
            this.timer.stop();
            this.streamReceive.cancel();
        } else {
            XMPPError xMPPError = new XMPPError("cancel", 403);
            xMPPError.addError(new XMPPErrorTag("forbidden"));
            this.backend.send((Packet)new InfoQuery(this.iq.getFrom(), this.iq.getID(), xMPPError));
        }
        this.dispose();
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public StreamReceive getStreamReceive() {
        return this.streamReceive;
    }

    public void startDownloading(StreamReceive streamReceive) {
        this.streamReceive = streamReceive;
        this.initTimer();
    }

    private void initTimer() {
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                long l = GetFileWindow.this.streamReceive.getBytes();
                GetFileWindow.this.progressBar.setValue((int)(l / 1024L));
                int n = (int)((double)l / (double)GetFileWindow.this.fileSize * 100.0);
                GetFileWindow.this.setTitle(n + "% " + GetFileWindow.this.fileName);
            }
        });
        this.timer.start();
    }

    public void stopDownloading() {
        if (Preferences.getBoolean((String)"filetransfer", (String)"closeOnComplete", (boolean)false)) {
            this.dispose();
        } else {
            this.btnCancel.setText(I18N.gettext((String)"filetransfer.Close"));
            this.progressBar.setValue(this.progressBar.getMaximum());
            this.setTitle("100% " + this.fileName);
        }
        this.timer.stop();
    }
}

