/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import nu.fw.jeti.backend.roster.JIDStatusGroup;
import nu.fw.jeti.backend.roster.PrimaryJIDStatus;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.XData;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.RosterMenuListener;
import nu.fw.jeti.plugins.filetransfer.GetFileWindow;
import nu.fw.jeti.plugins.filetransfer.IQSiHandler;
import nu.fw.jeti.plugins.filetransfer.SendFileWindow;
import nu.fw.jeti.plugins.filetransfer.XSiFileTransferHandler;
import nu.fw.jeti.plugins.filetransfer.ibb.IBBHandler;
import nu.fw.jeti.plugins.filetransfer.socks5.Socks5Handler;
import nu.fw.jeti.plugins.filetransfer.socks5.Socks5Send;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Utils;
import org.xml.sax.Attributes;

public class Plugin
implements Plugins {
    private static Backend backend;
    private static Plugin plugin;
    private static JFileChooser fileChooser;
    private Map fileWindows = new HashMap(10);
    public static final String VERSION = "0.1";
    public static final String DESCRIPTION = "filetransfer.File_Transfer";
    public static final String MIN_JETI_VERSION = "0.6.1";
    public static final String NAME = "filetransfer";
    public static final String ABOUT = "by E.S. de Boer";

    public static void init(final Backend backend) {
        backend.getMain().addToOnlineRosterMenu(I18N.gettext((String)"filetransfer.Transfer_File") + "...", new RosterMenuListener(){

            public void actionPerformed(JIDStatus jIDStatus, JIDStatusGroup jIDStatusGroup) {
                new SendFileWindow(backend, jIDStatus.getCompleteJID()).setVisible(true);
            }
        });
        plugin = new Plugin();
        Plugin.backend = backend;
        backend.addExtensionHandler("http://jabber.org/protocol/si", (ExtensionHandler)new IQSiHandler());
        backend.addExtensionHandler("http://jabber.org/protocol/si/profile/file-transfer", (ExtensionHandler)new XSiFileTransferHandler());
        backend.addExtensionHandler("http://jabber.org/protocol/feature-neg", new ExtensionHandler(){
            private XData data;

            public void startHandling(Attributes attributes) {
                this.data = null;
            }

            public void addExtension(Extension extension) {
                if (extension instanceof XData) {
                    this.data = (XData)extension;
                }
            }

            public Extension build() throws InstantiationException {
                return this.data;
            }
        });
        backend.addExtensionHandler("http://jabber.org/protocol/ibb", (ExtensionHandler)new IBBHandler());
        backend.addExtensionHandler("http://jabber.org/protocol/bytestreams", (ExtensionHandler)new Socks5Handler());
        Socks5Send.initProxies(backend);
        backend.getMain().getOnlinePanel().setTransferHandler((TransferHandler)new FileTransferhandler());
    }

    public static void addGetFile(GetFileWindow getFileWindow, JID jID, String string) {
        Plugin.plugin.fileWindows.put(jID, getFileWindow);
    }

    public static GetFileWindow getGetFile(JID jID, String string) {
        return (GetFileWindow)Plugin.plugin.fileWindows.remove(jID);
    }

    public static void unload(Backend backend) {
        backend.getMain().removeFromRosterMenu(I18N.gettext((String)"filetransfer.Transfer_File") + "...");
        backend.removeExtensionHandler("http://jabber.org/protocol/ibb");
        backend.removeExtensionHandler("http://jabber.org/protocol/si");
        backend.removeExtensionHandler("http://jabber.org/protocol/si/profile/file-transfer");
        backend.removeExtensionHandler("http://jabber.org/protocol/feature-neg");
        plugin = null;
    }

    public void unload() {
    }

    public static String sha(String string, JID jID, JID jID2) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        messageDigest.update(string.getBytes());
        messageDigest.update(Plugin.stringPrep(jID).getBytes());
        return Utils.toString((byte[])messageDigest.digest(Plugin.stringPrep(jID2).getBytes()));
    }

    private static String stringPrep(JID jID) {
        StringBuffer stringBuffer = new StringBuffer();
        if (jID.getUser() != null) {
            stringBuffer.append(jID.getUser().toLowerCase());
            stringBuffer.append("@");
        }
        stringBuffer.append(jID.getDomain().toLowerCase());
        if (jID.getResource() != null) {
            stringBuffer.append("/");
            stringBuffer.append(jID.getResource());
        }
        return stringBuffer.toString();
    }

    public static String getIP() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress() || inetAddress.isSiteLocalAddress()) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        return null;
    }

    protected static JFileChooser getFileChooser() {
        return fileChooser;
    }

    public static String getSizeText(long l) {
        if (l < 1024L) {
            return l + " bytes";
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(2);
        double d = (double)l / 1024.0;
        if (d < 1024.0) {
            return numberFormat.format(d) + " kB";
        }
        if ((d /= 1024.0) < 1024.0) {
            return numberFormat.format(d) + " MB";
        }
        return numberFormat.format(d /= 1024.0) + " GB";
    }

    static {
        fileChooser = new JFileChooser();
    }

    private static class FileTransferhandler
    extends TransferHandler {
        private FileTransferhandler() {
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(DataFlavor.javaFileListFlavor)) continue;
                return true;
            }
            return false;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            Object object;
            JID jID;
            Object object2 = ((JTree)jComponent).getLastSelectedPathComponent();
            if (object2 instanceof JIDStatus) {
                jID = ((JIDStatus)object2).getCompleteJID();
            } else if (object2 instanceof PrimaryJIDStatus) {
                object = (PrimaryJIDStatus)object2;
                jID = object.getJIDPrimaryStatus().getCompleteJID();
            } else {
                return false;
            }
            if (!transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            try {
                File file;
                object = (Collection)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (object == null || object.size() == 0) {
                    return false;
                }
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    file = (File)iterator.next();
                    if (file.isFile()) continue;
                    Popups.errorPopup((String)I18N.gettext((String)"filetransfer.Can_not_transfer_directories"), (String)I18N.gettext((String)"main.error.Error"));
                    return false;
                }
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    file = (File)iterator.next();
                    new SendFileWindow(backend, jID, file).setVisible(true);
                }
                return true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.out.println("unsupported data");
            }
            catch (IOException iOException) {
                System.out.println("IOException");
            }
            return false;
        }
    }
}

