/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer.ibb;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.plugins.filetransfer.GetFileWindow;
import nu.fw.jeti.plugins.filetransfer.StreamReceive;
import nu.fw.jeti.plugins.filetransfer.ibb.IBBExtension;
import nu.fw.jeti.util.Base64;
import nu.fw.jeti.util.Popups;

public class IBBReceive
extends Thread
implements StreamReceive {
    private String sid;
    private JID jid;
    private Backend backend;
    private long bytes;
    private LinkedList queue = new LinkedList();
    private volatile boolean isDownloading = true;
    private GetFileWindow getFileWindow;

    public IBBReceive(JID jID, String string, Backend backend, GetFileWindow getFileWindow) {
        this.jid = jID;
        this.sid = string;
        this.backend = backend;
        this.getFileWindow = getFileWindow;
        this.setPriority(5);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(String string) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.addLast(string);
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDownloading() {
        this.isDownloading = false;
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.notifyAll();
        }
    }

    public long getBytes() {
        return this.bytes;
    }

    public void cancel() {
        this.backend.send((Packet)new InfoQuery(this.jid, "set", (IQExtension)new IBBExtension(this.sid)));
        this.stopDownloading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.getFileWindow.getOutputStream());
        if (bufferedOutputStream != null) {
            try {
                while (!this.queue.isEmpty() || this.isDownloading) {
                    String string;
                    Object object = this.queue;
                    synchronized (object) {
                        if (this.queue.isEmpty()) {
                            try {
                                this.queue.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                                // MONITOREXIT @DISABLED, blocks:[0, 19, 20, 21, 10, 11] lbl13 : MonitorExitStatement: MONITOREXIT : var3_6
                                try {
                                    bufferedOutputStream.close();
                                    return;
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                                return;
                            }
                        }
                        string = (String)this.queue.removeFirst();
                    }
                    object = Base64.decode((String)string);
                    bufferedOutputStream.write((byte[])object, 0, ((Object)object).length);
                    this.bytes += (long)((Object)object).length;
                }
            }
            catch (IOException iOException) {
                Popups.errorPopup((String)(iOException.getMessage() + " while downloading "), (String)"File transfer");
                this.backend.send((Packet)new InfoQuery(this.jid, "set", (IQExtension)new IBBExtension(this.sid)));
                this.getFileWindow.stopDownloading();
            }
            finally {
                try {
                    bufferedOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        this.getFileWindow.stopDownloading();
    }
}

