/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer.socks5.jsocks;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class InetRange
implements Cloneable {
    Hashtable host_names;
    Vector all = new Vector();
    Vector end_names;
    boolean useSeparateThread = true;

    public InetRange() {
        this.host_names = new Hashtable();
        this.end_names = new Vector();
    }

    public synchronized boolean add(String string) {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).length() == 0) {
            return false;
        }
        if (string.charAt(string.length() - 1) == '.') {
            int[] nArray = InetRange.ip2intarray(string);
            long l = 0L;
            long l2 = 0L;
            if (nArray == null) {
                return false;
            }
            for (int i = 0; i < 4; ++i) {
                if (nArray[i] >= 0) {
                    l2 += (long)nArray[i] << 8 * (3 - i);
                    continue;
                }
                l = l2;
                while (i < 4) {
                    l += 255L << 8 * (3 - i++);
                }
                break;
            }
            Object[] objectArray = new Object[]{string, null, new Long(l2), new Long(l)};
            this.all.addElement(objectArray);
        } else if (string.charAt(0) == '.') {
            this.end_names.addElement(string);
            this.all.addElement(new Object[]{string, null, null, null});
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n\f:");
            if (stringTokenizer.countTokens() > 1) {
                Object[] objectArray = new Object[]{string, null, null, null};
                this.resolve(objectArray, stringTokenizer.nextToken(), stringTokenizer.nextToken());
                this.all.addElement(objectArray);
            } else {
                Object[] objectArray = new Object[]{string, null, null, null};
                this.all.addElement(objectArray);
                this.host_names.put(string, objectArray);
                this.resolve(objectArray);
            }
        }
        return true;
    }

    public synchronized void add(InetAddress inetAddress) {
        long l;
        long l2 = l = InetRange.ip2long(inetAddress);
        this.all.addElement(new Object[]{inetAddress.getHostName(), inetAddress, new Long(l2), new Long(l)});
    }

    public synchronized void add(InetAddress inetAddress, InetAddress inetAddress2) {
        this.all.addElement(new Object[]{inetAddress.getHostAddress() + ":" + inetAddress2.getHostAddress(), null, new Long(InetRange.ip2long(inetAddress)), new Long(InetRange.ip2long(inetAddress2))});
    }

    public synchronized boolean contains(String string) {
        return this.contains(string, true);
    }

    public synchronized boolean contains(String string, boolean bl) {
        if (this.all.size() == 0) {
            return false;
        }
        if ((string = string.trim()).length() == 0) {
            return false;
        }
        if (this.checkHost(string)) {
            return true;
        }
        if (this.checkHostEnding(string)) {
            return true;
        }
        long l = this.host2long(string);
        if (l >= 0L) {
            return this.contains(l);
        }
        if (!bl) {
            return false;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return this.contains(inetAddress);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public synchronized boolean contains(InetAddress inetAddress) {
        if (this.checkHostEnding(inetAddress.getHostName())) {
            return true;
        }
        if (this.checkHost(inetAddress.getHostName())) {
            return true;
        }
        return this.contains(InetRange.ip2long(inetAddress));
    }

    public synchronized String[] getAll() {
        int n = this.all.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = (Object[])this.all.elementAt(i);
            stringArray[i] = (String)objectArray[0];
        }
        return stringArray;
    }

    public synchronized boolean remove(String string) {
        Enumeration enumeration = this.all.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            if (!string.equals(objectArray[0])) continue;
            this.all.removeElement(objectArray);
            this.end_names.removeElement(string);
            this.host_names.remove(string);
            return true;
        }
        return false;
    }

    public String toString() {
        String[] stringArray = this.getAll();
        if (stringArray.length == 0) {
            return "";
        }
        String string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string = string + "; " + stringArray[i];
        }
        return string;
    }

    public Object clone() {
        InetRange inetRange = new InetRange();
        inetRange.all = (Vector)this.all.clone();
        inetRange.end_names = (Vector)this.end_names.clone();
        inetRange.host_names = (Hashtable)this.host_names.clone();
        return inetRange;
    }

    private synchronized boolean contains(long l) {
        Enumeration enumeration = this.all.elements();
        while (enumeration.hasMoreElements()) {
            Long l2;
            Object[] objectArray = (Object[])enumeration.nextElement();
            Long l3 = objectArray[2] == null ? null : (Long)objectArray[2];
            Long l4 = l2 = objectArray[3] == null ? null : (Long)objectArray[3];
            if (l3 == null || l3 > l || l2 < l) continue;
            return true;
        }
        return false;
    }

    private boolean checkHost(String string) {
        return this.host_names.containsKey(string);
    }

    private boolean checkHostEnding(String string) {
        Enumeration enumeration = this.end_names.elements();
        while (enumeration.hasMoreElements()) {
            if (!string.endsWith((String)enumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    private void resolve(Object[] objectArray) {
        long l = this.host2long((String)objectArray[0]);
        if (l >= 0L) {
            objectArray[2] = objectArray[3] = new Long(l);
        } else {
            InetRangeResolver inetRangeResolver = new InetRangeResolver(objectArray);
            inetRangeResolver.resolve(this.useSeparateThread);
        }
    }

    private void resolve(Object[] objectArray, String string, String string2) {
        long l;
        long l2 = this.host2long(string);
        if (l2 >= 0L && (l = this.host2long(string2)) >= 0L) {
            objectArray[2] = new Long(l2);
            objectArray[3] = new Long(l);
        } else {
            InetRangeResolver inetRangeResolver = new InetRangeResolver(objectArray, string, string2);
            inetRangeResolver.resolve(this.useSeparateThread);
        }
    }

    static long ip2long(InetAddress inetAddress) {
        long l = 0L;
        byte[] byArray = inetAddress.getAddress();
        if (byArray.length == 4) {
            for (int i = 0; i < 4; ++i) {
                l += ((long)byArray[i] & 0xFFL) << 8 * (3 - i);
            }
        } else {
            return 0L;
        }
        return l;
    }

    long host2long(String string) {
        long l = 0L;
        if (!Character.isDigit(string.charAt(0))) {
            return -1L;
        }
        int[] nArray = InetRange.ip2intarray(string);
        if (nArray == null) {
            return -1L;
        }
        for (int i = 0; i < nArray.length; ++i) {
            l += (long)(nArray[i] >= 0 ? nArray[i] : 0) << 8 * (3 - i);
        }
        return l;
    }

    static int[] ip2intarray(String string) {
        int[] nArray = new int[]{-1, -1, -1, -1};
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() > 4) {
            return null;
        }
        while (stringTokenizer.hasMoreTokens()) {
            try {
                nArray[n++] = Integer.parseInt(stringTokenizer.nextToken()) & 0xFF;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return nArray;
    }

    class InetRangeResolver
    implements Runnable {
        Object[] entry;
        String from;
        String to;

        InetRangeResolver(Object[] objectArray) {
            this.entry = objectArray;
            this.to = null;
            this.from = null;
        }

        InetRangeResolver(Object[] objectArray, String string, String string2) {
            this.entry = objectArray;
            this.from = string;
            this.to = string2;
        }

        public final void resolve() {
            this.resolve(true);
        }

        public final void resolve(boolean bl) {
            if (bl) {
                Thread thread = new Thread(this);
                thread.start();
            } else {
                this.run();
            }
        }

        public void run() {
            try {
                if (this.from == null) {
                    InetAddress inetAddress = InetAddress.getByName((String)this.entry[0]);
                    this.entry[1] = inetAddress;
                    Long l = new Long(InetRange.ip2long(inetAddress));
                    this.entry[2] = this.entry[3] = l;
                } else {
                    InetAddress inetAddress = InetAddress.getByName(this.from);
                    InetAddress inetAddress2 = InetAddress.getByName(this.to);
                    this.entry[2] = new Long(InetRange.ip2long(inetAddress));
                    this.entry[3] = new Long(InetRange.ip2long(inetAddress2));
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }
}

