/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer.socks5.jsocks;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.InetRange;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.ProxyMessage;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.Socks5Proxy;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.SocksException;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.SocksSocket;

public abstract class Proxy {
    protected InetRange directHosts = new InetRange();
    protected InetAddress proxyIP = null;
    protected String proxyHost = null;
    protected int proxyPort;
    protected Socket proxySocket = null;
    protected InputStream in;
    protected OutputStream out;
    protected int version;
    protected Proxy chainProxy = null;
    protected static Proxy defaultProxy = null;
    public static final int SOCKS_SUCCESS = 0;
    public static final int SOCKS_FAILURE = 1;
    public static final int SOCKS_BADCONNECT = 2;
    public static final int SOCKS_BADNETWORK = 3;
    public static final int SOCKS_HOST_UNREACHABLE = 4;
    public static final int SOCKS_CONNECTION_REFUSED = 5;
    public static final int SOCKS_TTL_EXPIRE = 6;
    public static final int SOCKS_CMD_NOT_SUPPORTED = 7;
    public static final int SOCKS_ADDR_NOT_SUPPORTED = 8;
    public static final int SOCKS_NO_PROXY = 65536;
    public static final int SOCKS_PROXY_NO_CONNECT = 131072;
    public static final int SOCKS_PROXY_IO_ERROR = 196608;
    public static final int SOCKS_AUTH_NOT_SUPPORTED = 262144;
    public static final int SOCKS_AUTH_FAILURE = 327680;
    public static final int SOCKS_JUST_ERROR = 393216;
    public static final int SOCKS_DIRECT_FAILED = 458752;
    public static final int SOCKS_METHOD_NOTSUPPORTED = 524288;
    static final int SOCKS_CMD_CONNECT = 1;
    static final int SOCKS_CMD_BIND = 2;
    static final int SOCKS_CMD_UDP_ASSOCIATE = 3;

    Proxy(Proxy proxy, String string, int n) throws UnknownHostException {
        this.chainProxy = proxy;
        this.proxyHost = string;
        if (proxy == null) {
            this.proxyIP = InetAddress.getByName(string);
        }
        this.proxyPort = n;
    }

    Proxy(String string, int n) throws UnknownHostException {
        this(null, string, n);
    }

    Proxy(Proxy proxy, InetAddress inetAddress, int n) {
        this.chainProxy = proxy;
        this.proxyIP = inetAddress;
        this.proxyPort = n;
    }

    Proxy(InetAddress inetAddress, int n) {
        this(null, inetAddress, n);
    }

    Proxy(Proxy proxy) {
        this.proxyIP = proxy.proxyIP;
        this.proxyPort = proxy.proxyPort;
        this.version = proxy.version;
        this.directHosts = proxy.directHosts;
    }

    public int getPort() {
        return this.proxyPort;
    }

    public InetAddress getInetAddress() {
        return this.proxyIP;
    }

    public void addDirect(InetAddress inetAddress) {
        this.directHosts.add(inetAddress);
    }

    public boolean addDirect(String string) {
        return this.directHosts.add(string);
    }

    public void addDirect(InetAddress inetAddress, InetAddress inetAddress2) {
        this.directHosts.add(inetAddress, inetAddress2);
    }

    public void setDirect(InetRange inetRange) {
        this.directHosts = inetRange;
    }

    public InetRange getDirect() {
        return this.directHosts;
    }

    public boolean isDirect(String string) {
        return this.directHosts.contains(string);
    }

    public boolean isDirect(InetAddress inetAddress) {
        return this.directHosts.contains(inetAddress);
    }

    public void setChainProxy(Proxy proxy) {
        this.chainProxy = proxy;
    }

    public Proxy getChainProxy() {
        return this.chainProxy;
    }

    public String toString() {
        return "" + this.proxyIP.getHostName() + ":" + this.proxyPort + "\tVersion " + this.version;
    }

    public static void setDefaultProxy(String string, int n) throws UnknownHostException {
        defaultProxy = new Socks5Proxy(string, n);
    }

    public static void setDefaultProxy(InetAddress inetAddress, int n) {
        defaultProxy = new Socks5Proxy(inetAddress, n);
    }

    public static void setDefaultProxy(Proxy proxy) {
        defaultProxy = proxy;
    }

    public static Proxy getDefaultProxy() {
        return defaultProxy;
    }

    protected void startSession() throws SocksException {
        try {
            this.proxySocket = this.chainProxy == null ? new Socket(this.proxyIP, this.proxyPort) : (this.proxyIP != null ? new SocksSocket(this.chainProxy, this.proxyIP, this.proxyPort) : new SocksSocket(this.chainProxy, this.proxyHost, this.proxyPort));
            this.in = this.proxySocket.getInputStream();
            this.out = this.proxySocket.getOutputStream();
        }
        catch (SocksException socksException) {
            throw socksException;
        }
        catch (IOException iOException) {
            throw new SocksException(196608, "" + iOException);
        }
    }

    protected abstract Proxy copy();

    protected abstract ProxyMessage formMessage(int var1, InetAddress var2, int var3);

    protected abstract ProxyMessage formMessage(int var1, String var2, int var3) throws UnknownHostException;

    protected abstract ProxyMessage formMessage(InputStream var1) throws SocksException, IOException;

    protected ProxyMessage connect(InetAddress inetAddress, int n) throws SocksException {
        try {
            this.startSession();
            ProxyMessage proxyMessage = this.formMessage(1, inetAddress, n);
            return this.exchange(proxyMessage);
        }
        catch (SocksException socksException) {
            this.endSession();
            throw socksException;
        }
    }

    protected ProxyMessage connect(String string, int n) throws UnknownHostException, SocksException {
        try {
            this.startSession();
            ProxyMessage proxyMessage = this.formMessage(1, string, n);
            return this.exchange(proxyMessage);
        }
        catch (SocksException socksException) {
            this.endSession();
            throw socksException;
        }
    }

    protected ProxyMessage bind(InetAddress inetAddress, int n) throws SocksException {
        try {
            this.startSession();
            ProxyMessage proxyMessage = this.formMessage(2, inetAddress, n);
            return this.exchange(proxyMessage);
        }
        catch (SocksException socksException) {
            this.endSession();
            throw socksException;
        }
    }

    protected ProxyMessage bind(String string, int n) throws UnknownHostException, SocksException {
        try {
            this.startSession();
            ProxyMessage proxyMessage = this.formMessage(2, string, n);
            return this.exchange(proxyMessage);
        }
        catch (SocksException socksException) {
            this.endSession();
            throw socksException;
        }
    }

    protected ProxyMessage accept() throws IOException, SocksException {
        ProxyMessage proxyMessage;
        try {
            proxyMessage = this.formMessage(this.in);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            this.endSession();
            throw new SocksException(196608, "While Trying accept:" + iOException);
        }
        return proxyMessage;
    }

    protected ProxyMessage udpAssociate(InetAddress inetAddress, int n) throws SocksException {
        try {
            this.startSession();
            ProxyMessage proxyMessage = this.formMessage(3, inetAddress, n);
            if (proxyMessage != null) {
                return this.exchange(proxyMessage);
            }
        }
        catch (SocksException socksException) {
            this.endSession();
            throw socksException;
        }
        this.endSession();
        throw new SocksException(524288, "This version of proxy does not support UDP associate, use version 5");
    }

    protected ProxyMessage udpAssociate(String string, int n) throws UnknownHostException, SocksException {
        try {
            this.startSession();
            ProxyMessage proxyMessage = this.formMessage(3, string, n);
            if (proxyMessage != null) {
                return this.exchange(proxyMessage);
            }
        }
        catch (SocksException socksException) {
            this.endSession();
            throw socksException;
        }
        this.endSession();
        throw new SocksException(524288, "This version of proxy does not support UDP associate, use version 5");
    }

    protected void endSession() {
        try {
            if (this.proxySocket != null) {
                this.proxySocket.close();
            }
            this.proxySocket = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void sendMsg(ProxyMessage proxyMessage) throws SocksException, IOException {
        proxyMessage.write(this.out);
    }

    protected ProxyMessage readMsg() throws SocksException, IOException {
        return this.formMessage(this.in);
    }

    protected ProxyMessage exchange(ProxyMessage proxyMessage) throws SocksException {
        ProxyMessage proxyMessage2;
        try {
            proxyMessage.write(this.out);
            proxyMessage2 = this.formMessage(this.in);
        }
        catch (SocksException socksException) {
            throw socksException;
        }
        catch (IOException iOException) {
            throw new SocksException(196608, "" + iOException);
        }
        return proxyMessage2;
    }
}

