/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchat;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.MessageListener;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.plugins.groupchat.GroupchatWindow;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class GroupChatWindows
implements MessageListener {
    private Map groupchatWindows = new HashMap();
    private Backend backend;
    private JTabbedPane tabs;
    private JFrame window;
    private int chatDividerLocation;
    private ComponentListener chatDividerListener;
    private int dividerLocation;
    private ComponentListener dividerListener;

    public GroupChatWindows(Backend backend) {
        this.backend = backend;
        backend.addListener(MessageListener.class, (JETIListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getRooms() {
        Map map = this.groupchatWindows;
        synchronized (map) {
            return this.groupchatWindows.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        Map map = this.groupchatWindows;
        synchronized (map) {
            Iterator iterator = this.groupchatWindows.values().iterator();
            while (iterator.hasNext()) {
                ((GroupchatWindow)iterator.next()).exit();
            }
            if (this.window != null) {
                this.window.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupchatWindow createGroupChatWindow(JID jID) {
        GroupchatWindow groupchatWindow = new GroupchatWindow(this.backend, jID, this, new JFrame());
        Map map = this.groupchatWindows;
        synchronized (map) {
            this.groupchatWindows.put(jID, groupchatWindow);
            return groupchatWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JID isGroupchatStarted(JID jID) {
        Map map = this.groupchatWindows;
        synchronized (map) {
            if (this.groupchatWindows.containsKey(jID)) {
                Iterator iterator = this.groupchatWindows.keySet().iterator();
                while (iterator.hasNext()) {
                    JID jID2 = (JID)iterator.next();
                    if (!jID.equals(jID2)) continue;
                    return jID2;
                }
                return null;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupchatWindow getGroupchatWindow(JID jID) {
        GroupchatWindow groupchatWindow;
        Object object = this.groupchatWindows;
        synchronized (object) {
            groupchatWindow = (GroupchatWindow)this.groupchatWindows.get(jID);
        }
        if (groupchatWindow == null) {
            groupchatWindow = this.startGroupchat(jID);
        }
        object = groupchatWindow;
        Runnable runnable = new Runnable((GroupchatWindow)object){
            private final /* synthetic */ GroupchatWindow val$w2;
            {
                this.val$w2 = groupchatWindow;
            }

            public void run() {
                if (GroupChatWindows.this.tabs != null && GroupChatWindows.this.tabs.indexOfComponent(this.val$w2) != -1) {
                    this.val$w2.requestFocusInWindow();
                    GroupChatWindows.this.tabs.setSelectedComponent(this.val$w2);
                }
                JOptionPane.getFrameForComponent(this.val$w2.getTopLevelAncestor()).toFront();
            }
        };
        SwingUtilities.invokeLater(runnable);
        return groupchatWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupchatWindow startGroupchat(JID jID) {
        GroupchatWindow groupchatWindow;
        if (Preferences.getBoolean((String)"jeti", (String)"tabs", (boolean)false)) {
            if (this.window == null) {
                this.makeNewTabWindow();
            }
            groupchatWindow = new GroupchatWindow(this.backend, jID, this, this.window);
            if (!this.window.isDisplayable()) {
                this.addMenu(groupchatWindow);
            }
            this.addTab(groupchatWindow);
            groupchatWindow.setChatDividerLocation(this.chatDividerLocation);
            groupchatWindow.addChatSplitBarListener(this.chatDividerListener);
            groupchatWindow.addSplitBarListener(this.dividerListener);
            groupchatWindow.setDividerLocation(this.dividerLocation);
            this.window.setVisible(true);
        } else {
            groupchatWindow = new GroupchatWindow(this.backend, jID, this, null);
            this.setChatWindowPosition(groupchatWindow);
        }
        GroupchatWindow groupchatWindow2 = groupchatWindow;
        synchronized (groupchatWindow2) {
            this.groupchatWindows.put(jID, groupchatWindow);
        }
        return groupchatWindow;
    }

    private void addTab(GroupchatWindow groupchatWindow) {
        this.tabs.addTab(this.getTitle(groupchatWindow.getJID()), StatusIcons.getStatusIcon((int)groupchatWindow.getStatus()), groupchatWindow);
    }

    private void removeTab(GroupchatWindow groupchatWindow) {
        if (this.tabs.getTabCount() == 1) {
            this.savePreferences();
            this.window.dispose();
            this.window = null;
        }
        this.tabs.remove(groupchatWindow);
    }

    private void makeNewTabWindow() {
        this.window = new JFrame();
        this.window.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
        JMenuBar jMenuBar = new JMenuBar();
        this.tabs = new JTabbedPane(){

            public void remove(Component component) {
                super.remove(component);
                this.fireStateChanged();
            }
        };
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        GroupchatWindow groupchatWindow = (GroupchatWindow)GroupChatWindows.this.tabs.getSelectedComponent();
                        if (groupchatWindow != null) {
                            GroupChatWindows.this.window.setTitle(groupchatWindow.getJID().toStringNoResource());
                            GroupChatWindows.this.window.setIconImage(StatusIcons.getStatusIcon((int)groupchatWindow.getStatus()).getImage());
                            GroupChatWindows.this.tabs.setBackgroundAt(GroupChatWindows.this.tabs.getSelectedIndex(), UIManager.getColor("TabbedPane.background"));
                            GroupChatWindows.this.tabs.setForegroundAt(GroupChatWindows.this.tabs.getSelectedIndex(), UIManager.getColor("TabbedPane.foreground"));
                            GroupChatWindows.this.window.getJMenuBar().removeAll();
                            GroupChatWindows.this.addMenu(groupchatWindow);
                            groupchatWindow.setChatDividerLocation(GroupChatWindows.this.chatDividerLocation);
                            groupchatWindow.setDividerLocation(GroupChatWindows.this.dividerLocation);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        this.tabs.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                GroupchatWindow groupchatWindow;
                if (mouseEvent.getButton() == 3 && (groupchatWindow = (GroupchatWindow)((JTabbedPane)mouseEvent.getSource()).getSelectedComponent()) != null) {
                    JPopupMenu jPopupMenu = GroupChatWindows.this.tabMenu(groupchatWindow);
                    jPopupMenu.show(GroupChatWindows.this.tabs, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.window.setJMenuBar(jMenuBar);
        this.window.setSize(Preferences.getInteger((String)"groupchat", (String)"chatTabWidth", (int)700), Preferences.getInteger((String)"groupchat", (String)"chatTabHeight", (int)400));
        int n = Preferences.getInteger((String)"groupchat", (String)"chatTabPosX", (int)100);
        int n2 = Preferences.getInteger((String)"groupchat", (String)"chatTabPosY", (int)100);
        int n3 = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int n4 = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        if (n > n3) {
            n = 100;
        }
        if (n2 > n4) {
            n2 = 100;
        }
        this.window.setLocation(n, n2);
        this.window.setDefaultCloseOperation(0);
        this.window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                int n;
                int n2 = GroupChatWindows.this.tabs.getTabCount();
                if (n2 > 1 && (n = JOptionPane.showConfirmDialog(GroupChatWindows.this.window, MessageFormat.format(I18N.gettext((String)"main.chat.You_are_about_to_close_{0}_tabs_Are_you_sure_you_want_to_close_them?"), new Integer(n2)), "", 0)) == 1) {
                    return;
                }
                GroupChatWindows.this.savePreferences();
                for (n = 0; n < n2; ++n) {
                    GroupchatWindow groupchatWindow = (GroupchatWindow)GroupChatWindows.this.tabs.getComponent(n);
                    groupchatWindow.exit();
                    GroupChatWindows.this.removeGroupchat(groupchatWindow.getJID());
                }
                GroupChatWindows.this.window.dispose();
                GroupChatWindows.this.window = null;
            }
        });
        this.window.addWindowFocusListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                GroupchatWindow groupchatWindow = (GroupchatWindow)GroupChatWindows.this.tabs.getSelectedComponent();
                if (groupchatWindow != null) {
                    groupchatWindow.requestFocusInWindow();
                }
            }
        });
        this.window.getContentPane().add(this.tabs);
        this.chatDividerLocation = Preferences.getInteger((String)"groupchat", (String)"chatTabDivider", (int)200);
        this.dividerLocation = Preferences.getInteger((String)"groupchat", (String)"TabDivider", (int)460);
        this.chatDividerListener = new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                GroupChatWindows.this.chatDividerLocation = ((JSplitPane)componentEvent.getComponent().getParent()).getDividerLocation();
            }
        };
        this.dividerListener = new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                GroupChatWindows.this.dividerLocation = ((JSplitPane)componentEvent.getComponent().getParent()).getDividerLocation();
            }
        };
    }

    private void addMenu(final GroupchatWindow groupchatWindow) {
        if (Preferences.getBoolean((String)"groupchat", (String)"hideGroupchatMenu", (boolean)false)) {
            return;
        }
        final JMenu[] jMenuArray = groupchatWindow.getMenu();
        if (jMenuArray[0].getItem(jMenuArray[0].getItemCount() - 1).getName() == null) {
            final JMenuItem jMenuItem = new JMenuItem();
            final JMenuItem jMenuItem2 = new JMenuItem();
            I18N.setTextAndMnemonic((String)"main.chat.menu.Move_to_Window", (AbstractButton)jMenuItem, (boolean)true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jMenuArray[0].remove(jMenuItem);
                    jMenuArray[0].remove(jMenuItem2);
                    GroupChatWindows.this.removeTab(groupchatWindow);
                    groupchatWindow.removeChatSplitBarListener(GroupChatWindows.this.chatDividerListener);
                    groupchatWindow.removeSplitBarListener(GroupChatWindows.this.dividerListener);
                    groupchatWindow.changeToWindow();
                    GroupChatWindows.this.setChatWindowPosition(groupchatWindow);
                }
            });
            jMenuArray[0].add(jMenuItem);
            I18N.setTextAndMnemonic((String)"main.chat.menu.Close", (AbstractButton)jMenuItem2, (boolean)true);
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    groupchatWindow.removeChatSplitBarListener(GroupChatWindows.this.chatDividerListener);
                    groupchatWindow.removeSplitBarListener(GroupChatWindows.this.dividerListener);
                    GroupChatWindows.this.groupchatWindows.remove(groupchatWindow);
                    GroupChatWindows.this.removeTab(groupchatWindow);
                    groupchatWindow.exit();
                }
            });
            jMenuItem2.setName("close");
            jMenuArray[0].add(jMenuItem2);
        }
        for (int i = 0; i < jMenuArray.length; ++i) {
            this.window.getJMenuBar().add(jMenuArray[i]);
        }
    }

    private JPopupMenu tabMenu(final GroupchatWindow groupchatWindow) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = null;
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"main.chat.menu.Close", (AbstractButton)jMenuItem, (boolean)true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                groupchatWindow.removeChatSplitBarListener(GroupChatWindows.this.chatDividerListener);
                groupchatWindow.removeSplitBarListener(GroupChatWindows.this.dividerListener);
                groupchatWindow.exit();
                GroupChatWindows.this.groupchatWindows.remove(groupchatWindow);
                GroupChatWindows.this.removeTab(groupchatWindow);
            }
        });
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public void convertToTab(GroupchatWindow groupchatWindow) {
        if (this.window == null) {
            this.makeNewTabWindow();
        }
        if (!this.window.isDisplayable()) {
            this.addMenu(groupchatWindow);
        }
        this.addTab(groupchatWindow);
        groupchatWindow.setChatDividerLocation(this.chatDividerLocation);
        groupchatWindow.addChatSplitBarListener(this.chatDividerListener);
        groupchatWindow.setDividerLocation(this.dividerLocation);
        groupchatWindow.addSplitBarListener(this.dividerListener);
        groupchatWindow.setParentFrame(this.window);
        this.window.setVisible(true);
    }

    public void setTitleAt(final GroupchatWindow groupchatWindow, final JID jID) {
        if (this.tabs == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = GroupChatWindows.this.tabs.indexOfComponent(groupchatWindow);
                if (n == -1 || GroupChatWindows.this.window == null) {
                    return;
                }
                GroupChatWindows.this.tabs.setTitleAt(n, GroupChatWindows.this.getTitle(jID));
                if (GroupChatWindows.this.tabs.getSelectedIndex() == n) {
                    GroupChatWindows.this.window.setTitle(jID.toStringNoResource());
                }
            }
        });
    }

    private String getTitle(JID jID) {
        String string = jID.getUser();
        if (string.indexOf(37) > 0) {
            string = string.substring(0, string.indexOf(37));
        }
        if (string.length() > 20) {
            string = string.substring(0, 20);
        } else if (string.length() < 5) {
            string = string + "     ".substring(0, 5);
        }
        return string;
    }

    public void setIconAt(final GroupchatWindow groupchatWindow, final ImageIcon imageIcon) {
        if (this.tabs == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = GroupChatWindows.this.tabs.indexOfComponent(groupchatWindow);
                if (n == -1 || GroupChatWindows.this.window == null) {
                    return;
                }
                GroupChatWindows.this.tabs.setIconAt(n, imageIcon);
                if (GroupChatWindows.this.tabs.getSelectedIndex() == n) {
                    GroupChatWindows.this.window.setIconImage(imageIcon.getImage());
                }
            }
        });
    }

    public void message(final Message message) {
        if (message.getType().equals("groupchat")) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    GroupchatWindow groupchatWindow;
                    Map map = GroupChatWindows.this.groupchatWindows;
                    synchronized (map) {
                        groupchatWindow = (GroupchatWindow)GroupChatWindows.this.groupchatWindows.get(message.getFrom());
                    }
                    if (groupchatWindow != null) {
                        int n;
                        if (GroupChatWindows.this.tabs != null && (n = GroupChatWindows.this.tabs.indexOfComponent(groupchatWindow)) != -1) {
                            if (GroupChatWindows.this.tabs.getSelectedIndex() != n) {
                                GroupChatWindows.this.tabs.setBackgroundAt(n, Color.BLUE);
                                GroupChatWindows.this.tabs.setForegroundAt(n, Color.RED);
                            }
                            GroupChatWindows.this.tabs.setToolTipTextAt(n, message.getBody());
                        }
                        groupchatWindow.appendMessage(message);
                    } else {
                        System.out.println(message.getBody());
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setChatWindowPosition(GroupchatWindow groupchatWindow) {
        Map map = this.groupchatWindows;
        synchronized (map) {
            if (this.groupchatWindows.isEmpty()) {
                int n = Preferences.getInteger((String)"groupchat", (String)"chatPosX", (int)100);
                int n2 = Preferences.getInteger((String)"groupchat", (String)"chatPosY", (int)100);
                int n3 = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
                int n4 = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
                if (n > n3) {
                    n = 100;
                }
                if (n2 > n4) {
                    n2 = 100;
                }
                groupchatWindow.setLocationOnScreen(n, n2);
            } else {
                GroupchatWindow groupchatWindow2 = (GroupchatWindow)this.groupchatWindows.values().toArray()[this.groupchatWindows.size() - 1];
                groupchatWindow.setLocationOnScreen(groupchatWindow2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroupchat(JID jID) {
        Map map = this.groupchatWindows;
        synchronized (map) {
            this.groupchatWindows.remove(jID);
        }
    }

    private void savePreferences() {
        Preferences.putInteger((String)"groupchat", (String)"chatTabPosX", (int)this.window.getX());
        Preferences.putInteger((String)"groupchat", (String)"chatTabPosY", (int)this.window.getY());
        Preferences.putInteger((String)"groupchat", (String)"chatTabHeight", (int)this.window.getHeight());
        Preferences.putInteger((String)"groupchat", (String)"chatTabWidth", (int)this.window.getWidth());
        Preferences.putInteger((String)"groupchat", (String)"chatTabDivider", (int)this.chatDividerLocation);
        Preferences.putInteger((String)"groupchat", (String)"TabDivider", (int)this.dividerLocation);
    }
}

