/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.jabber.elements;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Preferences;

public class IQTime
extends Extension
implements IQExtension {
    private String tz;
    private String utc;
    private String display;

    public IQTime() {
    }

    public IQTime(String string, String string2, String string3) {
        this.tz = string2;
        this.utc = string;
        this.display = string3;
    }

    public String getTZ() {
        return this.tz;
    }

    public String getUTC() {
        return this.utc;
    }

    public String getDisplay() {
        return this.display;
    }

    public void execute(InfoQuery infoQuery, Backend backend) {
        String string = infoQuery.getType();
        if (string.equals("get")) {
            if (Preferences.getBoolean("jeti", "privacy", false)) {
                return;
            }
            this.sendTime(infoQuery.getFrom(), infoQuery.getID(), backend);
        } else if (string.equals("result")) {
            this.timePopup(infoQuery.getFrom().toStringNoResource(), this.getDisplay(), this.getUTC(), this.getTZ());
        } else if (string.equals("error")) {
            Popups.errorPopup(infoQuery.getErrorDescription(), I18N.gettext("main.error.Time_Error"));
        }
    }

    private void timePopup(String string, String string2, String string3, String string4) {
        String string5 = MessageFormat.format(I18N.gettext("main.popup.Local_time_for_{0}_is"), string);
        String string6 = null;
        if (string3.length() > 0 && string4.length() > 0) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                Date date = simpleDateFormat.parse(string3);
                DateFormat dateFormat = DateFormat.getDateTimeInstance();
                dateFormat.setTimeZone(TimeZone.getTimeZone(string4));
                string6 = dateFormat.format(date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (string6 == null) {
            string6 = string2;
        }
        if (string4.length() > 0) {
            string6 = string6 + "\n" + MessageFormat.format(I18N.gettext("main.popup.{0}_is_in_timezone_{1}"), string, string4);
        }
        Popups.popup(string5 + "\n" + string6, string + ' ' + I18N.gettext("main.popup.Time"), 1);
    }

    private void sendTime(JID jID, String string, Backend backend) {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
        TimeZone timeZone = simpleDateFormat.getTimeZone();
        String string2 = simpleDateFormat.getTimeZone().getDisplayName(timeZone.inDaylightTime(date), 0);
        simpleDateFormat.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        IQTime iQTime = new IQTime(simpleDateFormat.format(date), string2, date.toString());
        backend.send(new InfoQuery(jID, "result", string, iQTime));
    }

    public void appendToXML(StringBuffer stringBuffer) {
        stringBuffer.append("<query xmlns=\"jabber:iq:time\"");
        if (this.tz == null && this.utc == null && this.display == null) {
            stringBuffer.append("/>");
            return;
        }
        stringBuffer.append('>');
        IQTime.appendElement(stringBuffer, "utc", this.utc);
        IQTime.appendElement(stringBuffer, "tz", this.tz);
        IQTime.appendElement(stringBuffer, "display", this.display);
        stringBuffer.append("</query>");
    }
}

