/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.jabber.elements;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nu.fw.jeti.events.PreferenceListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQXExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.JetiExtensionBuilder;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Preferences;

public class JetiPrivateExtension
extends Extension
implements IQXExtension {
    private Map map;
    private Map messages;
    private String xmlVer;
    public static final String XML_VERSION = "v1";

    public JetiPrivateExtension() {
    }

    public JetiPrivateExtension(Map map, Map map2) {
        this.messages = map2;
        this.map = map;
        this.xmlVer = XML_VERSION;
    }

    public JetiPrivateExtension(JetiExtensionBuilder jetiExtensionBuilder) {
        this.map = Collections.unmodifiableMap(jetiExtensionBuilder.getMap());
        this.messages = Collections.unmodifiableMap(jetiExtensionBuilder.getMapMessages());
        this.xmlVer = jetiExtensionBuilder.getXmlVersion();
        if (this.xmlVer == null) {
            this.xmlVer = XML_VERSION;
        }
    }

    public Map getMap() {
        return this.map;
    }

    public Map getMessages() {
        return this.messages;
    }

    public String getXmlVersion() {
        return this.xmlVer;
    }

    public void execute(InfoQuery infoQuery, Backend backend) {
        if (infoQuery.getType().equals("result")) {
            Preferences.load(this);
            Iterator iterator = backend.getListeners(PreferenceListener.class);
            while (iterator.hasNext()) {
                ((PreferenceListener)iterator.next()).preferencesChanged();
            }
        } else if (infoQuery.getType().equals("error")) {
            Popups.errorPopup(infoQuery.getErrorDescription(), I18N.gettext("main.error.Preferences_load_Error"));
        }
    }

    public void appendToXML(StringBuffer stringBuffer) {
        Map.Entry entry;
        Iterator iterator;
        stringBuffer.append("<j2m xmlns=\"j2m:prefs\"");
        if (this.map == null && this.messages == null) {
            stringBuffer.append("/>");
            return;
        }
        JetiPrivateExtension.appendAttribute(stringBuffer, "xmlVersion", this.xmlVer);
        if (this.map != null) {
            iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                JetiPrivateExtension.appendAttribute(stringBuffer, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        stringBuffer.append(">");
        if (this.messages != null) {
            stringBuffer.append("<status>");
            iterator = this.messages.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                stringBuffer.append("<" + entry.getKey());
                List list = (List)entry.getValue();
                for (int i = 0; i < list.size(); ++i) {
                    JetiPrivateExtension.appendAttribute(stringBuffer, "s" + i, (String)list.get(i));
                }
                stringBuffer.append("/>");
            }
            stringBuffer.append("</status>");
        }
        stringBuffer.append("</j2m>");
    }
}

