/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui.login;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import nu.fw.jeti.backend.LoginInfo;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.DiscoItem;
import nu.fw.jeti.ui.login.LoginWindow;
import nu.fw.jeti.ui.login.ProfileInfo;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;
import nu.fw.jeti.util.QueryServers;
import nu.fw.jeti.util.Utils;

public class EditProfileWindow
extends JFrame {
    private JTextField txtUser = new JTextField();
    private JTextField txtPassword = new JPasswordField();
    private ProfileInfo profileInfo;
    private JComboBox cmbServer = new JComboBox();
    private JTextField txtResource = new JTextField();
    private JPanel jPanel1 = new JPanel();
    private JButton btnCancel = new JButton();
    private JButton btnOnce = new JButton();
    private JButton btnSave = new JButton();
    private JTextField txtProfiel = new JTextField();
    private JCheckBox chkSSL = new JCheckBox();
    private JPanel jPanel2 = new JPanel();
    private JCheckBox chkHideLogin = new JCheckBox();
    private JTextField txtPort = new JTextField();
    private JPanel jPanel3 = new JPanel();
    private JScrollPane panelAdvance;
    private JTextField txtHost = new JTextField();
    private JPanel jPanel4 = new JPanel();
    private JRadioButton chkSocksProxy = new JRadioButton();
    private JRadioButton chkHTTPProxy = new JRadioButton();
    private JRadioButton chkNoProxy = new JRadioButton();
    private JCheckBox chkAutoLogin = new JCheckBox();
    private JTextField txtProxyHost = new JTextField();
    private JTextField txtProxyPort = new JTextField();
    private JTextField txtProxyUserName = new JTextField();
    private JTextField txtProxyPassword = new JTextField();
    private JButton btnRemove = new JButton();
    private JSpinner spinner = new JSpinner(new SpinnerNumberModel(0, -128, 127, 1));
    private LoginWindow loginWindow;
    private Backend backend;
    private boolean oldChkAutoLogin;

    public EditProfileWindow(LoginWindow loginWindow, ProfileInfo profileInfo, Backend backend) {
        this.loginWindow = loginWindow;
        this.profileInfo = profileInfo;
        this.txtPort.setText("5222");
        this.txtResource.setText("JETI");
        this.setTitle(I18N.gettext("main.EditProfile.New_Profile_Info"));
        I18N.setTextAndMnemonic("main.EditProfile.Register", this.btnRemove);
        this.btnRemove.setToolTipText(I18N.gettext("main.EditProfile.Request_new_account"));
        this.backend = backend;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public EditProfileWindow(LoginWindow loginWindow, ProfileInfo profileInfo, String string) {
        this.loginWindow = loginWindow;
        this.txtProfiel.setText(string);
        this.txtProfiel.setEditable(false);
        this.setTitle(I18N.gettext("main.EditProfile.Edit_Profile_Info"));
        I18N.setTextAndMnemonic("main.EditProfile.Remove", this.btnRemove);
        this.btnRemove.setToolTipText(I18N.gettext("main.EditProfile.Remove_this_profile"));
        String string2 = Preferences.getString("jeti", "autoLogin", null);
        this.oldChkAutoLogin = string.equals(string2);
        this.chkAutoLogin.setSelected(this.oldChkAutoLogin);
        this.profileInfo = profileInfo;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        LoginInfo loginInfo = profileInfo.getProfile(string);
        if (loginInfo != null) {
            this.txtUser.setText(loginInfo.getUsername());
            this.txtPassword.setText(loginInfo.getPassword());
            this.txtResource.setText(loginInfo.getResource());
            this.txtPort.setText(String.valueOf(loginInfo.getPort()));
            this.txtHost.setText(loginInfo.getHost());
            this.chkSSL.setSelected(loginInfo.isSSl());
            this.chkHideLogin.setSelected(loginInfo.hideStatusWindow());
            this.cmbServer.setSelectedItem(loginInfo.getServer());
            this.spinner.setValue(new Integer(loginInfo.getPriority()));
            if (!loginInfo.useProxy(0)) {
                if (loginInfo.useProxy(1)) {
                    this.chkSocksProxy.setSelected(true);
                } else if (loginInfo.useProxy(2)) {
                    this.chkHTTPProxy.setSelected(true);
                }
                this.txtProxyHost.setText(loginInfo.getProxyServer());
                this.txtProxyPort.setText(loginInfo.getProxyPort());
                this.txtProxyUserName.setText(loginInfo.getProxyUsername());
                this.txtProxyPassword.setText(loginInfo.getProxyPassword());
            }
        }
    }

    private void jbInit() throws Exception {
        Object object;
        this.setIconImage(StatusIcons.getImageIcon("jeti").getImage());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setCursor(null);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        JLabel jLabel = new JLabel();
        I18N.setTextAndMnemonic("main.EditProfile.Profile_name", jLabel);
        this.getContentPane().add(jLabel);
        jLabel.setLabelFor(this.txtProfiel);
        this.getContentPane().add(this.txtProfiel);
        jLabel = new JLabel();
        I18N.setTextAndMnemonic("main.EditProfile.Jabber_Server", jLabel);
        jLabel.setLabelFor(this.cmbServer);
        this.getContentPane().add(jLabel);
        this.getContentPane().add(this.cmbServer);
        this.cmbServer.addItem("");
        Object object2 = QueryServers.getServers().iterator();
        while (object2.hasNext()) {
            object = (DiscoItem)object2.next();
            this.cmbServer.addItem(((DiscoItem)object).getJID().getDomain());
        }
        this.cmbServer.setAlignmentX(0.0f);
        this.cmbServer.setEditable(true);
        jLabel = new JLabel();
        I18N.setTextAndMnemonic("main.EditProfile.Username", jLabel);
        jLabel.setLabelFor(this.txtUser);
        this.getContentPane().add(jLabel);
        this.getContentPane().add(this.txtUser);
        jLabel = new JLabel();
        I18N.setTextAndMnemonic("main.EditProfile.Password_(leave_blank_to_ask)", jLabel);
        jLabel.setToolTipText(I18N.gettext("main.EditProfile.Only_fill_in_password_on_private_computers,_to_prevent_theft_of_password"));
        this.getContentPane().add(jLabel);
        jLabel.setLabelFor(this.txtPassword);
        this.getContentPane().add(this.txtPassword);
        jLabel = new JLabel();
        I18N.setTextAndMnemonic("main.EditProfile.Resource", jLabel);
        jLabel.setLabelFor(this.txtResource);
        this.getContentPane().add(jLabel);
        this.getContentPane().add(this.txtResource);
        I18N.setTextAndMnemonic("main.EditProfile.Automatic_login_on_start", this.chkAutoLogin);
        this.getContentPane().add(this.chkAutoLogin);
        object2 = new JButton();
        I18N.setTextAndMnemonic("main.EditProfile.Advanced", (AbstractButton)object2);
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EditProfileWindow.this.panelAdvance.isVisible()) {
                    EditProfileWindow.this.panelAdvance.setVisible(false);
                    EditProfileWindow.this.pack();
                    EditProfileWindow.this.setLocationRelativeTo(null);
                } else {
                    EditProfileWindow.this.panelAdvance.setVisible(true);
                    EditProfileWindow.this.pack();
                    EditProfileWindow.this.setLocationRelativeTo(null);
                }
            }
        });
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 0));
        ((Container)object).add(Box.createHorizontalGlue());
        ((Container)object).add((Component)object2);
        ((JComponent)object).setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        ((JComponent)object).setAlignmentX(0.0f);
        this.getContentPane().add((Component)object);
        this.jPanel3.setAlignmentX(0.0f);
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 3));
        this.advancedConfig();
        this.panelAdvance = new JScrollPane(this.jPanel3);
        this.panelAdvance.setBorder(null);
        this.getContentPane().add(this.panelAdvance);
        this.panelAdvance.setVisible(false);
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditProfileWindow.this.btnRemove_actionPerformed(actionEvent);
            }
        });
        AbstractAction abstractAction = new AbstractAction(I18N.gettext("Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditProfileWindow.this.dispose();
            }
        };
        this.btnCancel.setAction(abstractAction);
        Utils.addCancelButton(this, this.btnCancel, abstractAction);
        this.jPanel1.setAlignmentX(0.0f);
        I18N.setTextAndMnemonic("Save", this.btnSave);
        this.btnSave.setToolTipText(I18N.gettext("main.EditProfile.Save_profile"));
        this.btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditProfileWindow.this.btnSave_actionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.btnRemove);
        this.jPanel1.add(this.btnSave);
        this.jPanel1.add(this.btnCancel);
        this.getContentPane().add(this.jPanel1);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void advancedConfig() {
        I18N.setTextAndMnemonic("main.EditProfile.Use_SSL", this.chkSSL);
        JLabel jLabel = new JLabel();
        I18N.setTextAndMnemonic("main.EditProfile.Port", jLabel);
        jLabel.setLabelFor(this.txtPort);
        this.jPanel2.add(jLabel);
        this.jPanel2.add(this.txtPort);
        this.jPanel2.add(this.chkSSL);
        this.jPanel2.setAlignmentX(0.0f);
        this.txtPort.setPreferredSize(new Dimension(80, 21));
        this.jPanel3.add(this.jPanel2);
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.0f);
        jLabel = new JLabel();
        I18N.setTextAndMnemonic("main.EditProfile.Priority", jLabel);
        jLabel.setLabelFor(this.spinner);
        jPanel.add(jLabel);
        jPanel.add(this.spinner);
        I18N.setTextAndMnemonic("main.EditProfile.Hide_Status_Window", this.chkHideLogin);
        this.chkHideLogin.setToolTipText(I18N.gettext("main.EditProfile.Hide_the_login_status_window"));
        jPanel.add(this.chkHideLogin);
        this.jPanel3.add(jPanel);
        this.jPanel4.setAlignmentX(0.0f);
        this.jPanel4.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), I18N.gettext("main.EditProfile.Proxy")));
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        I18N.setTextAndMnemonic("main.EditProfile.No_Proxy", this.chkNoProxy);
        this.jPanel4.add(this.chkNoProxy);
        buttonGroup.add(this.chkNoProxy);
        this.chkNoProxy.setSelected(true);
        I18N.setTextAndMnemonic("main.EditProfile.Use_Socks_Proxy", this.chkSocksProxy);
        this.jPanel4.add(this.chkSocksProxy);
        buttonGroup.add(this.chkSocksProxy);
        I18N.setTextAndMnemonic("main.EditProfile.Use_HTTP_Proxy", this.chkHTTPProxy);
        this.jPanel4.add(this.chkHTTPProxy);
        buttonGroup.add(this.chkHTTPProxy);
        jLabel = new JLabel();
        I18N.setTextAndMnemonic("main.EditProfile.Proxy_Host", jLabel);
        this.jPanel4.add(jLabel);
        jLabel.setLabelFor(this.txtProxyHost);
        this.jPanel4.add(this.txtProxyHost);
        jLabel = new JLabel();
        I18N.setTextAndMnemonic("main.EditProfile.Proxy_Port", jLabel);
        this.jPanel4.add(jLabel);
        jLabel.setLabelFor(this.txtProxyPort);
        this.jPanel4.add(this.txtProxyPort);
        jLabel = new JLabel();
        I18N.setTextAndMnemonic("main.EditProfile.Username", jLabel);
        this.jPanel4.add(jLabel);
        jLabel.setLabelFor(this.txtProxyUserName);
        this.jPanel4.add(this.txtProxyUserName);
        jLabel = new JLabel();
        I18N.setTextAndMnemonic("main.EditProfile.Password", jLabel);
        this.jPanel4.add(jLabel);
        jLabel.setLabelFor(this.txtProxyPassword);
        this.jPanel4.add(this.txtProxyPassword);
        this.jPanel3.add(this.jPanel4);
        jLabel = new JLabel();
        I18N.setTextAndMnemonic("main.EditProfile.Connect_to", jLabel);
        jLabel.setLabelFor(this.txtHost);
        this.jPanel3.add(jLabel);
        this.jPanel3.add(this.txtHost);
        I18N.setTextAndMnemonic("main.EditProfile.Use_this_profile_only_for_this_session", this.btnOnce);
        this.btnOnce.setToolTipText(I18N.gettext("main.EditProfile.Use_this_profile_only_to_login_this_time"));
        this.btnOnce.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditProfileWindow.this.btnLogin_actionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.btnOnce);
    }

    void btnLogin_actionPerformed(ActionEvent actionEvent) {
        if (this.saveCurrent()) {
            this.dispose();
        }
    }

    private boolean saveCurrent() {
        if (!(this.txtProfiel.getText().equals("") || this.txtUser.getText().equals("") || this.cmbServer.getSelectedItem().equals(""))) {
            int n;
            String string = this.txtResource.getText();
            if (string.equals("")) {
                string = "JETI";
            }
            try {
                n = Integer.parseInt(this.txtPort.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = this.chkSSL.isSelected() ? 5223 : 5222;
            }
            if (this.chkAutoLogin.isSelected()) {
                Preferences.putString("jeti", "autoLogin", this.txtProfiel.getText());
            } else if (this.oldChkAutoLogin) {
                Preferences.putString("jeti", "autoLogin", null);
            }
            int n2 = 0;
            if (this.chkSocksProxy.isSelected()) {
                n2 = 1;
            } else if (this.chkHTTPProxy.isSelected()) {
                n2 = 2;
                if (!this.chkSSL.isSelected()) {
                    JOptionPane.showMessageDialog(this, I18N.gettext("main.EditProfile.The_HTTP_Proxy_mode_requires_SSL_to_be_enabled_Please_enable_SSL_and_use_port_5223,_443_or_80"));
                    return false;
                }
            }
            LoginInfo loginInfo = new LoginInfo((String)this.cmbServer.getSelectedItem(), this.txtHost.getText(), this.txtUser.getText(), this.txtPassword.getText(), string, n, this.chkSSL.isSelected(), ((Number)this.spinner.getValue()).intValue(), n2, this.chkHideLogin.isSelected(), this.txtProxyHost.getText(), this.txtProxyUserName.getText(), this.txtProxyPassword.getText(), this.txtProxyPort.getText());
            this.profileInfo.setProfile(this.txtProfiel.getText(), loginInfo);
            this.loginWindow.update();
            return true;
        }
        return false;
    }

    void btnSave_actionPerformed(ActionEvent actionEvent) {
        if (this.saveCurrent()) {
            this.profileInfo.save();
            this.dispose();
        }
    }

    void btnRemove_actionPerformed(ActionEvent actionEvent) {
        if (this.btnRemove.getText().equals(I18N.gettext("main.EditProfile.Register"))) {
            String string = (String)this.cmbServer.getSelectedItem();
            if (string == null || string.equals("")) {
                JOptionPane.showMessageDialog(this, I18N.gettext("main.EditProfile.Please_select_a_server_first"));
                return;
            }
            String string2 = this.txtUser.getText();
            if (string2.equals("")) {
                JOptionPane.showMessageDialog(this, I18N.gettext("main.EditProfile.Please_enter_a_username_first"));
                return;
            }
            this.backend.newAccount(string, string2, this.txtPassword.getText());
        } else if (JOptionPane.showConfirmDialog(this, MessageFormat.format(I18N.gettext("main.EditProfile.Really_remove_{0}?"), this.txtProfiel.getText()), I18N.gettext("Remove"), 0) == 0) {
            this.profileInfo.remove(this.txtProfiel.getText());
            this.loginWindow.update();
            this.dispose();
        }
    }
}

