/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.jabber;

import nu.fw.jeti.util.I18N;

public final class JID {
    private String domain;
    private String user;
    private String resource;

    public JID(String string) {
        if (string == null || string.equals("")) {
            throw new NullPointerException(I18N.gettext("main.error.Server_has_no_value"));
        }
        this.domain = string;
    }

    public JID(String string, String string2) {
        this(string2);
        this.user = string;
    }

    public JID(String string, String string2, String string3) {
        this(string, string2);
        this.resource = string3;
    }

    public static JID jidFromString(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = string.indexOf("@");
        if (n != -1) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        if ((n = string.indexOf("/")) == -1) {
            string3 = string;
        } else {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        if (string3 == null) {
            return null;
        }
        return new JID(string2, string3, string4);
    }

    public static JID checkedJIDFromString(String string) throws InstantiationException {
        if (string == null || string.equals("")) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = string.indexOf("@");
        if (n != -1) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        if ((n = string.indexOf("/")) == -1) {
            string3 = string;
        } else {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        if (string2 != null && string2.length() > 255) {
            throw new InstantiationException(I18N.gettext("main.error.Username_>_255_Characters"));
        }
        if (string3.indexOf("@") != -1) {
            throw new InstantiationException(I18N.gettext("main.error.Server_or_Username_contains_a_'@'"));
        }
        if (!JID.isValidUser(string2)) {
            throw new InstantiationException(I18N.getTextWithAmp("main.error.Username_contains_illegal_chars_(see_english_translation)"));
        }
        if (!JID.isValidServer(string3)) {
            throw new InstantiationException(I18N.gettext("main.error.Server_must_start_with_a_letter_(see_english_translation)"));
        }
        return new JID(string2, string3, string4);
    }

    public static boolean isValidUser(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        if (n > 255) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c <= ' ') {
                return false;
            }
            if (c == ':') {
                return false;
            }
            if (c == '@') {
                return false;
            }
            if (c == '\"') {
                return false;
            }
            if (c == '>') {
                return false;
            }
            if (c == '<') {
                return false;
            }
            if (c == '/') {
                return false;
            }
            if (c == '\'') {
                return false;
            }
            if (c == '&') {
                return false;
            }
            if (c == '\u077f') {
                return false;
            }
            if (c == '\u0ffe') {
                return false;
            }
            if (c != '\u0fff') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidServer(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        int n = string.length();
        if (!Character.isLetterOrDigit(string.charAt(0))) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '-') continue;
            return false;
        }
        return true;
    }

    public String getUser() {
        return this.user;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getResource() {
        return this.resource;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.user != null) {
            stringBuffer.append(this.user);
            stringBuffer.append("@");
        }
        stringBuffer.append(this.domain);
        if (this.resource != null) {
            stringBuffer.append("/");
            stringBuffer.append(this.resource);
        }
        return stringBuffer.toString();
    }

    public String toStringNoResource() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.user != null) {
            stringBuffer.append(this.user);
            stringBuffer.append("@");
        }
        stringBuffer.append(this.domain);
        return stringBuffer.toString();
    }

    public boolean equals(JID jID) {
        return this.equalsNode(jID) && this.domain.equalsIgnoreCase(jID.domain);
    }

    private boolean equalsNode(JID jID) {
        if (this.user == null ^ jID.user == null) {
            return false;
        }
        if (this.user == null) {
            return true;
        }
        return this.user.equalsIgnoreCase(jID.user);
    }

    public boolean equals(Object object) {
        if (!(object instanceof JID)) {
            return false;
        }
        return this.equals((JID)object);
    }

    public int hashCode() {
        return this.toStringNoResource().toLowerCase().hashCode();
    }
}

