/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.jabber.handlers;

import nu.fw.jeti.backend.Connect;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.PacketBuilder;
import nu.fw.jeti.jabber.handlers.BaseHandler;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Log;
import org.xml.sax.Attributes;

public abstract class PacketHandler
extends BaseHandler {
    protected PacketBuilder builder;

    public PacketHandler() {
    }

    public PacketHandler(PacketBuilder packetBuilder) {
        this.builder = packetBuilder;
    }

    public void startHandling(Attributes attributes) {
        this.builder.reset();
        this.builder.setTo(JID.jidFromString(attributes.getValue("to")));
        this.builder.setFrom(JID.jidFromString(attributes.getValue("from")));
        this.builder.setId(attributes.getValue("id"));
    }

    public void startElement(String string, Attributes attributes) {
        if (string.equals("error")) {
            this.builder.setErrorType(attributes.getValue("type"));
            String string2 = attributes.getValue("code");
            try {
                this.builder.errorCode = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Log.notParsedXML(I18N.gettext("main.error.Illegal_errorcode") + " " + string2);
            }
        }
    }

    public void endElement(String string) {
        if (string.equals("error")) {
            this.builder.errorDescription = this.getText();
            this.clearCurrentChars();
        }
    }

    public void addExtension(Extension extension) {
        this.builder.addExtension(extension);
    }

    public Packet build() throws InstantiationException {
        if (this.builder.from == null) {
            this.builder.from = Connect.getMyJID();
        }
        Packet packet = this.builder.build();
        this.builder.reset();
        return packet;
    }
}

