/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.plugins.Avatars;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.ui.Jeti;
import nu.fw.jeti.ui.StatusMessagesWindow;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class StatusButton
extends JToggleButton {
    private static boolean heightInvalid = true;
    private static JPopupMenu statusMenu = null;
    private static JTextArea txtStatus = null;
    private static StatusButton currentParent = null;
    private static StatusButton master = null;
    private static LinkedList subInstances = new LinkedList();
    private JID jid;
    private int status;
    private String message;
    private Backend backend;
    private Jeti jeti;
    private Avatars avatars;

    public StatusButton(Backend backend, Jeti jeti) {
        this.backend = backend;
        this.jeti = jeti;
        master = this;
        this.init();
    }

    public StatusButton(Backend backend, JID jID) {
        this.backend = backend;
        this.jid = jID;
        subInstances.add(this);
        this.init();
    }

    public void remove() {
        subInstances.remove(this);
    }

    public void setJID(JID jID) {
        this.jid = jID;
    }

    public static int getStatus() {
        return StatusButton.master.status;
    }

    public static String getStatusMessage() {
        return StatusButton.master.message;
    }

    public void updateLF() {
        SwingUtilities.updateComponentTreeUI(statusMenu);
    }

    public static void reloadMessages() {
        StatusButton.populateStatusMenu();
    }

    public void ownPresenceChanged(int n, String string) {
        this.status = n;
        this.message = string != null ? string : Presence.toLongShow(n);
        Runnable runnable = new Runnable(){

            public void run() {
                ImageIcon imageIcon = StatusIcons.getStatusIcon(StatusButton.this.status);
                StatusButton.this.setIcon(imageIcon);
                String string = null;
                switch (StatusButton.this.status) {
                    case 2: {
                        string = "Available";
                        break;
                    }
                    case 1: {
                        string = "FreeforChat";
                        break;
                    }
                    case 3: {
                        string = "Away";
                        break;
                    }
                    case 5: {
                        string = "XA";
                        break;
                    }
                    case 4: {
                        string = "DND";
                        break;
                    }
                    case 7: {
                        string = "Offline";
                        break;
                    }
                    case 6: {
                        string = "Invisible";
                    }
                }
                I18N.setTextAndMnemonic("main.main.presencebutton." + string, StatusButton.this);
                txtStatus.setText(StatusButton.this.message);
                StatusButton.this.setToolTipText(StatusButton.this.message);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void connectionOffline() {
        Runnable runnable = new Runnable(){

            public void run() {
                master.setText(I18N.gettext("main.main.Offline"));
                master.setIcon(StatusIcons.getOfflineIcon());
                Iterator iterator = subInstances.iterator();
                while (iterator.hasNext()) {
                    StatusButton statusButton = (StatusButton)iterator.next();
                    statusButton.setText(I18N.gettext("main.main.Offline"));
                    statusButton.setIcon(StatusIcons.getOfflineIcon());
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private synchronized void init() {
        I18N.setTextAndMnemonic("main.main.presencebutton.Offline", this);
        this.setMaximumSize(new Dimension(1043, 23));
        this.setIcon(StatusIcons.getOfflineIcon());
        this.setMargin(new Insets(0, 0, 0, 0));
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusButton.this.showStatusMenu();
            }
        });
        this.addMouseListener(new PopupListener());
        if (statusMenu == null) {
            statusMenu = new JPopupMenu();
            txtStatus = new JTextArea();
            StatusButton.populateStatusMenu();
            statusMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    currentParent.setSelected(false);
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
    }

    private void showStatusMenu() {
        if (statusMenu.isVisible()) {
            return;
        }
        currentParent = this;
        txtStatus.setText(this.message);
        if (heightInvalid) {
            statusMenu.show(currentParent, 0, 0);
            statusMenu.setVisible(false);
            heightInvalid = false;
        }
        statusMenu.show(currentParent, 0, 0 - statusMenu.getHeight());
    }

    private static void populateStatusMenu() {
        statusMenu.removeAll();
        JMenuItem jMenuItem = null;
        statusMenu.add(new JMenuItem(I18N.gettext("main.main.statusmenu.Status_message")));
        txtStatus.setEditable(false);
        txtStatus.setBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93)));
        txtStatus.setOpaque(false);
        txtStatus.setLineWrap(true);
        txtStatus.setWrapStyleWord(true);
        statusMenu.add(txtStatus);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.main.statusmenu.Change_message", jMenuItem, true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                currentParent.message = JOptionPane.showInputDialog(currentParent, I18N.gettext("main.main.statusmenu.Status_message"), currentParent.message);
                if (currentParent.message == null) {
                    return;
                }
                StatusButton.changeStatus(currentParent.status, currentParent.message);
            }
        });
        statusMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.main.statusmenu.Manage_messages", jMenuItem, true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new StatusMessagesWindow().show();
            }
        });
        statusMenu.add(jMenuItem);
        statusMenu.add(StatusButton.createSubMenu(1));
        statusMenu.add(StatusButton.createSubMenu(2));
        statusMenu.add(StatusButton.createSubMenu(4));
        statusMenu.add(StatusButton.createSubMenu(3));
        statusMenu.add(StatusButton.createSubMenu(5));
        jMenuItem = new JMenuItem(StatusIcons.getStatusIcon(6));
        I18N.setTextAndMnemonic("main.main.presencebutton.Invisible", jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusButton.changeStatus(6, null);
            }
        });
        statusMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StatusIcons.getOfflineIcon());
        I18N.setTextAndMnemonic("main.main.presencebutton.Offline", jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusButton.changeStatus(7, null);
            }
        });
        statusMenu.add(jMenuItem);
        heightInvalid = true;
    }

    private static JMenu createSubMenu(final int n) {
        JMenu jMenu = new JMenu();
        I18N.setTextAndMnemonic(Presence.getI18NKey(n), jMenu);
        jMenu.setIcon(StatusIcons.getStatusIcon(n));
        List list = Preferences.getStatusMessages(n);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            final String string = (String)iterator.next();
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StatusButton.changeStatus(n, string);
                }
            });
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    public static void changeStatus(int n, String string) {
        if (Preferences.getBoolean("jeti", "statusLinked", false)) {
            Iterator iterator = subInstances.iterator();
            while (iterator.hasNext()) {
                StatusButton statusButton = (StatusButton)iterator.next();
                statusButton.changeInstanceStatus(n, string);
            }
            master.changeInstanceStatus(n, string);
        } else if (currentParent != null) {
            currentParent.changeInstanceStatus(n, string);
        } else {
            master.changeInstanceStatus(n, string);
        }
    }

    private void changeInstanceStatus(int n, String string) {
        if (master == this) {
            if (n == 7) {
                this.jeti.saveOpenGroups();
                this.backend.disconnect();
            } else {
                this.backend.changeStatus(n, string);
            }
        } else {
            Avatars avatars = this.getAvatarInterface();
            Presence presence = null;
            presence = avatars != null ? avatars.addHash(this.jid, n, string) : new Presence(this.jid, n, string);
            this.backend.send(presence);
        }
    }

    private Avatars getAvatarInterface() {
        if (this.avatars != null) {
            return this.avatars;
        }
        if (PluginsInfo.isPluginLoaded("ichatavatars")) {
            this.avatars = (Avatars)PluginsInfo.getPluginInstance("ichatavatars");
            return this.avatars;
        }
        return null;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                StatusButton.this.showStatusMenu();
            }
        }
    }
}

