/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.alertwindow;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.PreferencesPanel;
import nu.fw.jeti.plugins.alertwindow.Plugin;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class PrefPanel
extends PreferencesPanel {
    private JTextField txtPopupTime;
    private JTextField txtXOffset;
    private JTextField txtYOffset;
    private JSlider slider;
    private Object[][] messages = new Object[5][3];
    private JButton btnForegroundColor;
    private JButton btnDemo;
    private Color foregroundColor;

    public PrefPanel(Backend backend) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 0, 3);
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridwidth = 1;
        this.txtPopupTime = new JTextField(Preferences.getString((String)"alertwindow", (String)"popuptime", (String)"4"));
        this.add(new JLabel(I18N.gettext((String)"alertwindow.Time_to_show_alert")), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        this.add(this.txtPopupTime, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.add(new JLabel(I18N.gettext((String)"alertwindow.sec")), gridBagConstraints);
        this.slider = new JSlider(5, 100, Preferences.getInteger((String)"alertwindow", (String)"alpha", (int)100));
        gridBagConstraints.anchor = 24;
        if (Plugin.supportsAlpha) {
            this.slider.setMajorTickSpacing(10);
            this.slider.setMinorTickSpacing(1);
            this.slider.setPaintTicks(true);
            this.slider.setPaintLabels(true);
            this.slider.setLabelTable(this.slider.createStandardLabels(10, 10));
            gridBagConstraints.gridwidth = 1;
            this.add(new JLabel(I18N.gettext((String)"alertwindow.Transparancy,_100%_is_opaque")), gridBagConstraints);
            this.add(this.slider, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            this.add(new JLabel("%"), gridBagConstraints);
        }
        this.foregroundColor = new Color(Preferences.getInteger((String)"alertwindow", (String)"foregroundcolor", (int)SystemColor.controlText.getRGB()));
        this.btnForegroundColor = new JButton(I18N.gettext((String)"alertwindow.Foreground_color"));
        this.btnForegroundColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(PrefPanel.this.getTopLevelAncestor(), I18N.gettext((String)"alertwindow.Color"), PrefPanel.this.foregroundColor);
                if (color != null) {
                    PrefPanel.this.foregroundColor = color;
                    PrefPanel.this.btnForegroundColor.setForeground(PrefPanel.this.foregroundColor);
                }
            }
        });
        this.btnForegroundColor.setForeground(this.foregroundColor);
        this.add(this.btnForegroundColor, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.add(new JLabel(I18N.gettext((String)"alertwindow.Enable")), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.add(new JLabel(I18N.gettext((String)"alertwindow.Background_color")), gridBagConstraints);
        this.addSoundChooser(0, "message", gridBagConstraints, SystemColor.info);
        this.addSoundChooser(1, "online", gridBagConstraints, Color.GREEN);
        this.addSoundChooser(2, "offline", gridBagConstraints, Color.GRAY);
        this.addSoundChooser(3, "away", gridBagConstraints, Color.RED);
        this.addSoundChooser(4, "do_not_disturb", gridBagConstraints, Color.ORANGE);
        gridBagConstraints.gridwidth = 1;
        this.txtXOffset = new JTextField(Preferences.getString((String)"alertwindow", (String)"XOffset", (String)"0"));
        this.add(new JLabel(I18N.gettext((String)"alertwindow.X_Offset")), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.add(this.txtXOffset, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.txtYOffset = new JTextField(Preferences.getString((String)"alertwindow", (String)"YOffset", (String)"0"));
        this.add(new JLabel(I18N.gettext((String)"alertwindow.Y_Offset")), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.add(this.txtYOffset, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    private void addSoundChooser(final int n, String string, GridBagConstraints gridBagConstraints, Color color) {
        gridBagConstraints.gridwidth = 1;
        JCheckBox jCheckBox = new JCheckBox(I18N.gettext((String)("alertwindow." + string)));
        jCheckBox.setSelected(Preferences.getBoolean((String)"alertwindow", (String)(string + ".enabled"), (boolean)true));
        this.add(jCheckBox, gridBagConstraints);
        final JButton jButton = new JButton("...");
        final Color color2 = new Color(Preferences.getInteger((String)"alertwindow", (String)(string + ".backgroundcolor"), (int)color.getRGB()));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(PrefPanel.this.getTopLevelAncestor(), I18N.gettext((String)"alertwindow.Color"), color2);
                if (color != null) {
                    jButton.setBackground(color);
                    ((PrefPanel)PrefPanel.this).messages[n][2] = color;
                }
            }
        });
        jButton.setBackground(color2);
        this.add(jButton, gridBagConstraints);
        this.add(jButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.btnDemo = new JButton(I18N.gettext((String)"alertwindow.Demonstration"));
        this.btnDemo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!PrefPanel.this.txtPopupTime.getText().equals("")) {
                    try {
                        int n4 = Integer.parseInt(PrefPanel.this.txtPopupTime.getText());
                        int n2 = Integer.parseInt(PrefPanel.this.txtXOffset.getText());
                        int n3 = Integer.parseInt(PrefPanel.this.txtYOffset.getText());
                        if (n4 < 1) {
                            n4 = 1;
                        }
                        if (n4 > 3600) {
                            n4 = 3600;
                        }
                        Plugin plugin = new Plugin();
                        plugin.demo((Color)PrefPanel.this.messages[n][2], PrefPanel.this.foregroundColor, PrefPanel.this.slider.getValue(), n4, n2, n3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        });
        this.add(this.btnDemo, gridBagConstraints);
        this.messages[n] = new Object[]{string, jCheckBox, color2};
    }

    public void savePreferences() {
        if (!this.txtPopupTime.getText().equals("")) {
            try {
                int n = Integer.parseInt(this.txtPopupTime.getText());
                if (n < 1) {
                    n = 1;
                }
                if (n > 3600) {
                    n = 3600;
                }
                Preferences.putInteger((String)"alertwindow", (String)"popuptime", (int)n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!this.txtXOffset.getText().equals("")) {
            try {
                int n = Integer.parseInt(this.txtXOffset.getText());
                Preferences.putInteger((String)"alertwindow", (String)"XOffset", (int)n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!this.txtYOffset.getText().equals("")) {
            try {
                int n = Integer.parseInt(this.txtYOffset.getText());
                Preferences.putInteger((String)"alertwindow", (String)"YOffset", (int)n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (int i = 0; i < this.messages.length; ++i) {
            String string = (String)this.messages[i][0];
            Preferences.putBoolean((String)"alertwindow", (String)(string + ".enabled"), (boolean)((JCheckBox)this.messages[i][1]).isSelected());
            Preferences.putInteger((String)"alertwindow", (String)(string + ".backgroundcolor"), (int)((Color)this.messages[i][2]).getRGB());
        }
        Preferences.putInteger((String)"alertwindow", (String)"alpha", (int)this.slider.getValue());
        Preferences.putInteger((String)"alertwindow", (String)"foregroundcolor", (int)this.foregroundColor.getRGB());
    }
}

