/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import nu.fw.jeti.backend.roster.Roster;
import nu.fw.jeti.events.ErrorListener;
import nu.fw.jeti.events.IQResultListener;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.XData;
import nu.fw.jeti.jabber.elements.XDataBuilder;
import nu.fw.jeti.jabber.elements.XDataField;
import nu.fw.jeti.jabber.elements.XDataFieldBuilder;
import nu.fw.jeti.plugins.filetransfer.IQSi;
import nu.fw.jeti.plugins.filetransfer.Plugin;
import nu.fw.jeti.plugins.filetransfer.StreamSend;
import nu.fw.jeti.plugins.filetransfer.XSiFileTransfer;
import nu.fw.jeti.plugins.filetransfer.ibb.IBBSend;
import nu.fw.jeti.plugins.filetransfer.socks5.Socks5Send;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Preferences;

public class SendFileProgress
extends JFrame
implements IQResultListener {
    private Backend backend;
    private JID to;
    private StreamSend streamSend;
    private Timer timer;
    private String id;
    private File file;
    private boolean begun = false;
    private JButton btnAbort = new JButton();
    private JLabel toTxt = new JLabel();
    private JLabel fileTxt = new JLabel();
    private JLabel sizeTxt = new JLabel();
    private JLabel statusTxt = new JLabel();
    private JProgressBar progressBar = new JProgressBar();

    public SendFileProgress(Backend backend, JID jID, File file, String string) {
        this.backend = backend;
        this.to = jID;
        this.file = file;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JIDStatus jIDStatus = Roster.getJIDStatus((JID)jID);
        if (jIDStatus != null) {
            this.toTxt.setText(jIDStatus.getNick());
        } else {
            this.toTxt.setText(jID.toString());
        }
        this.fileTxt.setText(file.toString());
        this.sizeTxt.setText(Plugin.getSizeText(file.length()));
        this.statusTxt.setText(I18N.gettext((String)"filetransfer.Opening_connection") + "...");
        this.pack();
        this.setLocationRelativeTo(null);
        this.progressBar.setMaximum((int)(file.length() / 1024L));
        this.id = "file" + backend.getIdentifier();
        XDataBuilder xDataBuilder = new XDataBuilder();
        xDataBuilder.type = "form";
        XDataFieldBuilder xDataFieldBuilder = new XDataFieldBuilder();
        xDataFieldBuilder.var = "stream-method";
        xDataFieldBuilder.type = "list-single";
        if (Preferences.getBoolean((String)"filetransfer", (String)"bytestreams.enable", (boolean)true)) {
            xDataFieldBuilder.addOption("http://jabber.org/protocol/bytestreams");
        }
        if (Preferences.getBoolean((String)"filetransfer", (String)"ibb.enable", (boolean)true)) {
            xDataFieldBuilder.addOption("http://jabber.org/protocol/ibb");
        }
        xDataBuilder.addField(xDataFieldBuilder.build());
        XData xData = null;
        try {
            xData = xDataBuilder.build();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        IQSi iQSi = new IQSi(this.id, "http://jabber.org/protocol/si/profile/file-transfer", null, xData, new XSiFileTransfer(file.getName(), null, null, file.length(), string, 0, 0L));
        backend.send(new InfoQuery(jID, "set", "filetransfer" + backend.getIdentifier(), (IQExtension)iQSi), (IQResultListener)this, 0);
        backend.addListener(ErrorListener.class, (JETIListener)this);
    }

    private void jbInit() throws Exception {
        this.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
        this.setTitle(I18N.gettext((String)"filetransfer.File_Transfer"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 5, 0, 3);
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.weightx = 1.0;
        JLabel jLabel = new JLabel(I18N.gettext((String)"filetransfer.To"));
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        this.getContentPane().add((Component)this.toTxt, gridBagConstraints2);
        jLabel = new JLabel(I18N.gettext((String)"filetransfer.File_Name"));
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        this.getContentPane().add((Component)this.fileTxt, gridBagConstraints2);
        jLabel = new JLabel(I18N.gettext((String)"filetransfer.File_Size"));
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        this.getContentPane().add((Component)this.sizeTxt, gridBagConstraints2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        this.getContentPane().add((Component)this.statusTxt, gridBagConstraints);
        this.progressBar.setPreferredSize(new Dimension(300, 17));
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.progressBar, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.btnAbort);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btnAbort, gridBagConstraints);
        AbstractAction abstractAction = new AbstractAction(I18N.gettext((String)"filetransfer.Abort")){

            public void actionPerformed(ActionEvent actionEvent) {
                SendFileProgress.this.btnAbort_actionPerformed(actionEvent);
            }
        };
        this.btnAbort.setAction(abstractAction);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        JLayeredPane jLayeredPane = this.getLayeredPane();
        jLayeredPane.getActionMap().put("cancel", abstractAction);
        jLayeredPane.getInputMap(2).put(keyStroke, "abort");
    }

    void btnAbort_actionPerformed(ActionEvent actionEvent) {
        if (this.streamSend != null) {
            this.timer.stop();
            this.streamSend.cancel();
        }
        this.dispose();
    }

    public void iqResult(InfoQuery infoQuery) {
        if (infoQuery.getType().equals("result")) {
            IQSi iQSi = (IQSi)infoQuery.getIQExtension();
            XSiFileTransfer xSiFileTransfer = iQSi.getSiprofile();
            if (xSiFileTransfer != null) {
                // empty if block
            }
            String string = null;
            XData xData = iQSi.getXDataForm();
            if (xData.hasFields()) {
                Iterator iterator = xData.getFields();
                while (iterator.hasNext()) {
                    XDataField xDataField = (XDataField)iterator.next();
                    if (!"stream-method".equals(xDataField.getVar())) continue;
                    string = xDataField.getValue();
                }
            }
            if ("http://jabber.org/protocol/ibb".equals(string)) {
                this.streamSend = new IBBSend(this.file, this.backend, this, this.to, this.id);
            } else if ("http://jabber.org/protocol/bytestreams".equals(string)) {
                this.streamSend = new Socks5Send(this.file, this.backend, this, this.to, this.id);
            } else {
                Popups.messagePopup((String)I18N.gettext((String)"filetransfer.Problem_during_file_transfer,_transfer_aborted"), (String)I18N.gettext((String)"filetransfer.File_Transfer"));
                this.dispose();
                return;
            }
            this.initTimer();
        } else if (infoQuery.getType().equals("error")) {
            String string = infoQuery.getErrorCode() == 403 ? MessageFormat.format(I18N.gettext((String)"filetransfer.{0}_did_not_accept_the_file"), Roster.getJIDStatus((JID)this.to).getNick()) : (infoQuery.getErrorCode() == 404 ? MessageFormat.format(I18N.gettext((String)"filetransfer.{0}_is_not_online"), Roster.getJIDStatus((JID)this.to).getNick()) : (infoQuery.getErrorCode() == 400 ? I18N.gettext((String)"filetransfer.No_compatible_transfer_protocols_found") : (infoQuery.getErrorCode() == 501 ? MessageFormat.format(I18N.gettext((String)"filetransfer.{0}_does_not_support_file_transfer_or_is_offline"), Roster.getJIDStatus((JID)this.to).getNick()) : I18N.gettext((String)"filetransfer.Problem_during_file_transfer,_transfer_aborted"))));
            Popups.messagePopup((String)string, (String)this.file.getName());
            this.dispose();
        }
    }

    private void updateProgress() {
        int n = 0;
        n = (int)this.streamSend.getBytes() / 1024;
        if (n > 0 && !this.begun) {
            this.statusTxt.setText(I18N.gettext((String)"filetransfer.Transferring") + "...");
            this.begun = true;
        }
        this.progressBar.setValue(n);
    }

    private void initTimer() {
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SendFileProgress.this.updateProgress();
            }
        });
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
        this.dispose();
    }

    public void done() {
        this.timer.stop();
        this.updateProgress();
        this.streamSend = null;
        if (Preferences.getBoolean((String)"filetransfer", (String)"closeOnComplete", (boolean)false)) {
            this.dispose();
        } else {
            this.statusTxt.setText(I18N.gettext((String)"filetransfer.Transfer_complete"));
            this.btnAbort.setText(I18N.gettext((String)"filetransfer.Close"));
            this.progressBar.setValue(this.progressBar.getMaximum());
        }
    }
}

