/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.plugins.filetransfer.Plugin;
import nu.fw.jeti.plugins.filetransfer.SendFileProgress;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Preferences;
import nu.fw.jeti.util.Utils;

public class SendFileWindow
extends JFrame {
    private Backend backend;
    private JID jid;
    private JLabel jLabel1 = new JLabel();
    private JTextArea txtDescription = new JTextArea(4, 30);
    private JButton btnSelect = new JButton();
    private JTextField txtFilename = new JTextField();
    private JLabel jLabel2 = new JLabel();
    private JPanel btnPanel = new JPanel();
    private JButton btnSend = new JButton();
    private JButton btnCancel = new JButton();
    private File file;

    public SendFileWindow(Backend backend, JID jID) {
        this(backend, jID, new File(""));
    }

    public SendFileWindow(Backend backend, JID jID, File file) {
        this.backend = backend;
        this.file = file;
        this.jid = jID;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.pack();
        this.setLocationRelativeTo(null);
        this.toFront();
    }

    private void jbInit() throws Exception {
        this.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
        this.getRootPane().setDefaultButton(this.btnSend);
        this.setTitle(I18N.gettext((String)"filetransfer.File_Transfer"));
        this.txtFilename.setText(this.file.toString());
        I18N.setTextAndMnemonic((String)"filetransfer.Description", (JLabel)this.jLabel1);
        this.jLabel1.setLabelFor(this.txtDescription);
        this.jLabel1.setHorizontalAlignment(2);
        this.btnSelect.setText("...");
        this.btnSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SendFileWindow.this.btnSelect_actionPerformed(actionEvent);
            }
        });
        I18N.setTextAndMnemonic((String)"filetransfer.File_Name", (JLabel)this.jLabel2);
        this.jLabel2.setLabelFor(this.txtFilename);
        I18N.setTextAndMnemonic((String)"filetransfer.Send", (AbstractButton)this.btnSend);
        this.btnSend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SendFileWindow.this.btnSend_actionPerformed(actionEvent);
            }
        });
        AbstractAction abstractAction = new AbstractAction(I18N.gettext((String)"Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                SendFileWindow.this.dispose();
            }
        };
        Utils.addCancelButton((RootPaneContainer)this, (JButton)this.btnCancel, (Action)abstractAction);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 5, 0, 3);
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().add((Component)this.txtFilename, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.getContentPane().add((Component)this.btnSelect, gridBagConstraints);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)new JScrollPane(this.txtDescription), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        this.btnPanel.add((Component)this.btnSend, null);
        this.btnPanel.add((Component)this.btnCancel, null);
        this.getContentPane().add((Component)this.btnPanel, gridBagConstraints);
    }

    void btnSelect_actionPerformed(ActionEvent actionEvent) {
        int n;
        JFileChooser jFileChooser = Plugin.getFileChooser();
        String string = Preferences.getString((String)"filetransfer", (String)"uploadDir", null);
        if (string != null) {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        if ((n = jFileChooser.showOpenDialog(this)) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        Preferences.putString((String)"filetransfer", (String)"uploadDir", (String)file.getParent());
        this.txtFilename.setText(file.getAbsolutePath());
    }

    void btnSend_actionPerformed(ActionEvent actionEvent) {
        this.file = new File(this.txtFilename.getText());
        if (!this.file.isAbsolute()) {
            this.file = new File(Plugin.getFileChooser().getCurrentDirectory(), this.txtFilename.getText());
        }
        if (!this.file.exists()) {
            Popups.errorPopup((String)MessageFormat.format(I18N.gettext((String)"filetransfer.{0}_does_not_exist"), this.txtFilename.getText()), (String)I18N.gettext((String)"filetransfer.File_Error"));
            return;
        }
        if (!this.file.canRead()) {
            Popups.errorPopup((String)MessageFormat.format(I18N.gettext((String)"filetransfer.{0}_is_not_readable"), this.txtFilename.getText()), (String)"File Error");
            return;
        }
        new SendFileProgress(this.backend, this.jid, this.file, this.txtDescription.getText()).setVisible(true);
        this.dispose();
    }
}

