/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer;

import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.filetransfer.XSiFileTransfer;
import nu.fw.jeti.util.Log;
import org.xml.sax.Attributes;

public class XSiFileTransferHandler
extends ExtensionHandler {
    private String name;
    private String hash;
    private String date;
    private String description;
    private long size;
    private int length;
    private long offset;

    public void startHandling(Attributes attributes) {
        this.name = attributes.getValue("name");
        this.hash = attributes.getValue("hash");
        this.date = attributes.getValue("date");
        try {
            this.size = Long.parseLong(attributes.getValue("size"));
        }
        catch (NumberFormatException numberFormatException) {
            this.size = 0L;
            Log.xmlReceivedError((String)"Si profile, size is not a number");
        }
        this.length = 0;
        this.offset = 0L;
    }

    public void startElement(String string, Attributes attributes) {
        if (string.equals("range")) {
            try {
                this.length = Integer.parseInt(attributes.getValue("length"));
                this.offset = Long.parseLong(attributes.getValue("offset"));
            }
            catch (NumberFormatException numberFormatException) {
                this.size = 0L;
                Log.xmlReceivedError((String)"Si profile, range is not a number");
            }
        }
    }

    public void endElement(String string) {
        if (string.equals("desc")) {
            this.description = this.getText();
        }
        this.clearCurrentChars();
    }

    public Extension build() {
        return new XSiFileTransfer(this.name, this.hash, this.date, this.size, this.description, this.length, this.offset);
    }
}

