/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer.socks5;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.XMPPError;
import nu.fw.jeti.jabber.elements.XMPPErrorTag;
import nu.fw.jeti.plugins.filetransfer.GetFileWindow;
import nu.fw.jeti.plugins.filetransfer.Plugin;
import nu.fw.jeti.plugins.filetransfer.StreamReceive;
import nu.fw.jeti.plugins.filetransfer.socks5.Socks5Extension;
import nu.fw.jeti.plugins.filetransfer.socks5.StreamHost;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.Proxy;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.Socks5Proxy;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.SocksSocket;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;

public class ReceiveSocks5
extends Thread
implements StreamReceive {
    static final int BUF_SIZE = 8192;
    private Backend backend;
    private InfoQuery iq;
    private GetFileWindow getFileWindow;
    private long bytes;

    public ReceiveSocks5(Backend backend, InfoQuery infoQuery, GetFileWindow getFileWindow) {
        this.iq = infoQuery;
        this.getFileWindow = getFileWindow;
        this.backend = backend;
        this.setPriority(5);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        Object object2;
        Socks5Extension socks5Extension = (Socks5Extension)this.iq.getIQExtension();
        if (!socks5Extension.hasStreamHosts()) {
            this.sendError();
        }
        String string = Plugin.sha(socks5Extension.getSid(), this.iq.getFrom(), this.backend.getMyJID());
        SocksSocket socksSocket = null;
        if (socks5Extension.hasStreamHosts()) {
            object2 = socks5Extension.getStreamHosts();
            while (object2.hasNext()) {
                object = (StreamHost)((Object)object2.next());
                try {
                    socksSocket = new SocksSocket((Proxy)new Socks5Proxy(((StreamHost)((Object)object)).getHost(), ((StreamHost)((Object)object)).getPort()), string, 0);
                    this.backend.send((Packet)new InfoQuery(this.iq.getFrom(), "result", this.iq.getID(), (IQExtension)new Socks5Extension(((StreamHost)((Object)object)).getJID(), null)));
                    break;
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                }
            }
        }
        if (socksSocket == null) {
            this.sendError();
            Popups.messagePopup((String)I18N.gettext((String)"filetransfer.Problem_during_file_transfer,_transfer_aborted"), (String)I18N.gettext((String)"filetransfer.File_Transfer"));
            this.getFileWindow.stopDownloading();
            return;
        }
        object2 = null;
        object = this.getFileWindow.getOutputStream();
        object2 = socksSocket.getInputStream();
        if (object2 != null && object != null) {
            try {
                int n;
                byte[] byArray = new byte[8192];
                while ((n = ((InputStream)object2).read(byArray)) > 0) {
                    ((OutputStream)object).write(byArray, 0, n);
                    ((OutputStream)object).flush();
                    this.bytes += (long)n;
                    ReceiveSocks5.yield();
                    if (!Thread.interrupted()) continue;
                    ((OutputStream)object).close();
                    ((InputStream)object2).close();
                    return;
                }
            }
            catch (IOException iOException) {
                Popups.errorPopup((String)(iOException.getMessage() + " while downloading "), (String)"File transfer");
                this.getFileWindow.stopDownloading();
            }
            finally {
                try {
                    ((OutputStream)object).close();
                    ((InputStream)object2).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.getFileWindow.stopDownloading();
            }
        }
    }

    public long getBytes() {
        return this.bytes;
    }

    public void cancel() {
        this.interrupt();
    }

    private void sendError() {
        XMPPError xMPPError = new XMPPError("cancel", 404);
        xMPPError.addError(new XMPPErrorTag("item-not-found"));
        this.backend.send((Packet)new InfoQuery(this.iq.getFrom(), this.iq.getID(), xMPPError));
    }
}

