/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.sound;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.PreferencesPanel;
import nu.fw.jeti.plugins.sound.Plugin;
import nu.fw.jeti.ui.StdPreferencesPanel;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class PrefPanel
extends PreferencesPanel {
    private JTextField blockTime = new JTextField();
    List sounds = new LinkedList();
    JSlider slider;
    GridBagConstraints c = new GridBagConstraints();
    private JCheckBox chkBeep;
    private boolean oldBeep;

    public PrefPanel(Backend backend) {
        int n;
        this.setLayout(new GridBagLayout());
        this.c.gridwidth = 1;
        this.c.anchor = 21;
        this.c.fill = 2;
        this.c.insets = new Insets(3, 5, 0, 3);
        this.add(new JLabel(I18N.gettext((String)"sound.Enable")), this.c);
        this.c.weightx = 1.0;
        this.add(new JLabel(I18N.gettext((String)"sound.Path_to_sound")), this.c);
        this.c.weightx = 0.0;
        this.c.gridwidth = 0;
        this.add(new JLabel(I18N.gettext((String)"sound.Choose")), this.c);
        this.addSoundChooser("message");
        this.addSoundChooser("online");
        this.addSoundChooser("offline");
        this.addSoundChooser("own_online");
        this.addSoundChooser("own_offline");
        this.c.gridwidth = 1;
        this.add(new JLabel(I18N.gettext((String)"sound.Volume")), this.c);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(I18N.gettext((String)"sound.Min")));
        int n2 = 15;
        if (System.getProperty("java.version").startsWith("1.5")) {
            n2 = 6;
        }
        if ((n = Preferences.getInteger((String)"sound", (String)"volume", (int)0)) > n2) {
            n = n2;
        }
        this.slider = new JSlider(-20, n2, n);
        jPanel.add(this.slider);
        jPanel.add(new JLabel(I18N.gettext((String)"sound.Max")));
        this.add(jPanel, this.c);
        JButton jButton = new JButton();
        I18N.setTextAndMnemonic((String)"sound.Test", (AbstractButton)jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.putInteger((String)"sound", (String)"volume", (int)PrefPanel.this.slider.getValue());
                Plugin.test();
            }
        });
        this.c.gridwidth = 0;
        this.add(jButton, this.c);
        this.blockTime.setText(Preferences.getString((String)"sound", (String)"block", (String)"2"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel(I18N.gettext((String)"sound.Block_repeats_of_sound_within") + " "), "Before");
        jPanel2.add((Component)this.blockTime, "Center");
        jPanel2.add((Component)new JLabel(" (" + I18N.gettext((String)"sound.seconds") + ")"), "After");
        this.add(jPanel2, this.c);
        this.c.gridwidth = 0;
        this.chkBeep = new JCheckBox(I18N.gettext((String)"main.options.standard.Beep_on_new_message"));
        this.chkBeep.setToolTipText(I18N.gettext((String)"main.options.standard.tooltip.Beep_on_new_message_arrival"));
        this.oldBeep = Preferences.getBoolean((String)"jeti", (String)"beep", (boolean)true);
        this.chkBeep.setSelected(this.oldBeep);
        this.add(this.chkBeep, this.c);
        this.c.gridwidth = 3;
        this.c.weighty = 1.0;
        this.c.weightx = 1.0;
        this.add(Box.createVerticalGlue(), this.c);
        new ButtonLinker(this.chkBeep, StdPreferencesPanel.chkBeep);
    }

    private void addSoundChooser(String string) {
        this.c.gridwidth = 1;
        String string2 = Preferences.getString((String)"sound", (String)string, null);
        JCheckBox jCheckBox = new JCheckBox(I18N.gettext((String)("sound." + string)));
        jCheckBox.setSelected(Preferences.getBoolean((String)"sound", (String)(string + ".enabled"), (boolean)true));
        this.add(jCheckBox, this.c);
        final JTextField jTextField = new JTextField(string2);
        this.add(jTextField, this.c);
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        String string = this.getExtension(file);
                        return string != null && (string.equals("wav") || string.equals("aiff") || string.equals("au"));
                    }

                    public String getDescription() {
                        return "Audio files";
                    }

                    private String getExtension(File file) {
                        String string = null;
                        String string2 = file.getName();
                        int n = string2.lastIndexOf(46);
                        if (n > 0 && n < string2.length() - 1) {
                            string = string2.substring(n + 1).toLowerCase();
                        }
                        return string;
                    }
                });
                int n = jFileChooser.showOpenDialog((Component)((Object)PrefPanel.this));
                if (n == 0) {
                    jTextField.setText(jFileChooser.getSelectedFile().getPath());
                }
            }
        });
        this.c.gridwidth = 0;
        this.add(jButton, this.c);
        this.sounds.add(new Object[]{string, jCheckBox, jTextField});
    }

    public void savePreferences() {
        Iterator iterator = this.sounds.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            String string = (String)objectArray[0];
            Preferences.putBoolean((String)"sound", (String)(string + ".enabled"), (boolean)((JCheckBox)objectArray[1]).isSelected());
            String string2 = ((JTextField)objectArray[2]).getText();
            if (string2.equals("")) {
                Preferences.putString((String)"sound", (String)string, null);
                continue;
            }
            Preferences.putString((String)"sound", (String)string, (String)string2);
        }
        Plugin.reloadSounds();
        int n = this.slider.getValue();
        if (Preferences.getInteger((String)"sound", (String)"volume", (int)0) != n) {
            Preferences.putInteger((String)"sound", (String)"volume", (int)n);
        }
        if (!this.blockTime.getText().equals("")) {
            try {
                int n2 = Integer.parseInt(this.blockTime.getText());
                Preferences.putInteger((String)"sound", (String)"block", (int)n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static class ButtonLinker
    implements ChangeListener {
        private AbstractButton but1;
        private AbstractButton but2;
        private boolean ignore = false;

        public ButtonLinker(AbstractButton abstractButton, AbstractButton abstractButton2) {
            this.but1 = abstractButton;
            this.but2 = abstractButton2;
            abstractButton.addChangeListener(this);
            abstractButton2.addChangeListener(this);
        }

        public synchronized void stateChanged(ChangeEvent changeEvent) {
            if (this.ignore) {
                return;
            }
            this.ignore = true;
            if (this.but1.isSelected() != this.but2.isSelected()) {
                if (changeEvent.getSource().equals(this.but1)) {
                    this.but2.setSelected(this.but1.isSelected());
                } else {
                    this.but1.setSelected(this.but2.isSelected());
                }
            }
            this.ignore = false;
        }
    }
}

