/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.emoticons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.images.Icons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.Emoticons;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.plugins.Word;
import nu.fw.jeti.plugins.emoticons.Emoticon;
import nu.fw.jeti.plugins.emoticons.EmoticonsEditorKit;
import nu.fw.jeti.plugins.emoticons.EmoticonsHandler;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Plugin
implements Plugins,
Emoticons {
    private List emoticons;
    private SimpleAttributeSet sas = new SimpleAttributeSet();
    private static Map smilies;
    private static Map smilieList;
    private List currentIconSet;
    private Emoticon[] displayableIconList;
    public static final String VERSION = "1.8";
    public static final String DESCRIPTION = "emoticons.Shows_graphical_emoticons";
    public static final String MIN_JETI_VERSION = "0.5.3";
    public static final String NAME = "emoticons";
    public static final String ABOUT = "by E.S. de Boer";
    private SAXParser parser;

    public Plugin() {
        this.emoticons = Preferences.getPlugable((String)NAME);
    }

    private void loadParser() {
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    public static void init(Backend backend) throws IOException {
        new Plugin(backend);
    }

    public Plugin(Backend backend) throws IOException {
        this.loadParser();
        new Icons(this.parser, NAME);
        this.emoticons = Preferences.getPlugable((String)NAME);
        smilies = new HashMap();
        smilieList = new HashMap();
        Iterator iterator = this.emoticons.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            if (!((Boolean)objectArray[1]).booleanValue()) continue;
            this.loadEmoticon((String)objectArray[4], (String)objectArray[3]);
        }
        this.parser = null;
    }

    public void unload() {
    }

    public void init(JTextPane jTextPane, JPanel jPanel, final JTextPane jTextPane2, final JPopupMenu jPopupMenu, String string, JMenu jMenu) throws IllegalStateException {
        if (smilieList.isEmpty()) {
            return;
        }
        jTextPane.setEditorKit(new EmoticonsEditorKit());
        final JButton jButton = new JButton(new ImageIcon(this.getClass().getResource("emoticon.gif")));
        if (PluginsInfo.isPluginLoaded((String)"xhtml")) {
            jButton.setToolTipText(I18N.gettext((String)"emoticons.Emoticons"));
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.setPreferredSize(new Dimension(23, 23));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jPopupMenu.show(jButton, 10, jButton.getY());
                }
            });
            jPanel.add(jButton);
        }
        JMenu jMenu2 = new JMenu(I18N.gettext((String)"emoticons.Emoticons"));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        Iterator iterator = smilies.keySet().iterator();
        while (iterator.hasNext()) {
            final String string2 = (String)iterator.next();
            jRadioButtonMenuItem = new JRadioButtonMenuItem(string2);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Plugin.this.currentIconSet = (List)smilies.get(string2);
                    Plugin.access$202(Plugin.this, (Emoticon[])smilieList.get(string2));
                    jPopupMenu.setEnabled(true);
                    Plugin.this.buildSelectIcons(jPopupMenu, jTextPane2);
                    jButton.setVisible(true);
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu2.add(jRadioButtonMenuItem);
        }
        jRadioButtonMenuItem = new JRadioButtonMenuItem(I18N.gettext((String)"emoticons.No_Emoticons"));
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Plugin.this.currentIconSet = null;
                jPopupMenu.setEnabled(false);
                jButton.setVisible(false);
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        jMenu2.add(jMenu2);
        if (jMenu != null) {
            jMenu.add(jMenu2);
        }
        this.currentIconSet = (List)smilies.get(string);
        this.displayableIconList = (Emoticon[])smilieList.get(string);
        if (this.currentIconSet == null) {
            string = "default";
            this.currentIconSet = (List)smilies.get(string);
            this.displayableIconList = (Emoticon[])smilieList.get(string);
        }
        if (this.currentIconSet == null) {
            jRadioButtonMenuItem = (JRadioButtonMenuItem)jMenu2.getItem(0);
            this.currentIconSet = (List)smilies.get(jRadioButtonMenuItem.getText());
            this.displayableIconList = (Emoticon[])smilieList.get(jRadioButtonMenuItem.getText());
        }
        this.buildSelectIcons(jPopupMenu, jTextPane2);
    }

    private void buildSelectIcons(final JPopupMenu jPopupMenu, final JTextPane jTextPane) {
        jPopupMenu.removeAll();
        int n = this.displayableIconList.length;
        jPopupMenu.setLayout(new GridLayout((int)Math.sqrt(n), (int)Math.sqrt(n)));
        JLabel jLabel = null;
        for (int i = 0; i < this.displayableIconList.length; ++i) {
            Emoticon emoticon = this.displayableIconList[i];
            ImageIcon imageIcon = emoticon.getIcon();
            final String string = emoticon.toString();
            jLabel = new JLabel(imageIcon);
            if (string.length() > 5) {
                jLabel.setText("...");
                jLabel.setToolTipText(string);
            } else {
                jLabel.setText(string);
            }
            jLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    Document document = jTextPane.getDocument();
                    try {
                        document.insertString(jTextPane.getCaretPosition(), string, null);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    jPopupMenu.setVisible(false);
                }
            });
            jLabel.setBackground(Color.white);
            jPopupMenu.add(jLabel);
        }
        jPopupMenu.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                jTextPane.requestFocusInWindow();
            }
        });
    }

    public void insertEmoticons(List list) {
        if (this.currentIconSet != null) {
            block0: for (int i = 0; i < list.size(); ++i) {
                Word word = (Word)list.get(i);
                String string = word.word;
                if (string.length() <= 1) continue;
                Iterator iterator = this.currentIconSet.iterator();
                while (iterator.hasNext()) {
                    Emoticon emoticon = (Emoticon)iterator.next();
                    String string2 = emoticon.toString();
                    if (string.equals(string2)) {
                        this.setIcon(this.sas, emoticon);
                        word.addAttributes((AttributeSet)this.sas);
                        continue block0;
                    }
                    if (string.startsWith(string2)) {
                        word.word = "o";
                        this.setIcon(this.sas, emoticon);
                        word.addAttributes((AttributeSet)this.sas);
                        list.add(i + 1, new Word(" "));
                        list.add(i + 2, new Word(string.substring(string2.length())));
                        ++i;
                        continue block0;
                    }
                    if (!string.endsWith(string2)) continue;
                    word.word = string.substring(0, string.length() - string2.length());
                    list.add(i + 1, new Word(" "));
                    this.setIcon(this.sas, emoticon);
                    list.add(i + 2, new Word("o", (MutableAttributeSet)((SimpleAttributeSet)this.sas.clone())));
                    --i;
                    continue block0;
                }
            }
        }
    }

    private void setIcon(SimpleAttributeSet simpleAttributeSet, Emoticon emoticon) {
        StyleConstants.setIcon(simpleAttributeSet, new ImageIcon(emoticon.getIcon().getImage()));
    }

    public void loadEmoticon(String string, String string2) {
        String string3 = string.substring(0, string.lastIndexOf("."));
        InputStream inputStream = null;
        URL uRL = null;
        try {
            uRL = this.getClass().getResource("/" + string3 + "/");
            if (uRL == null) {
                uRL = new URL("jar:" + Start.dataURL + "plugins/emoticons/" + string + "!/" + string3 + "/");
            }
            inputStream = new URL(uRL, "icondef.xml").openStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (uRL == null) {
            System.out.println(string + " not found");
            return;
        }
        try {
            LinkedList linkedList;
            if (this.parser == null) {
                this.loadParser();
            }
            if ((linkedList = (LinkedList)smilies.get(string2)) == null) {
                linkedList = new LinkedList();
                smilies.put(string2, linkedList);
            }
            this.parser.parse(inputStream, (DefaultHandler)new EmoticonsHandler(uRL, linkedList));
            Collections.sort(linkedList);
            HashSet<Emoticon> hashSet = new HashSet<Emoticon>(linkedList);
            Object[] objectArray = (Emoticon[])smilieList.get(string2);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    hashSet.add(objectArray[i]);
                }
            } else {
                objectArray = new Emoticon[hashSet.size()];
            }
            objectArray = hashSet.toArray(objectArray);
            Arrays.sort(objectArray);
            smilieList.put(string2, objectArray);
        }
        catch (SAXException sAXException) {
            sAXException.getException().printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void unloadEmoticon(String string) {
        System.out.println("removing" + string);
        smilieList.remove(string);
        smilies.remove(string);
    }

    static /* synthetic */ Emoticon[] access$202(Plugin plugin, Emoticon[] emoticonArray) {
        plugin.displayableIconList = emoticonArray;
        return emoticonArray;
    }
}

