/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.xhtml;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.Word;
import nu.fw.jeti.plugins.xhtml.XHTML;
import nu.fw.jeti.util.Log;
import org.xml.sax.Attributes;

public class XHTMLHandler
extends ExtensionHandler {
    private List wordList = new ArrayList();
    private SimpleAttributeSet currentAttributes;
    private StringBuffer body;

    public void startHandling(Attributes attributes) {
        this.reset();
        this.body = new StringBuffer();
    }

    private void reset() {
        this.body = null;
        this.wordList.clear();
        this.currentAttributes = new SimpleAttributeSet();
    }

    public void startElement(String string, Attributes attributes) {
        this.addToWordList(this.getUntrimmedText());
        this.body.append(this.getText() + "<" + string + " ");
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.body.append(attributes.getQName(i) + "=\"" + attributes.getValue(i) + "\"");
        }
        this.body.append(">");
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.setResolveParent(this.currentAttributes);
        if (string.equals("body")) {
            this.parseStyle(attributes.getValue("style"), simpleAttributeSet);
            this.currentAttributes = simpleAttributeSet;
        } else if (string.equals("blockquote")) {
            StyleConstants.setLeftIndent(simpleAttributeSet, 10.0f);
            StyleConstants.setRightIndent(simpleAttributeSet, 10.0f);
            this.parseStyle(attributes.getValue("style"), simpleAttributeSet);
            this.currentAttributes = simpleAttributeSet;
            this.wordList.add(new Word("\n", (MutableAttributeSet)simpleAttributeSet));
        } else if (string.equals("q")) {
            this.parseStyle(attributes.getValue("style"), simpleAttributeSet);
            this.currentAttributes = simpleAttributeSet;
            this.wordList.add(new Word("'", (MutableAttributeSet)simpleAttributeSet));
        } else if (string.equals("pre")) {
            StyleConstants.setFontFamily(simpleAttributeSet, "courier");
            this.parseStyle(attributes.getValue("style"), simpleAttributeSet);
            this.currentAttributes = simpleAttributeSet;
        } else if (string.equals("li") || string.equals("ol") || string.equals("ul")) {
            this.parseStyle(attributes.getValue("style"), simpleAttributeSet);
            this.currentAttributes = simpleAttributeSet;
        } else if (string.equals("h1")) {
            StyleConstants.setFontSize(simpleAttributeSet, 32);
            this.parseStyle(attributes.getValue("style"), simpleAttributeSet);
            this.currentAttributes = simpleAttributeSet;
        } else if (string.equals("h2")) {
            StyleConstants.setFontSize(simpleAttributeSet, 24);
            this.parseStyle(attributes.getValue("style"), simpleAttributeSet);
            this.currentAttributes = simpleAttributeSet;
        } else if (string.equals("h3")) {
            StyleConstants.setFontSize(simpleAttributeSet, 18);
            this.parseStyle(attributes.getValue("style"), simpleAttributeSet);
            this.currentAttributes = simpleAttributeSet;
        } else if (string.equals("a")) {
            StyleConstants.setFontFamily(simpleAttributeSet, "courier");
            this.parseStyle(attributes.getValue("style"), simpleAttributeSet);
            this.currentAttributes = simpleAttributeSet;
        } else if (string.equals("img")) {
            StyleConstants.setFontFamily(simpleAttributeSet, "courier");
            this.parseStyle(attributes.getValue("style"), simpleAttributeSet);
            this.currentAttributes = simpleAttributeSet;
        } else if (string.equals("span") || string.equals("div") || string.equals("p")) {
            this.parseStyle(attributes.getValue("style"), simpleAttributeSet);
            this.currentAttributes = simpleAttributeSet;
        } else if (string.equals("em") || string.equals("cite")) {
            StyleConstants.setItalic(simpleAttributeSet, true);
            this.currentAttributes = simpleAttributeSet;
        } else if (string.equals("strong")) {
            StyleConstants.setBold(simpleAttributeSet, true);
            this.currentAttributes = simpleAttributeSet;
        } else if (string.equals("code")) {
            StyleConstants.setFontFamily(simpleAttributeSet, "courier");
            this.currentAttributes = simpleAttributeSet;
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<" + string + " ");
            for (int i = 0; i < attributes.getLength(); ++i) {
                stringBuffer.append(attributes.getQName(i) + "=\"" + attributes.getValue(i) + "\"");
            }
            stringBuffer.append(">");
            Log.notParsedXML((String)stringBuffer.toString());
        }
        this.clearCurrentChars();
    }

    private void parseStyle(String string, SimpleAttributeSet simpleAttributeSet) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(":");
            if (stringArray2.length != 2) continue;
            String string2 = stringArray2[0].trim();
            String string3 = stringArray2[1].trim();
            if (string2.equals("color")) {
                Color color;
                if (string3.length() != 7) {
                    string3 = string3 + "000000";
                    string3 = string3.substring(0, 7);
                }
                try {
                    color = Color.decode(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    color = Color.BLACK;
                }
                StyleConstants.setForeground(simpleAttributeSet, color);
                continue;
            }
            if (string2.equals("background-color")) {
                Color color;
                try {
                    color = Color.decode(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    color = Color.WHITE;
                }
                StyleConstants.setBackground(simpleAttributeSet, color);
                continue;
            }
            if (string2.equals("font-family")) {
                StyleConstants.setFontFamily(simpleAttributeSet, string3);
                continue;
            }
            if (string2.equals("font-size")) {
                int n;
                try {
                    n = Integer.parseInt(string3.substring(0, string3.length() - 2));
                }
                catch (NumberFormatException numberFormatException) {
                    n = 12;
                }
                StyleConstants.setFontSize(simpleAttributeSet, n);
                continue;
            }
            if (string2.equals("text-decoration")) {
                if (string3.equals("underline")) {
                    StyleConstants.setUnderline(simpleAttributeSet, true);
                    continue;
                }
                if (!string3.equals("line-through")) continue;
                StyleConstants.setStrikeThrough(simpleAttributeSet, true);
                continue;
            }
            if (!string2.equals("text-align")) continue;
            if (string3.equals("left")) {
                StyleConstants.setAlignment(simpleAttributeSet, 0);
                continue;
            }
            if (string3.equals("rigth")) {
                StyleConstants.setAlignment(simpleAttributeSet, 2);
                continue;
            }
            if (string3.equals("center")) {
                StyleConstants.setAlignment(simpleAttributeSet, 1);
                continue;
            }
            if (!string3.equals("justify")) continue;
            StyleConstants.setAlignment(simpleAttributeSet, 3);
        }
    }

    public void endElement(String string) {
        this.addToWordList(this.getUntrimmedText());
        this.body.append(this.getText() + "</" + string + ">");
        if (string.equals("a") || string.equals("body") || string.equals("cite") || string.equals("code") || string.equals("div") || string.equals("em") || string.equals("h1") || string.equals("h2") || string.equals("h3") || string.equals("img") || string.equals("li") || string.equals("ol") || string.equals("p") || string.equals("pre") || string.equals("ul") || string.equals("strong") || string.equals("span")) {
            this.currentAttributes = (SimpleAttributeSet)this.currentAttributes.getResolveParent();
        } else if (string.equals("br")) {
            this.wordList.add(new Word("\n"));
        } else if (string.equals("q")) {
            this.wordList.add(new Word("'", (MutableAttributeSet)this.currentAttributes));
            this.currentAttributes = (SimpleAttributeSet)this.currentAttributes.getResolveParent();
        } else if (string.equals("blockquote")) {
            this.wordList.add(new Word("\n", null));
            this.currentAttributes = (SimpleAttributeSet)this.currentAttributes.getResolveParent();
        }
        this.clearCurrentChars();
    }

    private void addToWordList(StringBuffer stringBuffer) {
        if (stringBuffer.length() < 1) {
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        block5: for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            switch (c) {
                case ' ': {
                    this.addWordFromTemp(stringBuffer2);
                    this.wordList.add(new Word(" "));
                    stringBuffer2 = new StringBuffer();
                    continue block5;
                }
                case '\n': {
                    this.addWordFromTemp(stringBuffer2);
                    this.wordList.add(new Word("\n"));
                    stringBuffer2 = new StringBuffer();
                    continue block5;
                }
                case '\t': {
                    this.addWordFromTemp(stringBuffer2);
                    this.wordList.add(new Word("\t"));
                    stringBuffer2 = new StringBuffer();
                    continue block5;
                }
                default: {
                    stringBuffer2.append(c);
                }
            }
        }
        this.addWordFromTemp(stringBuffer2);
    }

    private void addWordFromTemp(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0) {
            this.wordList.add(new Word(stringBuffer, (MutableAttributeSet)this.currentAttributes));
        }
    }

    public Extension build() {
        this.addToWordList(this.getUntrimmedText());
        this.body.append(this.getText());
        this.clearCurrentChars();
        XHTML xHTML = new XHTML(this.body.toString(), new ArrayList(this.wordList));
        this.reset();
        return xHTML;
    }
}

