/*------------------------------------------------------
Library Name: "datenkueche-jabber-connector"
Version: 0.23

This is a pure XML (AJAX) low level library for Javascript to jabber http-binding (jep-0124)

2006 Bernhard Zwischenbrugger
bz@datenkueche.com
(C) LGPL (http://www.gnu.org/licenses/lgpl.html)
If you need a different licence please ask.

If you extend this file, please write your name here:


Knows Bugs:
-  It' not really object oriented

Change log:

----------------------------------------------------*/

function jabberConnect(loginserver){
	this.lastSent="unknown";
	this.lastlastSent="unknown";
	this.lastReceived="unknown";
	this.lastReceiveStatus="unknown";
	this.lastReadyState="unknown";
	this.ready="yes";
	this.timestamp=0;
	this.timeout=null;
	this.delay="unknown";
	this.debug=0;
	this.requestCount=0;
	this.requests=0;
	this.errorText="success";
	this.error=false;
	this.fifoArray=new Array();
	this.rid=Math.round(Math.random()*999999);
	var xml="<body content='text/xml; charset=utf-8' hold='20' rid='"+this.rid+"' to='"+loginserver+"' wait='50' xml:lang='en' xmlns='http://jabber.org/protocol/httpbind'/>";
	this.rid++;
        //syncronous request
	var xmlhttp = new XMLHttpRequest();
        xmlhttp.open("POST", jep124server, false);
	//alert(xml);
        xmlhttp.send(xml);
        if (xmlhttp.readyState==4) {
		if (xmlhttp.status == 200) {
			//alert(xmlhttp.responseText);
			this.sid=xmlhttp.responseXML.documentElement.getAttribute('sid');
			this.authid=xmlhttp.responseXML.documentElement.getAttribute('authid');
			if(this.sid==null){
				this.error=true;	
				this.errorText="no sid";
				this.status();	
			}
		}else{
			//alert(xmlhttp.responseText);
			this.error=true;
			this.errorText="http binding error";
			this.status();	
		}
	}else{
		this.error=true;
		this.errorText="ready state != 4 for synchronous http request";	
		this.status();
	}
	xmlhttp.abort();
}

jabberConnect.prototype.status=function(){
	if((typeof datenkuecheStatus == "function")){
		datenkuecheStatus();
	}else{
		if(this.error){
			alert("error: "+this.lastReceive);
		}
	}
}

jabberConnect.prototype.send = function(stanza) {
	clearTimeout(this.timeout);
	//alert("send: "+this.requests);
	if(this.error){
		return;
	}
	//start workaround (not aktive)	
	if(stanza==""){
		if(this.requests > 0){
			if(this.fifoArray.length==0){
				return;
			}
		}
	}
	//end workaround	
	if(this.requests > 1){
		if(stanza==""){
			alert("empty!!!!");
		}
		this.fifoArray.push(stanza);
		return;
	}
	//workaround for http-binding bug
	jetzt=new Date().getTime();
	this.delay=jetzt - this.timestamp;

	if(this.delay < 200){
		this.fifoArray.push(stanza);
		if(this.requests < 1){
			this.timeout=setTimeout("jabber.send('')",500);
		}
		return;
	}

	this.timestamp=jetzt;
	//end workaround
	this.requests++;
	sendThis=stanza;
        for(var z=0; z < 5; z++){
                if(this.fifoArray.length >0){
                        sendThis=sendThis+this.fifoArray.shift();
                }
        }

	var xmlhttp = new XMLHttpRequest();
	var xml="<body  rid='"+this.rid+"' sid='"+this.sid+"'  xmlns='http://jabber.org/protocol/httpbind'>";
	this.rid++;
	xml+=sendThis;
	xml+="</body>\n\n";
	this.lastlastSent=this.lastSent;
	this.lastSent=xml;
	xmlhttp.open("POST", jep124server, true);
	var obj=this;
	xmlhttp.onreadystatechange=function() {
	  if (xmlhttp.readyState==4) {
		//no idea where the empty string comes form
		if(xmlhttp.responseText==""){
			return;	
		}
		//alert(xmlhttp.responseText);
		jabber.lastReadyState=4;
		jabber.lastReceived=xmlhttp.responseText;
		//alert("receive: "+obj.requests);
		jabber.requests--;   //this breaks everything !!!!!!!!!!!!!!!!!!!!!
		//jabber.status();
		datenkueche_com_jabbercallback(xmlhttp,obj);  //really bad!!!!!!!!!!
	  }else{
		//jabber.lastReadyState=xmlhttp.readyState;
		//jabber.status();

	  }
	}
	this.requestCount++;
		jabber.status();
	xmlhttp.send(xml);
	//alert(xml);

}


function datenkueche_com_jabbercallback(xmlhttp,obj) {
	try{
		var status=xmlhttp.status;
	}catch(e){
		if(obj.requests < 1){
			obj.send('');
		}
		obj.errorText="empty and no status";
		obj.status();
		return;
	}
        if (status == 200) {
		obj.lastStatus=status;
		//alert(xmlhttp.responseText);
		if(xmlhttp.responseXML!=null){
				this.ready="no";
				for(var i=0; i < xmlhttp.responseXML.documentElement.childNodes.length; i++){
					//call the function provided by the user
					if((typeof receive == "function")){
						receive(xmlhttp.responseXML.documentElement.childNodes.item(i));
					}else{
						alert("Function 'receive(stanza)' missing, please provide this callback function");
					}
				}	
				this.ready="yes";
			if(obj.requests < 1){
				obj.debug++;	
				//obj.send('');
				obj.send('');
				//obj.timeout=setTimeout("obj.send('')",2000);
				//setTimeout("jabber.send('')",200000);
			}
		}else{
			obj.error=true;
			obj.errorText="XML Parse error";
			obj.status();
		}
		
	}else{
		obj.error=true;
		obj.errorText="HTTP Code != 200";
		obj.lastStatus=xmlhttp.status;
		obj.status();
	}
	xmlhttp.abort();
}


function sha1(s){
        function X(x,y){var l=(x&0xFFFF)+(y&0xFFFF),m=(x>>16)+(y>>16)+(l>>16);return(m<<16)|(l&0xFFFF)}
        function Y(x,y){return(x<<y)|(x>>>(32-y))}
        var len=s.length*8,i,L=((len+64>>9)<<4)+16,x=Array(L+79),w=Array(80),a=1732584193,b=-271733879,c=-1732584194,d=271733878,e=-1009589776;
        for(i=0;i<x.length;++i)x[i]=0;
        for(i=0;i<len;i+=8)x[i>>5]|=(s.charCodeAt(i/8)&255)<<(24-i%32);
        x[len>>5]|=0x80<<(24-len%32);
        x[L-1]=len;
        for(i=0;i<L;i+=16){
                var oa=a,ob=b,oc=c,od=d,oe=e;
                for(var j=0;j<80;j++){
                        w[j]=(j<16)?x[i+j]:Y(w[j-3]^w[j-8]^w[j-14]^w[j-16],1);
                        var t=X(X(Y(a,5),((j<20)?((b&c)|((~b)&d)):((j<40||j>=60)?(b^c^d):((b&c)|(b&d)|(c&d))))),X(X(e,w[j]),((j<20)?1518500249:(j<40)?1859775393:(j<60)?-1894007588:
-899497514)));
                        e=d;
                        d=c;
                        c=Y(b,30);
                        b=a;
                        a=t;
                }
                a=X(a,oa);
                b=X(b,ob);
                c=X(c,oc);
                d=X(d,od);
                e=X(e,oe);
        }
        x=[a,b,c,d,e];
        a="0123456789abcdef";
        b="";
        for(i=0;i<20;i++)b+=a.charAt((x[i>>2]>>((3-i%4)*8+4))&0xF)+a.charAt((x[i>>2]>>((3-i%4)*8))&0xF);
        return b
}

Date.prototype.toISO8601String = function (format, offset) {
/* accepted values for the format [1-6]:
1 Year:
YYYY (eg 1997)
2 Year and month:
YYYY-MM (eg 1997-07)
3 Complete date:
YYYY-MM-DD (eg 1997-07-16)
4 Complete date plus hours and minutes:
YYYY-MM-DDThh:mmTZD (eg 1997-07-16T19:20+01:00)
5 Complete date plus hours, minutes and seconds:
YYYY-MM-DDThh:mm:ssTZD (eg 1997-07-16T19:20:30+01:00)
6 Complete date plus hours, minutes, seconds and a decimal
fraction of a second
YYYY-MM-DDThh:mm:ss.sTZD (eg 1997-07-16T19:20:30.45+01:00)
*/
if (!format) { var format = 6; }
if (!offset) {
var offset = 'Z';
var date = this;
} else {
var d = offset.match(/([-+])([0-9]{2}):([0-9]{2})/);
var offsetnum = (Number(d[2]) * 60) + Number(d[3]);
offsetnum *= ((d[1] == '-') ? -1 : 1);
var date = new Date(Number(Number(this) + (offsetnum * 60000)));
}

var zeropad = function (num) { return ((num < 10) ? '0' : '') + num; }

var str = "";
str += date.getUTCFullYear();
if (format > 1) { str += "-" + zeropad(date.getUTCMonth() + 1); }
if (format > 2) { str += "-" + zeropad(date.getUTCDate()); }
if (format > 3) {
str += "T" + zeropad(date.getUTCHours()) +
":" + zeropad(date.getUTCMinutes());
}
if (format > 5) {
var secs = Number(date.getUTCSeconds() + "." +
((date.getUTCMilliseconds() < 100) ? '0' : '') +
zeropad(date.getUTCMilliseconds()));
str += ":" + zeropad(secs);
} else if (format > 4) { str += ":" + zeropad(date.getUTCSeconds()); }

//if (format > 3) { str += offset; }
return str;
}
