<?php
/*
Jabber Roster Utility in PHP
2005-6 by Yves Goergen, http://beta.unclassified.de/projekte/jru-php
Version 0.6.1
Released under the terms of the GNU GPL license

Version history:
0.1 (2005-03-18)
	i Initial release

0.2 (2005-03-19)
	+ Added CSS skinning
	+ Added localisation (translation)

0.3pre1 (2005-03-21)
	! Fixed custom server port handling
	* Updated Class.Jabber.PHP from version 0.4 to 0.4.2
	* Class.Jabber.PHP currently doesn't support PHP5. Use PHP4 instead.

0.3pre2 (2005-04-14)
	! Fixed roster items handling (adding) with apostrophes in their display name

0.3pre3 (2005-04-26)
	! Complete subscription handling on contact update

0.4 (2006-01-04)
	! JID check should work better now
	i Still no PHP5 support, skipped version 0.3

0.4.1 (2006-01-21)
	! Corrected web link from jabber.org to www.jabber.org

0.5 (2006-05-19)
	* Patched Class.Jabber.PHP to handle STARTTLS and PHP5 (see the source for URLs to the patch)
	* We're Google Talk compatible now

0.6 (2006-05-31)
	* Original JRU compatible syntax (changed ";" to "," and added separate +/- column to the line beginning)
	  This resolves a problem with JIDs beginning with a "+" like for mobile phone transports.
	! Beautified texts and user interaction a bit
	+ Added Polish translation (Thanks to Patryk Szczyg&#x0142;owski)
	+ Added Russian translation (Thanks to Oleg Motienko)
	+ Added optional runtime parameters. Enter them in the JID field as "me@mydomain.de::parameters".
	  First parameter is "log" to enable logging.
	! Fixed potential issues with contact/group names containing HTML special characters

0.6.1 (2006-07-15)
	+ Added French translation (Thanks to Azerttyu.net)

0.6.2 (2006-08-12)
	+ Added Dutch translation (Thanks to Sander Devrieze)

*/

// Find out browser languages in correct order
$raw_lang = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
$lang_code = array();
$lang_prio = array();
foreach ($raw_lang as $lang)   // for each language
{
	$lang = explode(';', $lang);
	array_push($lang_code, $lang[0]);   // store the code
	$lang = explode('=', $lang[1]);
	if (!$lang[0]) $lang = array('', 1);   // default priority to 1
	array_push($lang_prio, $lang[1]);   // store the priority
}
array_multisort($lang_prio, SORT_DESC, SORT_NUMERIC, $lang_code);   // build correct order
//$lang_str = str_replace(' ', '', join(',', $lang_code));

$lang = 'en';
foreach ($lang_code as $thislang)
{
	if (@file_exists('jru-' . $thislang . '.php'))
	{
		$lang = $thislang;
		break;
	}
}

@include('jru-' . $lang . '.php');
if (!isset($JRU_T)) die('Language file not found.');

header('Content-type: text/html; charset=UTF-8');
echo '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title><?php echo $JRU_T['page_title'] ?></title>
<link rel="stylesheet" type="text/css" href="jru.css" />
</head>
<body>

<h1><?php echo $JRU_T['page_title'] ?></h1>

<p>
<?php echo $JRU_T['intro'] ?>
</p>

<hr />

<h2><?php echo $JRU_T['header_account_data'] ?></h2>

<form method="post">

<p>
<?php echo $JRU_T['enter_jid'] . ' ' ?>
<input type="text" name="jid" size="30" value="<?php echo htmlspecialchars($_REQUEST['jid']); ?>" /> <small><?php echo $JRU_T['enter_jid_note'] ?></small><br />
<?php echo $JRU_T['enter_password'] . ' ' ?>
<input type="password" name="password" size="20" value="<?php echo htmlspecialchars($_REQUEST['password']); ?>" />
</p>

<p>
<input type="submit" name="getroster" value="<?php echo $JRU_T['retrieve_roster'] ?>" />
</p>

<?php
if ($_REQUEST['getroster'] != '' ||
    $_REQUEST['updateroster'] != '')
{
	$jid = $_REQUEST['jid'];
	$password = $_REQUEST['password'];

	if (!preg_match('/^([!#$%(-.0-9;=?A-\xFF]+)@([a-z0-9.\\-]+)(:([0-9]+))?(::[a-z]+)?$/i', $jid, $m))
	{
		echo '<p><b class="error">' . $JRU_T['invalid_jid'] . '</b></p>';
		echo '</form>';
		echo '</body></html>';
		exit();
	}
	$username = $m[1];
	$server = $m[2];
	$port = $m[4] or $port = 5222;
	$params = $m[5];

	include('class.jabber.php');
	if (!class_exists('Jabber'))
	{
		echo '<p><b class="error">' . $JRU_T['cjp_not_found'] . '</b></p>';
		echo '</form>';
		echo '</body></html>';
		exit();
	}

	$connect_server = $server;
	// Google Talk auto-compatibility
	if ($connect_server == 'gmail.com') $connect_server = 'talk.google.com';
	if ($connect_server == 'googlemail.com') $connect_server = 'talk.google.com';

	$J = new Jabber();
	$J->server = $server;
	$J->connect_server = $connect_server;
	$J->port = $port;
	$J->username = $username;
	$J->password = $password;
	$J->resource = 'JRUPHP';

	if (strpos($params, 'log') !== false)
		$J->enable_logging = true;

	if (!$J->Connect())
	{
		echo '<p><b class="error">' . $JRU_T['error_connect'] . '</b></p>';
		echo '</form>';
		$J->Disconnect();
		echo '</body></html>';
		exit();
	}
	if (!$J->SendAuth())
	{
		echo '<p><b class="error">' . $JRU_T['error_auth'] . '</b></p>';
		echo '</form>';
		$J->Disconnect();
		echo '</body></html>';
		exit();
	}
}

if ($_REQUEST['updateroster'] != '')
{
	echo '<h2>' . $JRU_T['updating_roster'] . '</h2>';

	$add = array();
	$remove = array();

	$roster = explode("\n", $_REQUEST['roster']);
	foreach ($roster as $line)
	{
		$line = trim($line);
		$c = explodeQuoted(',', $line);
		if ($c[0] == '+')
		{
			$contact = array(
				'jid' => $c[1],
				'name' => $c[2],
				'sub' => $c[3],
				'group' => $c[4]);
			$add[] = $contact;
		}
		if ($c[0] == '-')
		{
			$contact = array(
				'jid' => $c[1],
				'name' => $c[2],
				'sub' => $c[3],
				'group' => $c[4]);
			$remove[] = $contact;
		}
	}

	echo '<p>';
	foreach ($remove as $contact)
	{
		$new_jid = trim($contact['jid']);
		echo $JRU_T['removing_jid'] . ' ' . htmlspecialchars($new_jid) . '<br />';
		$J->RosterRemoveUser($new_jid, NULL, false);
	}

	// Get the current roster and only update any changes to avoid subscription problems in the first place
	$J->RosterUpdate();
	if (is_array($J->roster))
	{
		foreach ($add as $newcontact)
		{
			$new_jid = trim($newcontact['jid']);
			$new_name = trim($newcontact['name']);
			$new_sub = trim($newcontact['sub']);
			$new_group = trim($newcontact['group']);

			$changed = true;
			// Find this jid from the current roster
			foreach ($J->roster as $contact)
			{
				if ($contact['jid'] == $new_jid)
				{
					// Found it. See if its data was changed
					$changed =
						$contact['name'] != $new_name ||
						$contact['subscription'] != $new_sub ||
						$contact['group'] != $new_group;
					break;
				}
			}
			if (!$changed) continue;

			echo $JRU_T['updating_jid'] . ' ' . htmlspecialchars($new_jid) . '<br />';

			$J->RosterAddUser($new_jid, NULL, $new_name, $new_group, false);
			if ($new_sub == 'none')
			{
				$J->Unsubscribe($new_jid);
				$J->SubscriptionDenyRequest($new_jid);
			}
			if ($new_sub == 'to')
			{
				$J->Subscribe($new_jid);
				$J->SubscriptionDenyRequest($new_jid);
			}
			if ($new_sub == 'from')
			{
				$J->Unsubscribe($new_jid);
				$J->SubscriptionAcceptRequest($new_jid);
			}
			if ($new_sub == 'both')
			{
				$J->Subscribe($new_jid);
				$J->SubscriptionAcceptRequest($new_jid);
			}
		}
	}
	else
	{
		echo '<b>' . $JRU_T['error_handling_roster'] . '</b>';
	}
	echo '</p>';

	echo '<p><b>' . $JRU_T['roster_updated'] . '</b></p>';
}

if ($_REQUEST['getroster'] != '' ||
    $_REQUEST['updateroster'] != '')
{
	$J->RosterUpdate();

	echo '<h2>' . $JRU_T['roster_contents'] . '</h2>';

	echo '<p>';
	echo $JRU_T['roster_contents_note'];
	echo '</p>';
	echo '<p>';
	echo $JRU_T['update_roster_note'];
	echo '</p>';

	echo '<p>';
	if (is_array($J->roster))
	{
		echo '<textarea name="roster" cols="80" rows="15">';
		foreach ($J->roster as $contact)
		{
			echo "+," .
				htmlspecialchars(quoteIfRequired(',', $contact['jid'])) . ',' .
				htmlspecialchars(quoteIfRequired(',', $contact['name'])) . ',' .
				quoteIfRequired(',', $contact['subscription']) . ',' .
				htmlspecialchars(quoteIfRequired(',', $contact['group'])) . "\n";
		}
		echo '</textarea>';
	}
	else
	{
		echo $JRU_T['error_handling_roster'];
	}
	echo '</p>';

	echo '<p>';
	echo '<input type="submit" name="updateroster" value="' . $JRU_T['update_roster'] . '" />';
	echo '</p>';

	$J->Disconnect();
}
?>

</form>

<hr />

<p>
<small><?php echo str_replace(array('{ver}', '{year}'), array('0.6.2', '2005-6'), $JRU_T['copyright']) ?></small>
</p>

</body>
</html>

<?php

function quoteIfRequired($sep, $str)
{
	if (strpos($str, $sep) !== false) return '"' . $str . '"';
	return $str;
}

// Same as PHP function explode(), but also splits by "..."
//
// in sep: separator character, see PHP explode()
// in str: string to split, see PHP explode()
// in mask_bs (bool): take case of \ characters, and ignore \" f.ex. [currently ignored to true]
// in keep (bool): keep the quotes around quoted parts
// out: array
//
function explodeQuoted($sep, $str, $mask_bs = true, $keep = false)
{
	$out = array();
	$len = strlen($str);
	$instr = false;   // are we currently inside a string?
	$pos = 0;         // current starting position
	$startpos = 0;    // remember last part beginning
	$pos_s = -1;      // position of ' ' (space) / separator
	$pos_q = -1;      // position of '"' (quote)

	$keep = $keep ? 1 : 0;   // keep " quotes

	while ($pos < $len)
	{
		if ($pos_s < $pos)   // only search if last result is before current position
			if (($pos_s = strpos($str, $sep, $pos)) === false) $pos_s = $len;
				// set pointer to end of string, if symbol was not found
		if ($pos_q < $pos)
			if (($pos_q = strpos($str, '"', $pos)) === false) $pos_q = $len;

		$minpos = min($pos_s, $pos_q);   // find the nearest interesting symbol

		if ($instr === false && $minpos === $pos_s)   // found a space/separator first (not inside a string)
		{
			$out[] = str_replace(
				'\\"',
				'"',
				substr($str, $startpos, $minpos - $startpos));
			$startpos = $pos = $minpos + 1;
		}
		elseif ($minpos === $pos_q)   // found a quote first
		{
			if ($minpos === $startpos && $instr === false)   // first symbol of this part AND not inside a string (must be so)
			{
				$instr = true;
				$startpos = $pos = $minpos - $keep + 1;   // jump over beginning "
			}
			elseif ($instr === true && $str{$minpos - 1} !== '\\' && ($str{$minpos + 1} === $sep
			                                                          || $minpos === $len - 1))
				// inside a string AND previous symbol is not \ AND next symbol is space/separator
				//                                                  OR no more characters (last symbol)
			{
				$instr = false;
				$out[] = str_replace(
					'\\"',
					'"',
					substr($str, $startpos, $minpos - $startpos + $keep));
				$startpos = $pos = $minpos + 2;   // jump over quote + separator
			}
			/*
			elseif ($instr === false && $str{$minpos - 1} === '\\')
				// not inside a string AND previous symbol is \
			*/
			else   // found something of no interest
			{
				$pos = $minpos + 1;
			}
		}
		else   // found something of no interest
		{
			$pos = $minpos + 1;
		}
	}

	// Something left?
	if ($startpos < $pos)
	{
		$out[] = str_replace(
			'\\"',
			'"',
			substr($str, $startpos, $pos - $startpos));
	}

	return $out;
}

?>