/*
 * MUCkl - A Web Based Groupchat Application
 * Copyright (C) 2004 Stefan Strigler <steve@zeank.in-berlin.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* ***
 * This is the main configuration file for the chat client itself.
 * You have to edit this before you can start using MUCkl on your website!
 * ***
 */

/* BACKENDTYPE - the type of backend to be used
 * 
 * Either 'polling' for HTTP Polling
 * Or     'binding' for HTTP Binding
 */
var BACKENDTYPE = 'polling';

/* HTTPBASE - base URI to contact HTTP Polling service
 * 
 * This must be local to your web server which serves MUCkl. If
 * HTTP Polling service is not local to your web server you have to
 * define a rewrite rule which matches this address and redirects to
 * the real HTTP Polling URI.
 * 
 * [refers to step 2 of installation instructions]
 */

var HTTPBASE = "polling/http-poll";

/* Login Data - the user to login
 * 
 * [refers to step 3 of installation instructions]
 */

var XMPPDOMAIN = "localhost"; // domain name of jabber service to be used

//var ANONHOST = "anonymous.zeank.darktech.org"; // hostname of sasl anonymous service 

var MUCKLJID = "muckl"; // username
var MUCKLPASS = "mucklpass"; // password

/* ROOMS
 *
 * Which chat room to join
 * 
 * [refers to step 4 of installation instructions]
 */

var ROOMS =
[
        {
                name:'talks',
                description:'the place to be...',
                server:'conference.localhost'
        },
        {
                name:'test',
                description:'some roome for testing',
                server:'conference.localhost',
								logo: 'http://zeank.darktech.org/spongebob.png' // if you want to have a logo displayed with this chat
        }
];

/* CONFERENCENOHIST
 * whether to not show room history upon joining 
 */
var CONFERENCENOHIST = false;

var MAX_MINS = 10; 

/* ***
 * some internally used vars - don't change except you really know
 * what you are doing
 * ***
 */

var timerval = 5000; // poll frequency in msec

var stylesheet = "muckl.css";
var THEMESDIR = "themes";

/* debugging options */
var DEBUG = false; // turn debugging on
var DEBUG_LVL = 2; // debug-level 0..4 (4 = very noisy)

/* ** Don't touch ** */
var VERSION = "0.4.2";
