// Copyright 2006 Grzegorz Grasza (wiki.gryf.info), Distributed under the terms of the GNU GPL

var pubsubXMLNS = 'http://jabber.org/protocol/pubsub'

function pubsubPacket()
{
  this.iq = JSJaCIQ
  this.iq()

  this.setPubsub = function()
  {
    var pubsub
    try
    {
      pubsub = this.getDoc().createElementNS(pubsubXMLNS, 'pubsub')
    }
    catch(e)
    {
      // fallback
      pubsub = this.getDoc().createElement('pubsub')
    }
    if(pubsub && pubsub.getAttribute('xmlns') != pubsubXMLNS) // fix opera 8.5x
      pubsub.setAttribute('xmlns', pubsubXMLNS)
    this.getNode().appendChild(pubsub)
    return pubsub
  }
  this.getPubsub = function()
  {
    return this.getNode().getElementsByTagName('pubsub').item(0);
  }
}

function pubsubItem(id)
{
  this.doc = XmlDocument.create()
  this.item = this.doc.appendChild(this.doc.createElement('item'))
  if(id)
    this.item.setAttribute('id', id)

  this.setItem = function(name, xmlns)
  {
    var child = this.doc.createElement(name)
    child.setAttribute('xmlns', xmlns)
    this.item.appendChild(child)
    return child
  }
  this.getItem = function(name)
  {
    return this.getNode().getElementsByTagName(name).item(0);
  }
}


function pubsubCreate(node, fun, del)
{
  var iq = new pubsubPacket()
  iq.setType('set')
  iq.setTo(pubsubdomain)
  var pubsub = iq.setPubsub()
  var create
  if(del)
    create = pubsub.appendChild(iq.getDoc().createElement('delete'))
  else
    create = pubsub.appendChild(iq.getDoc().createElement('create'))
  if(node)
    create.setAttribute('node', node)
  con.send(iq, pubsubIqHandler, [fun, pubsubParseNames])
}

function pubsubSubscribe(node, fun, jid, un)
{
  var iq = new pubsubPacket()
  iq.setType('set')
  iq.setTo(pubsubdomain)
  var pubsub = iq.setPubsub()
  var subscribe
  if(un)
    subscribe = pubsub.appendChild(iq.getDoc().createElement('unsubscribe'))
  else
    subscribe = pubsub.appendChild(iq.getDoc().createElement('subscribe'))
  subscribe.setAttribute('node', node)
  subscribe.setAttribute('jid', jid)
  con.send(iq, pubsubIqHandler, [fun])
}

function pubsubPublish(node, fun, items)
{
  var iq = new pubsubPacket()
  iq.setType('set')
  iq.setTo(pubsubdomain)
  var pubsub = iq.setPubsub()
  var publish = pubsub.appendChild(iq.getDoc().createElement('publish'))
  publish.setAttribute('node', node)
  for(var i = 0; i < items.length; ++i)
  {
    var item = items[i].item
    if (iq.getDoc().importNode)
      item = iq.getDoc().importNode(item,true);
    publish.appendChild(item)
  }
  con.send(iq, pubsubIqHandler, [fun])
}

function pubsubGetItems(node, fun, xmlns, number)
{
  var iq = new pubsubPacket()
  iq.setType('get')
  iq.setTo(pubsubdomain)
  var pubsub = iq.setPubsub()
  var items = pubsub.appendChild(iq.getDoc().createElement('items'))
  items.setAttribute('node', node)
  if(number)
    items.setAttribute('max_items', number)
  con.send(iq, pubsubIqHandler, [fun, pubsubParseItems, xmlns])
}

function pubsubGetNodes(node, fun)
{
  var iq = new JSJaCIQ()
  iq.setType('get')
  iq.setTo(pubsubdomain)
  var query = iq.setQuery('http://jabber.org/protocol/disco#items')
  if(node)
    query.setAttribute('node', node)
  con.send(iq, pubsubIqHandler, [fun, pubsubParseNodes])
}


function pubsubIqHandler(packet, xmlns_fun)
{
  handleIq(packet)
  if(packet.getType() == 'error')
  {
    xmlns_fun[0]('error')
    return
  }
  if(packet.getFrom().split('/')[0] == pubsubdomain)
  {
    var events = packet.getNode().getElementsByTagName('pubsub')
    if(events[0])
    {
      if(xmlns_fun[2])
        xmlns_fun[1](events, xmlns_fun[0], xmlns_fun[2])
      else if(xmlns_fun[1])
        xmlns_fun[1](events, xmlns_fun[0])
    }
    else
      xmlns_fun[0](packet.getType())
  }
}

function pubsubMessageHandler(packet, fun, xmlns)
{
  if(packet.getFrom().split('/')[0] == pubsubdomain)
  {
    var events = packet.getNode().getElementsByTagName('event')
    pubsubParseItems(events, fun, xmlns)
  }
}

function pubsubParseItems(events, fun, xmlns)
{
  for(var i = 0; i < events.length; ++i)
    if(events[i].getAttribute('xmlns') == pubsubXMLNS+'#event')
    {
      var itemss = events[i].childNodes
      for(var i = 0; i < itemss.length; ++i)
      {
        var node = itemss[i].getAttribute('node')
        var items = itemss[i].childNodes
        if (items.length == 0)
          fun('error', node)
        for(var i = 0; i < items.length; ++i)
        {
          var content = items[i].childNodes
          for(var i = 0; i < content.length; ++i)
            if(content[i].nodeType == 1 && content[i].getAttribute('xmlns') == xmlns)
              fun(node, content[i])
        }
      }
    }
}

function pubsubParseNodes(events, fun)
{
  for(var i = 0; i < events.length; ++i)
    if(events[i].getAttribute('xmlns') == pubsubXMLNS+'#event')
    {
      var itemss = events[i].childNodes
      for(var i = 0; i < itemss.length; ++i)
      {
        var node = itemss[i].getAttribute('node')
        var items = itemss[i].childNodes
        for(var i = 0; i < items.length; ++i)
        {
          var content = items[i].childNodes
          for(var i = 0; i < content.length; ++i)
            if(content[i].getAttribute  &&  content[i].getAttribute('xmlns') == xmlns)
              fun(node, content[i])
        }
      }
    }
}

function pubsubParseNames(events, fun)
{
  for(var i = 0; i < events.length; ++i)
    if(events[i].getAttribute('xmlns') == pubsubXMLNS)
    {
      var itemss = events[i].childNodes
      for(var i = 0; i < itemss.length; ++i)
      {
        var node = itemss[i].getAttribute('node')
        fun(node)
      }
    }
}
